go.modules.business.finance.PaymentGrid = Ext.extend(go.grid.GridPanel, {
	forEntity: false,
	initComponent: function () {
		let currentCurrency = go.User.currency;


		this.store = new go.data.Store({
			fields: [
				'id',
				'description',
				{name: 'date', type: 'date'},
				{name: 'customer', type: "relation", mapping: "customer.name"},
				{
					name: 'document',
					type: "promise",
					promise: async (data) => {

						if(!data.documentId) {
							return undefined;
						}

						const doc = await go.Db.store("FinanceDocument").single(data.documentId);

						if(!doc) {
							return undefined;
						}

						doc.book = await go.Db.store("FinanceBook").single(doc.bookId);

						return doc;
					}
				},
				'permissionLevel',
				{name: 'amount', type: "float"},
				"contraAccountName",
				"contraAccountNumber",
				'checked'
			],
			entityStore: "Payment",
			sortInfo: {
				field: "date",
				direction: "DESC"
			}
		});

		if(this.forEntity) {
			this.scrollLoader = false;
			this.store.baseParams.limit = 0;
		}


		function valutaRenderer(v) {
			// go.modules.business.finance.business.finance.currency
			return currentCurrency+"&nbsp;"+go.util.Format.number(v,2);
		}

		Ext.apply(this, {
			columns: [
				this.checkColumn = new GO.grid.CheckColumn({
					id: 'review',
					dataIndex: 'checked',
					hideInExport: true,
					header: '<i class="icon ic-check"></i>',
					width: dp(56),
					hideable: false,
					menuDisabled: true,
					sortable: false,
					groupable: false
				}),
				{
					xtype: "datecolumn",
					dateOnly: true,
					id: 'date',
					header: t('Date'),
					sortable: true,
					dataIndex: 'date'
				}, {
					id: "document",
					hidden: this.forEntity,
					dataIndex: "document",
					header: t("Document"),
					width: dp(200),
					renderer: function (doc, metaData, record) {
						if (!doc) {
							return "";
						}
						return doc.number + ' - ' + go.modules.business.finance.util.getStatusBadge(doc, "", doc.book);
					}
				}, {
					id: "documentTotal",
					hidden: this.forEntity,
					dataIndex: "document",
					header: t("Document total"),
					sortable: false,
					width: dp(100),
					renderer: function (doc, metaData, record) {
						if (!doc) {
							return "";
						}

						if (doc.totalPrice != record.data.amount) {
							metaData.css = "danger";
						}
						if(record.data.document.book && record.data.document.book.currency != currentCurrency) {
							currentCurrency = record.data.document.book.currency;
						}
						return currentCurrency + "&nbsp;" + go.util.Format.number(doc.totalPrice,2);
					}
				}, {
					id: "customer",
					dataIndex: "customer",
					header: t("Customer", "addressbook", "community"),
					width: dp(200),
					hidden: this.forEntity
				}, {
					align: "right",
					renderer: function (amount, metaData, record) {

						if (record.data.document && record.data.document.totalPrice != amount) {
							metaData.css = "danger";
						}
						if(record.data.document.book && record.data.document.book.currency != currentCurrency) {
							currentCurrency = record.data.document.book.currency;
						}
						return currentCurrency + "&nbsp;" + go.util.Format.number(amount,2);
					},
					summaryRenderer: this.valutarenderer,
					summaryType: 'SUM',
					dataIndex: "amount",
					hidden: false,
					header: t("Amount")
				}, {
					id: "description",
					dataIndex: "description",
					header: t("Description"),
					width: dp(200)
				}, {
					id: "contraAccountName",
					dataIndex: "contraAccountName",
					header: t("Account"),
					width: dp(200),
					hidden: this.forEntity
				}, {
					id: "contraAccountNumber",
					dataIndex: "contraAccountNumber",
					header: t("Number"),
					width: dp(200),
					hidden: this.forEntity
				}],
			viewConfig: {
				totalDisplay: !this.forEntity,
				emptyText: '<i>description</i><p>' + t("No items to display") + '</p>',
				actionConfig: {
					scope: this,
					menu: this.initMoreMenu()
				},
			},
			// stateful: true,
			// stateId: 'payment-grid'
		});

		go.modules.business.finance.PaymentGrid.superclass.initComponent.call(this);


		this.on('rowdblclick', (grid, rowIndex, e) => {
			const dlg = new go.modules.business.finance.PaymentDialog(), r = this.store.getAt(rowIndex);
			dlg.load(r.id).show();
		});

		this.on('keypress', (e) => {
			if (e.keyCode != e.ENTER) {
				return;
			}

			const r = this.getSelectionModel().getSelected();
			if (!r) {
				return;
			}

			const dlg = new go.modules.business.finance.PaymentDialog();
			dlg.load(r.id).show();
		});


		this.checkColumn.on('change', function (record) {
			this.getEl().mask(t("Saving..."));
			go.Db.store("Payment").save({checked: record.data.checked}, record.data.id).finally(() => {
				this.getEl().unmask();
			})
		}, this);
	},


	initMoreMenu: function () {
		this.moreMenu = new Ext.menu.Menu({
			items: [
				{
					itemId: "view",
					iconCls: 'ic-edit',
					text: t("Edit"),
					handler: function (item) {
						const dlg = new go.modules.business.finance.PaymentDialog(), r = this.store.getAt(item.parentMenu.rowIndex);
						dlg.load(r.id).show();
					},
					scope: this
				}
				, {
					itemId: "delete",
					disabled: !go.Modules.get("core", "core").userRights.mayChangeUsers,
					iconCls: 'ic-delete',
					text: t("Delete"),
					handler: function (item) {
						var record = this.store.getAt(item.parentMenu.rowIndex);

						this.getSelectionModel().selectRecords([record]);
						this.deleteSelected();
					},
					scope: this
				}
			]
		});

		return this.moreMenu
	},
});

