GO.mainLayout.on('authenticated', function() {
	if(go.Modules.isAvailable('legacy','filesearch') ) {
		Ext.override(GO.files.FilePanel, {

			keywords: [],

			keywordIndex: -1,

			initComponent: GO.files.FilePanel.prototype.initComponent.createInterceptor(function () {
				this.buttons = [
					this.previousKeywordButton = new Ext.Button({
						text: t("Previous keyword", "filesearch"),
						handler: function () {
							this.scrollToKeyword(true);
						},
						scope: this,
						disabled: true
					}),
					this.nextKeywordButton = new Ext.Button({
						text: t("Next keyword", "filesearch"),
						handler: function () {
							this.scrollToKeyword(false);
						},
						scope: this,
						disabled: true
					})];


			}).createSequence(function () {
				this.items.add(new Ext.Panel({
					autoScroll: true,
					stateId: 'filesearch-content-preview',
					collapsible: true,
					title: t("Content preview", "filesearch"),
					tpl: '<table class="display-panel" cellpadding="0" cellspacing="0" border="0">' +
						'<tr>' +
						'<td colspan="2" class="go-html-formatted">' +
						'<tpl if="text!=\'\'">{text:raw}</tpl>' +
						'<tpl if="text==\'\'">' + t("No preview available", "filesearch") + '</tpl>' +
						'</td>' +
						'</tr>' +
						'</tpl>' +
						'</table>' +
						'</tpl>'
				}));
			}),

			setData: GO.files.FilePanel.prototype.setData.createSequence(function () {

				var select = this.body.select('.fs-highlight');
				this.keywords = select.elements;
				this.keywordIndex = -1;

				this.updateKeywordButtons();
			}),

			updateKeywordButtons: function () {

				if (this.keywords.length == 0) {
					this.showBbar(true);
				} else {
					this.showBbar(false);
					this.nextKeywordButton.setDisabled(this.keywordIndex == (this.keywords.length - 1));
					this.previousKeywordButton.setDisabled(this.keywordIndex < 1);
				}
			},

			showBbar: function (hide) {
				this.footer.setDisplayed(!hide);
				this.onResize(this.getEl().getWidth(), this.getEl().getHeight());
			},

			scrollToKeyword: function (previous) {

				if (previous)
					this.keywordIndex--;
				else
					this.keywordIndex++;

				var el = Ext.get(this.keywords[this.keywordIndex]);
				el.scrollIntoView(this.body);

				this.updateKeywordButtons();
			},

			initTemplate: GO.files.FilePanel.prototype.initTemplate

				.createInterceptor(function () {
					this.extraTemplateProperties =
						'<tpl if="author!=\'\'">' +
						'<tr>' +
						'<td>' + t("Author", "filesearch") + ':</td>' +
						'<td>{author}</td>' +
						'</tr>' +
						'</tpl>' +
						'<tpl if="last_modified_by!=\'\'">' +
						'<tr>' +
						'<td>' + t("Last modified by", "filesearch") + ':</td>' +
						'<td>{last_modified_by}</td>' +
						'</tr>' +
						'</tpl>'
					;
				})
		});
	}
});
