/**
 * The setValue method is only relevant in the context of Project select fields
 */

go.modules.business.projects2.ProjectCombo = Ext.extend(GO.projects2.SelectProject, {
	setValue: function (id) {
		if (!id) {
			go.modules.business.projects2.ProjectCombo.superclass.setValue.call(this, id);
			return;
		}
		var r = this.findRecord(this.valueField, id);

		if (!r) {
			GO.request({
				url: 'projects2/project/load',
				params: {id: id},
				success: function (response, options, result) {
					var comboRecord = Ext.data.Record.create([{
						name: this.valueField
					}, {
						name: this.displayField
					}]);

					var recordData = {};

					if (this.store.fields && this.store.fields.keys) {
						for (var i = 0, l = this.store.fields.keys.length; i < l; i++) {
							recordData[this.store.fields.keys[i]] = "";
						}
					}

					recordData[this.valueField] = id;
					recordData[this.displayField] = result.data.name;

					var currentRecord = new comboRecord(recordData);
					this.store.add(currentRecord);
					go.modules.business.projects2.ProjectCombo.superclass.setValue.call(this, id);
				},
				scope: this
			});
		} else {
			go.modules.business.projects2.ProjectCombo.superclass.setValue.call(this, id);
		}
	}
});

Ext.reg("projectcombo", go.modules.business.projects2.ProjectCombo);
