Country flags in single CSS sprite
==================================

CSS Sprites - a method to optimize page loads by combining a large number of small images into one. 

## Usage

Include CSS file in your HTML code then insert a transparent 1x1 pixel image with classes `flag` and `flag-{country code}`. The country code is in the format ISO 3166-1 alpha-2:

```html
<html>
    <head>
        <link href="flags.css" rel=stylesheet type="text/css">
    </head>
    <body>
        <img src="blank.gif" class="flag flag-cz" alt="Czech Republic" />
    </body>
</html>
```

## Included flags


* Afghanistan (af)
* Afrique du Sud (za)
* Aland Islands (ax)
* Algérie (dz)
* Allemagne (de)
* Andorre (ad)
* Angola (ao)
* Anguilla (ai)
* Antigua-et-Barbuda (ag)
* Antilles néerlandaises (an)
* Arabie saoudite (sa)
* Aruba (aw)
* Bahamas (bs)
* Bahreïn (bh)
* Bangladesh (bd)
* Belarus (by)
* Belgique (be)
* Belize (bz)
* Bermudes (bm)
* Bhoutan (bt)
* Bosnie-Herzégovine (ba)
* Botswana (bw)
* Brunei Darussalam (bn)
* Brésil (br)
* Bulgarie (bg)
* Burkina Faso (bf)
* Burundi (bi)
* Bénin (bj)
* Cambodge (kh)
* Cameroun (cm)
* Canada (ca)
* Canary Islands (ic)
* Cap-Vert (cv)
* Chili (cl)
* Chypre (cy)
* Colombie (co)
* Comores (km)
* Congo (cg)
* Congo, La République démocratique du (cd)
* Corée, République de (kr)
* Corée, République populaire démocratique de (kp)
* Costa Rica (cr)
* Cote d&#39;Ivoire (ci)
* Croatie (hr)
* Cuba (cu)
* Curacao (cw)
* Danemark (dk)
* Djibouti (dj)
* Dominique (dm)
* Egypte (eg)
* El Salvador (sv)
* Equateur (ec)
* Espagne (es)
* Ethiopie (et)
* Fidji (fj)
* Finlande (fi)
* France (fr)
* Fédération de Russie (ru)
* Gabon (ga)
* Gambie (gm)
* Ghana (gh)
* Gibraltar (gi)
* Grenade (gd)
* Groenland (gl)
* Grèce (gr)
* Guam (gu)
* Guatemala (gt)
* Guernsey (gg)
* Guinée (gn)
* Guinée-Bissau (gw)
* Guyana (gy)
* Géorgie (ge)
* Géorgie du Sud et les îles Sandwich du Sud (gs)
* Haïti (ht)
* Honduras (hn)
* Hong Kong (hk)
* Hongrie (hu)
* Ile Maurice (mu)
* Iles Caïmans (ky)
* Iles Féroé (fo)
* Iles Salomon (sb)
* Iles Vierges américaines (vi)
* Indonésie (id)
* Irak (iq)
* Iran, République islamique d&#39; (ir)
* Isle of Man (im)
* Israël (il)
* Italie (it)
* Jersey (je)
* Jordanie (jo)
* Kazakhstan (kz)
* Kenya (ke)
* Kirghizistan (kg)
* Kiribati (ki)
* Koweït (kw)
* L&#39;Albanie (al)
* L&#39;Argentine (ar)
* L&#39;Arménie (am)
* L&#39;Australie (au)
* L&#39;Autriche (at)
* L&#39;Azerbaïdjan (az)
* L&#39;Estonie (ee)
* L&#39;Inde (in)
* L&#39;Irlande (ie)
* L&#39;Islande (is)
* L&#39;Union européenne (eu)
* L&#39;Érythrée (er)
* La Barbade (bb)
* La Bolivie, État plurinational de (bo)
* La Chine (cn)
* La Guinée équatoriale (gq)
* La Jamaïque (jm)
* La Lettonie (lv)
* La Norvège (no)
* La Pologne (pl)
* La Roumanie (ro)
* La Serbie (rs)
* La Slovaquie (sk)
* La Slovénie (si)
* La Suède (se)
* Le Japon (jp)
* Le Turkménistan (tm)
* Les îles Turks et Caicos (tc)
* Lesotho (ls)
* Liban (lb)
* Liberia (lr)
* Libya (ly)
* Liechtenstein (li)
* Lituanie (lt)
* Luxembourg (lu)
* Macao (mo)
* Macédoine, Ex-République yougoslave de (mk)
* Madagascar (mg)
* Malaisie (my)
* Malawi (mw)
* Maldives (mv)
* Mali (ml)
* Malte (mt)
* Maroc (ma)
* Martinique (mq)
* Mauritanie (mr)
* Mayotte (yt)
* Mexique (mx)
* Micronésie, États fédérés de (fm)
* Moldova, République de (md)
* Monaco (mc)
* Mongolie (mn)
* Montserrat (ms)
* Monténégro (me)
* Mozambique (mz)
* Myanmar (mm)
* Namibie (na)
* Nauru (nr)
* Nicaragua (ni)
* Niger (ne)
* Nigeria (ng)
* Niue (nu)
* Norfolk Island (nf)
* Nouvelle-Calédonie (nc)
* Nouvelle-Zélande (nz)
* Népal (np)
* Oman (om)
* Ouganda (ug)
* Ouzbékistan (uz)
* Pakistan (pk)
* Palau (pw)
* Panama (pa)
* Papouasie-Nouvelle-Guinée (pg)
* Paraguay (py)
* Pays-Bas (nl)
* Philippines (ph)
* Pitcairn (pn)
* Polynésie française (pf)
* Populaire lao République démocratique (la)
* Portugal (pt)
* Puerto Rico (pr)
* Pérou (pe)
* Qatar (qa)
* Royaume-Uni (gb)
* Rwanda (rw)
* République Dominicaine (do)
* République arabe syrienne (sy)
* République centrafricaine (cf)
* République tchèque (cz)
* Sahara occidental (eh)
* Saint Barthelemy (bl)
* Saint Martin (mf)
* Saint-Kitts-et-Nevis (kn)
* Saint-Marin (sm)
* Saint-Siège (État de la Cité du Vatican) (va)
* Saint-Vincent-et-les Grenadines (vc)
* Sainte-Hélène (sh)
* Sainte-Lucie (lc)
* Samoa (ws)
* Samoa américaines (as)
* Sao Tomé et Principe (st)
* Seychelles (sc)
* Sierra Leone (sl)
* Singapour (sg)
* Somalie (so)
* Soudan (sd)
* Soudan du Sud (ss)
* Sri Lanka (lk)
* Suisse (ch)
* Suriname (sr)
* Swaziland (sz)
* Sénégal (sn)
* Tadjikistan (tj)
* Taiwan, Province de Chine (tw)
* Tanzanie (tz)
* Tchad (td)
* Terres australes françaises (tf)
* Territoires palestiniens (ps)
* Thaïlande (th)
* Timor-Leste (tl)
* Togo (tg)
* Tokélaou (tk)
* Tonga (to)
* Trinité-et-Tobago (tt)
* Tunisie (tn)
* Turquie (tr)
* Tuvalu (tv)
* Ukraine (ua)
* Uruguay (uy)
* Vanuatu (vu)
* Venezuela, République bolivarienne du (ve)
* Viet Nam (vn)
* Wallis et Futuna (wf)
* Yémen (ye)
* Zambie (zm)
* Zimbabwe (zw)
* Émirats arabes unis (ae)
* États-Unis (us)
* Îles Cook (ck)
* Îles Falkland (Malvinas) (fk)
* Îles Mariannes du Nord (mp)
* Îles Marshall (mh)
* Îles Vierges britanniques (vg)

## Links

* [CSS Flag Sprites generator](https://www.flag-sprites.com/ "Country flags in single CSS sprite")
* [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)