/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component } from "./Component.js";
import { CardContainer } from "./CardContainer.js";
import { Config } from "./Observable";
/**
 * Menu for cards to create a tab panel
 *
 * @example
 *
 * this.personal = Personal.create();
 *
 * this.cardContainer = CardContainer.create({
 * 	cls: "cards",
 * 	items: [
 * 		this.personal
 * 	]
 * });
 *
 * this.cardMenu = CardMenu.create({
 * 	cardContainer: this.cardContainer,
 * 	items: [
 *
 * 		// Dynamically load module and add it to card container when this button is clicked
 * 		CardMenuAsyncItem.create({
 * 			text: "Contracts",
 * 			import: "Contracts"
 * 		}),
 *
 * 		// Dynamically load module and add it to card container when this button is clicked
 * 		CardMenuAsyncItem.create({
 * 			text: "Invoices",
 * 			import: "Invoices"
 * 		})
 * 	]
 * });
 *
 */
export declare class CardMenu extends Component {
    /**
     * The card container this menu is for.
     *
     * If not given it will be looked up in the parent of the menu.
     */
    cardContainer?: CardContainer;
    protected baseCls: string;
    focus(o?: FocusOptions): void;
    constructor();
    private updateActiveTab;
    private createMenu;
}
/**
 * Shorthand function to create {@see CardMenu}
 *
 * @param config
 * @param items
 */
export declare const cardmenu: (config?: Config<CardMenu>, ...items: Component[]) => CardMenu;
//# sourceMappingURL=CardMenu.d.ts.map