/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config, Listener, ObservableListenerOpts } from "../Observable.js";
import { Component } from "../Component.js";
export type ContainerFieldValue = Record<string, any>;
export interface ContainerField<ValueType extends ContainerFieldValue = ContainerFieldValue> extends Field {
    on<K extends keyof FieldEventMap<this>, L extends Listener>(eventName: K, listener: Partial<FieldEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof FieldEventMap<this>>(eventName: K, listener: Partial<FieldEventMap<this>>[K]): boolean;
    fire<K extends keyof FieldEventMap<this>>(eventName: K, ...args: Parameters<FieldEventMap<Component>[K]>): boolean;
    set value(v: Partial<ValueType>);
    get value(): ValueType;
}
/**
 * Field that contains fields.
 *
 * The value that it returns is an object with the field names as keys.
 */
export declare class ContainerField<ValueType extends ContainerFieldValue = ContainerFieldValue> extends Field {
    constructor(tagName?: keyof HTMLElementTagNameMap);
    protected baseCls: string;
    hideLabel: boolean;
    protected fireChangeOnBlur: boolean;
    /**
     * Find all form fields
     *
     * @param nameOrItemId If given only items with matching name or itemId are returned
     */
    findFields(nameOrItemId?: string | undefined): Field[];
    /**
     * Find form field by name or item ID
     *
     * It cascades down the component hierarchy.
     *
     * @param nameOrItemId
     */
    findField<FieldType extends Field = Field>(nameOrItemId: string): FieldType | undefined;
    /**
     * Copies the current value to the reset value. Typically happens when this component was added to a parent and
     * when the form it belongs too loads.
     */
    trackReset(): void;
    isModified(): boolean;
    protected internalSetValue(v: Partial<ValueType>): void;
    protected internalGetValue(): ValueType;
    protected validate(): void;
    /**
     * Find the first invalid field
     */
    findFirstInvalid(): Field | undefined;
    protected renderControl(): void;
    clearInvalid(): void;
    /**
     * Not needed on container field as the fields within handle this.
     */
    validateOnBlur: boolean;
    protected applyInvalidMsg(): void;
    /**
     * @inheritDoc
     */
    focus(o?: FocusOptions): void;
}
/**
 * Shorthand function to create {@see ContainerField}
 *
 * @param config
 * @param items
 */
export declare const containerfield: (config?: Config<ContainerField, FieldEventMap<ContainerField>>, ...items: Component[]) => ContainerField<ContainerFieldValue>;
//# sourceMappingURL=ContainerField.d.ts.map