/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component } from "./Component.js";
import { Config } from "./Observable";
export declare class Avatar extends Component {
    protected baseCls: string;
    static colors: string[];
    set displayName(displayName: string);
    get displayName(): string;
    set backgroundImage(imgUrl: string | undefined);
    get backgroundImage(): string;
    /**
     * Grabs the first char of the first and last word.
     *
     * @param {string} name
     * @returns {string}
     */
    private initials;
}
/**
 * Shorthand function to create {@see Avatar}
 *
 * @param config
 */
export declare const avatar: (config?: Config<Avatar>) => Avatar;
//# sourceMappingURL=Avatar.d.ts.map