create table business_automation_automation
(
    id           int auto_increment
        primary key,
    createdBy    int                       not null,
    createdAt    datetime                  not null,
    modifiedBy   int                       not null,
    modifiedAt   datetime                  null,
    nextRunAt    datetime                  null,
    name         varchar(190)              null,
    entityTypeId int                       null,
    filter       text                      null,
    cron         varchar(50)               null,
    actionType   varchar(50)               null,
    runningSince datetime                  null,
    lastRunAt    datetime                  null,
    waitInterval varchar(50) default 'P7D' null,
    constraint business_automation_automation_core_entity_id_fk
        foreign key (entityTypeId) references core_entity (id)
            on update cascade
);

create table business_automation_action_email
(
    automationId int          not null,
    recipient    varchar(190) not null,
    accountId    int          not null,
    bcc varchar(190) default '' not null,
    primary key (automationId),
    constraint business_automation_action_email_id_fk
        foreign key (automationId) references business_automation_automation (id)
            on update cascade
);

create table business_automation_log
(
    automationId int      not null,
    entityId     int      not null,
    lastRunAt    datetime null,
    primary key (automationId, entityId),
    constraint business_automation_action_email_automationId_fk
        foreign key (automationId) references business_automation_automation (id)
            on delete cascade
);

