go.modules.business.automation.AutomationGrid = Ext.extend(go.grid.GridPanel, {
	initComponent: function () {
		this.frontendConfig = go.modules.business.automation.ModuleConfig.frontendOptions;

		this.store = new go.data.Store({
			fields: [
				'id',
				'name',
				{name: 'lastRunAt', type: 'date'},
				{name: 'nextRunAt', type: 'date'},
				{name: 'createdAt', type: 'date'},
				{name: 'modifiedAt', type: 'date'},
				{name: 'creator', type: "relation"},
				{name: 'modifier', type: "relation"},
				'permissionLevel'
			],
			sortInfo: {field: "id", direction: go.modules.business.automation.ModuleConfig.entityOptions.defaultIdSortDirection},
			entityStore: "Automation"
		});

		Ext.apply(this, {
			columns: [{
				id: 'id',
				hidden: true,
				header: 'ID',
				width: dp(60),
				sortable: true,
				dataIndex: 'id'
			},{
				id: 'name',
				header: t("Name"),
				width: dp(200),
				sortable: true,
				dataIndex: 'name'
			},{
				xtype:"datecolumn",
				id: 'lastRunAt',
				header: t('Last run at'),
				sortable: true,
				dataIndex: 'lastRunAt',
				shortDate: false
			},{
				xtype:"datecolumn",
				id: 'nextRunAt',
				header: t('Next run at'),
				sortable: true,
				dataIndex: 'nextRunAt',
				shortDate: false
			},{
				hidden: !this.frontendConfig.showCreator,
				id: 'showCreator',
				header: t('Created by'),
				width: dp(160),
				sortable: true,
				dataIndex: 'creator',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				id: 'showCreationDate',
				header: t('Created at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'createdAt',
				hidden: !this.frontendConfig.showCreationDate
			},{
				hidden: !this.frontendConfig.showModifier,
				header: t('Modified by'),
				width: dp(160),
				sortable: true,
				id: 'showModifier',
				dataIndex: 'modifier',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				hidden: !this.frontendConfig.showModificationDate,
				id: 'showModificationDate',
				header: t('Modified at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'modifiedAt'
			}],
			viewConfig: {
				totalDisplay: this.frontendConfig.showTotals,
				emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
			},
			autoExpandColumn: "name",
			stateful: true,
			stateId: 'Automation-grid'
		});

		go.modules.business.automation.AutomationGrid.superclass.initComponent.call(this);
	}
});

