create table business_activity
(
    id            int unsigned auto_increment
        primary key,
    type          smallint         default 1 not null,
    code          varchar(11)                not null,
    name          varchar(50)                not null,
    units         double                     not null,
    description   text                       null,
    disabled      tinyint(1)       default 0 null,
    billable      tinyint          default 0 null,
    budgetable    tinyint          default 0 null,
    budgetExpires tinyint(1)       default 0 null,
    sortOrder     int(11) unsigned default 0 not null
);

create table business_agreement
(
    id         int unsigned auto_increment
        primary key,
    employeeId int               not null,
    start      date              not null,
    finish     date              null,
    mo         smallint unsigned not null,
    tu         smallint unsigned not null,
    we         smallint unsigned not null,
    th         smallint unsigned not null,
    fr         smallint unsigned not null,
    sa         smallint unsigned not null,
    su         smallint unsigned not null,
    constraint fk_business_agreement_business_employee1
        foreign key (employeeId) references core_user (id)
            on delete cascade
);

create table business_activity_budget
(
    agreementId int unsigned    not null,
    activityId  int unsigned    not null,
    budget      float default 0 not null,
    primary key (agreementId, activityId),
    constraint fk_business_activity_budget_business_activity1
        foreign key (activityId) references business_activity (id)
            on delete cascade,
    constraint fk_business_activity_budget_business_employee_agreement1
        foreign key (agreementId) references business_agreement (id)
            on delete cascade
);

create index fk_business_activity_budget_business_activity1_idx
    on business_activity_budget (activityId);

create index fk_business_activity_budget_business_employee_agreement1_idx
    on business_activity_budget (agreementId);

create index fk_business_agreement_business_employee1_idx
    on business_agreement (employeeId);

create table business_business
(
    id               int unsigned auto_increment
        primary key,
    name             varchar(100) not null,
    hourlyRevenue    float        null,
    contactId        int          null,
    defaultVatRateId int unsigned null,
    aclId            int          not null,
    constraint business_business_core_acl_id_fk
        foreign key (aclId) references core_acl (id),
    constraint fk_business_business_addressbook_contact
        foreign key (contactId) references addressbook_contact (id)
            on delete set null
);

create index defaultVatRateId
    on business_business (defaultVatRateId);

create index fk_business_business_addressbook_contact_idx
    on business_business (contactId);

create table business_business_custom_fields
(
    id int unsigned not null,
    primary key (id),
    constraint business_business_custom_fields_ibfk_1
        foreign key (id) references business_business (id)
            on delete cascade
);

create table business_business_vat_rate
(
    id         int unsigned auto_increment
        primary key,
    businessId int unsigned   not null,
    name       varchar(190)   not null,
    rate       decimal(19, 4) not null,
    sortOrder int unsigned not null default 0,
    enabled boolean default 1 null,
    constraint business_business_vat_rate_ibfk_1
        foreign key (businessId) references business_business (id)
            on delete cascade
);

alter table business_business
    add constraint business_business_ibfk_1
        foreign key (defaultVatRateId) references business_business_vat_rate (id)
            on delete set null;

alter table business_business
    add constraint business_business_ibfk_2
        foreign key (defaultVatRateId) references business_business_vat_rate (id)
            on delete set null;

create index businessId
    on business_business_vat_rate (businessId);

create table business_employee
(
    id              int             not null,
    businessId      int unsigned    not null,
    timeClosedUntil date            null,
    quitAt          date            null,
    hourlyRevenue   float default 0 not null,
    hourlyCosts     float default 0 not null,
    primary key (id),
    constraint fk_business_employee_business_business1
        foreign key (businessId) references business_business (id)
            on delete cascade,
    constraint fk_business_employee_core_user1
        foreign key (id) references core_user (id)
            on delete cascade
);

create table business_activity_rate
(
    employeeId   int          not null,
    activityId   int unsigned not null,
    externalRate float        not null,
    primary key (employeeId, activityId),
    constraint fk_business_employee_activity_business_activity1
        foreign key (activityId) references business_activity (id)
            on delete cascade,
    constraint fk_business_employee_activity_business_employee1
        foreign key (employeeId) references business_employee (id)
            on delete cascade
);

create index fk_business_employee_activity_business_activity1_idx
    on business_activity_rate (activityId);

create index fk_business_employee_activity_business_employee1_idx
    on business_activity_rate (employeeId);

create index fk_business_employee_business_business1_idx
    on business_employee (businessId);

create table business_manager
(
    subjectId int                  not null,
    managerId int                  not null,
    notified  tinyint(1) default 1 not null,
    primary key (subjectId, managerId),
    constraint fk_business_employeebusiness_employee_business_employee1
        foreign key (subjectId) references business_employee (id),
    constraint fk_business_employeebusiness_employee_business_employee2
        foreign key (managerId) references business_employee (id),
    constraint fk_business_employeecore_user_core_user1
        foreign key (subjectId) references core_user (id)
            on delete cascade,
    constraint fk_business_employeecore_user_core_user2
        foreign key (managerId) references core_user (id)
            on delete cascade
);

create index fk_business_employeebusiness_employee_business_employee1_idx
    on business_manager (subjectId);

create index fk_business_employeebusiness_employee_business_employee2_idx
    on business_manager (managerId);

create table business_business_category
(
    id         int unsigned NOT null auto_increment,
    businessId int unsigned not null,
    name       varchar(40)  not null,
    isHours boolean not null default false,
        constraint business_business_category_pk
        primary key (id),
    constraint business_business_category_business_business_id_fk
        foreign key (businessId) references business_business (id)
            on delete cascade
);

