/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @version $Id: StandardTaskGrid.js 23462 2018-03-06 11:37:47Z mschering $
 * @copyright Copyright Intermesh
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
Ext.define('go.modules.business.business.ActivityGrid', {
	extend: go.grid.GridPanel,

	initComponent : function(){
		Ext.apply(this,{
			tbar: [{
				xtype: 'tbtitle',
				text: t("Activities")
			},'->',{
				iconCls: "ic-add",
				handler: function() {
					const dlg = new go.modules.business.business.ActivityDialog();
					dlg.show();
				},scope: this
			}],
			plugins : [new go.grid.plugin.Sortable(this.onSort, this, this.isDropAllowed)],
			store: new go.data.Store({
				fields: [
					'id',
					{name: 'code', type: 'string'},
					{name: 'type', type: 'int'},
					{name: 'sortOrder', type: 'int'},
					{name: 'name', type: 'string'},
					{name: 'description', type: 'string'},
					{name: 'units', type: 'float'},
					{name: 'billable', type: 'int'},
					{name: 'budgetable', type: 'boolean'},
					{name: 'disabled', type: 'boolean'},
					{name: 'budgetTransferable', type: 'boolean'}
				],
				sortInfo :{field: "sortOrder"},
				entityStore: "Activity"
			}),
			listeners: {
				rowdblclick: function (grid, rowIndex, e) {
					const record = grid.getStore().getAt(rowIndex);
					this.edit(record.id);
				},
				scope:this
			},
			viewConfig: {
				getRowClass : function(row, index) {
					if (row.data.disabled === true) {
						return 'go-grid-row-inactive';
					}
				},
				actionConfig: {
					scope: this,
					menu: this.initMoreMenu()
				}
			},
			border: false,
			paging:true,
			autoExpandColumn: 'description',
			columns:[{
				header: t("Code", "projects2"),
				dataIndex: 'code',
				hidden:true,
				width: 60
			},{
				header: t("Name"),
				dataIndex: 'name',
				width: 200,
				renderer: function(v,meta,r) {
					let icon = "event_busy";
					switch (parseInt(r.data.type)) {
						case 1:
							icon = 'business_center'
							break;
						case 2:
							icon = "beach_access";
							break;
						case 3:
							icon = "transfer_within_a_station";
							break;
						default:
							break;

					}
					return '<i class="icon">'+ icon +'</i> '+v;
				}
			},{
				header: t("Description"),
				id: 'description',
				dataIndex: 'description',
				renderer: function(value){
					return value.replace(/<br[^>]*>/gi," "); //hide those newlines in the grid
				}
			},{
				header: t("Duration"),
				dataIndex: 'units',
				width: 70,
				align:'right',
				renderer: function(v) { return v+' '+t('Hours');}
			},{
				header: t("Billable"),
				dataIndex: 'billable',
				width: 80,
				renderer: function(v) {return v==2 ? t('Always') : (v ? t('Yes') : t('No')); }
			},{
				header: t("Budgetable", "business", "business"),
				dataIndex: 'budgetable',
				width: 60,
				renderer: go.grid.ColumnRenderers.check
			},{
				header: t("Transferable", "business", "business"),
				dataIndex: 'budgetTransferable',
				hidden: true, // This checkbox has been replaced by special leave budgets, i.e. activities with typeId 4
				width: 60,
				renderer: go.grid.ColumnRenderers.check
			}]
		});
		this.callParent();
	},

	onSort: function(sortable, selections, dragData, dd) {
		let updates = {};
		let records = dragData.dropRecord.store.data;
		for (let i = 0, l = records.items.length; i < l; i++) {
			const currRcd = records.items[i];
			updates[currRcd.id] = {sortOrder: i};
		}
		const me=this;
		go.Db.store("Activity").set({
			update: updates
		}, function() {
			me.store.load();
		}, this);
	},

	isDropAllowed: function (selections, overRecord) {
		return true;
	},

	initMoreMenu : function() {
		this.moreMenu = new Ext.menu.Menu({
			items: [
				{
					itemId: "edit",
					iconCls: 'ic-edit',
					text: t("Edit"),
					handler: (item) => {
						const record = this.store.getAt(item.parentMenu.rowIndex);
						this.edit(record.id);
					},
				},{
					itemId:"delete",
					iconCls: 'ic-delete',
					text: t("Delete"),
					handler: (item) => {
						const record = this.store.getAt(item.parentMenu.rowIndex);
						this.getSelectionModel().selectRecords([record]);
						this.deleteSelected();
					},
				}
			]
		});
		return this.moreMenu;
	},

	edit: function(id) {
		const dlg = new go.modules.business.business.ActivityDialog();
		dlg.load(id).show();
	}
});
