<?php

declare(strict_types=1);

namespace easybill\eInvoicing\Enums;

enum CurrencyCode: string
{
    // UAE Dirham
    case AED = 'AED';

    // Afghani
    case AFN = 'AFN';

    // Lek
    case ALL = 'ALL';

    // Armenian Dram
    case AMD = 'AMD';

    // Netherlands Antillean Guilder
    case ANG = 'ANG';

    // Kwanza
    case AOA = 'AOA';

    // Argentine Peso
    case ARS = 'ARS';

    // Australian Dollar
    case AUD = 'AUD';

    // Aruban Florin
    case AWG = 'AWG';

    // Azerbaijan Manat
    case AZN = 'AZN';

    // Convertible Mark
    case BAM = 'BAM';

    // Barbados Dollar
    case BBD = 'BBD';

    // Taka
    case BDT = 'BDT';

    // Bulgarian Lev
    case BGN = 'BGN';

    // Bahraini Dinar
    case BHD = 'BHD';

    // Burundi Franc
    case BIF = 'BIF';

    // Bermudian Dollar
    case BMD = 'BMD';

    // Brunei Dollar
    case BND = 'BND';

    // Boliviano
    case BOB = 'BOB';

    // Mvdol
    case BOV = 'BOV';

    // Brazilian Real
    case BRL = 'BRL';

    // Bahamian Dollar
    case BSD = 'BSD';

    // Ngultrum
    case BTN = 'BTN';

    // Pula
    case BWP = 'BWP';

    // Belarusian Ruble
    case BYN = 'BYN';

    // Belize Dollar
    case BZD = 'BZD';

    // Canadian Dollar
    case CAD = 'CAD';

    // Congolese Franc
    case CDF = 'CDF';

    // WIR Euro
    case CHE = 'CHE';

    // Swiss Franc
    case CHF = 'CHF';

    // WIR Franc
    case CHW = 'CHW';

    // Unidad de Fomento
    case CLF = 'CLF';

    // Chilean Peso
    case CLP = 'CLP';

    // Yuan Renminbi
    case CNY = 'CNY';

    // Colombian Peso
    case COP = 'COP';

    // Unidad de Valor Real
    case COU = 'COU';

    // Costa Rican Colon
    case CRC = 'CRC';

    // Peso Convertible
    case CUC = 'CUC';

    // Cuban Peso
    case CUP = 'CUP';

    // Cabo Verde Escudo
    case CVE = 'CVE';

    // Czech Koruna
    case CZK = 'CZK';

    // Djibouti Franc
    case DJF = 'DJF';

    // Danish Krone
    case DKK = 'DKK';

    // Dominican Peso
    case DOP = 'DOP';

    // Algerian Dinar
    case DZD = 'DZD';

    // Egyptian Pound
    case EGP = 'EGP';

    // Nakfa
    case ERN = 'ERN';

    // Ethiopian Birr
    case ETB = 'ETB';

    // Euro
    case EUR = 'EUR';

    // Fiji Dollar
    case FJD = 'FJD';

    // Falkland Islands Pound
    case FKP = 'FKP';

    // Pound Sterling
    case GBP = 'GBP';

    // Lari
    case GEL = 'GEL';

    // Ghana Cedi
    case GHS = 'GHS';

    // Gibraltar Pound
    case GIP = 'GIP';

    // Dalasi
    case GMD = 'GMD';

    // Guinean Franc
    case GNF = 'GNF';

    // Quetzal
    case GTQ = 'GTQ';

    // Guyana Dollar
    case GYD = 'GYD';

    // Hong Kong Dollar
    case HKD = 'HKD';

    // Lempira
    case HNL = 'HNL';

    // Kuna
    case HRK = 'HRK';

    // Gourde
    case HTG = 'HTG';

    // Forint
    case HUF = 'HUF';

    // Rupiah
    case IDR = 'IDR';

    // New Israeli Sheqel
    case ILS = 'ILS';

    // Indian Rupee
    case INR = 'INR';

    // Iraqi Dinar
    case IQD = 'IQD';

    // Iranian Rial
    case IRR = 'IRR';

    // Iceland Krona
    case ISK = 'ISK';

    // Jamaican Dollar
    case JMD = 'JMD';

    // Jordanian Dinar
    case JOD = 'JOD';

    // Yen
    case JPY = 'JPY';

    // Kenyan Shilling
    case KES = 'KES';

    // Som
    case KGS = 'KGS';

    // Riel
    case KHR = 'KHR';

    // Comorian Franc
    case KMF = 'KMF';

    // North Korean Won
    case KPW = 'KPW';

    // Won
    case KRW = 'KRW';

    // Kuwaiti Dinar
    case KWD = 'KWD';

    // Cayman Islands Dollar
    case KYD = 'KYD';

    // Tenge
    case KZT = 'KZT';

    // Lao Kip
    case LAK = 'LAK';

    // Lebanese Pound
    case LBP = 'LBP';

    // Sri Lanka Rupee
    case LKR = 'LKR';

    // Liberian Dollar
    case LRD = 'LRD';

    // Loti
    case LSL = 'LSL';

    // Libyan Dinar
    case LYD = 'LYD';

    // Moroccan Dirham
    case MAD = 'MAD';

    // Moldovan Leu
    case MDL = 'MDL';

    // Malagasy Ariary
    case MGA = 'MGA';

    // Denar
    case MKD = 'MKD';

    // Kyat
    case MMK = 'MMK';

    // Tugrik
    case MNT = 'MNT';

    // Pataca
    case MOP = 'MOP';

    // Ouguiya
    case MRU = 'MRU';

    // Mauritius Rupee
    case MUR = 'MUR';

    // Rufiyaa
    case MVR = 'MVR';

    // Malawi Kwacha
    case MWK = 'MWK';

    // Mexican Peso
    case MXN = 'MXN';

    // Mexican Unidad de Inversion (UDI)
    case MXV = 'MXV';

    // Malaysian Ringgit
    case MYR = 'MYR';

    // Mozambique Metical
    case MZN = 'MZN';

    // Namibia Dollar
    case NAD = 'NAD';

    // Naira
    case NGN = 'NGN';

    // Cordoba Oro
    case NIO = 'NIO';

    // Norwegian Krone
    case NOK = 'NOK';

    // Nepalese Rupee
    case NPR = 'NPR';

    // New Zealand Dollar
    case NZD = 'NZD';

    // Rial Omani
    case OMR = 'OMR';

    // Balboa
    case PAB = 'PAB';

    // Sol
    case PEN = 'PEN';

    // Kina
    case PGK = 'PGK';

    // Philippine Peso
    case PHP = 'PHP';

    // Pakistan Rupee
    case PKR = 'PKR';

    // Zloty
    case PLN = 'PLN';

    // Guarani
    case PYG = 'PYG';

    // Qatari Rial
    case QAR = 'QAR';

    // Romanian Leu
    case RON = 'RON';

    // Serbian Dinar
    case RSD = 'RSD';

    // Russian Ruble
    case RUB = 'RUB';

    // Rwanda Franc
    case RWF = 'RWF';

    // Saudi Riyal
    case SAR = 'SAR';

    // Solomon Islands Dollar
    case SBD = 'SBD';

    // Seychelles Rupee
    case SCR = 'SCR';

    // Sudanese Pound
    case SDG = 'SDG';

    // Swedish Krona
    case SEK = 'SEK';

    // Singapore Dollar
    case SGD = 'SGD';

    // Saint Helena Pound
    case SHP = 'SHP';

    // Leone
    case SLL = 'SLL';

    // Somali Shilling
    case SOS = 'SOS';

    // Surinam Dollar
    case SRD = 'SRD';

    // South Sudanese Pound
    case SSP = 'SSP';

    // Dobra
    case STN = 'STN';

    // El Salvador Colon
    case SVC = 'SVC';

    // Syrian Pound
    case SYP = 'SYP';

    // Lilangeni
    case SZL = 'SZL';

    // Baht
    case THB = 'THB';

    // Somoni
    case TJS = 'TJS';

    // Turkmenistan New Manat
    case TMT = 'TMT';

    // Tunisian Dinar
    case TND = 'TND';

    // Pa’anga
    case TOP = 'TOP';

    // Turkish Lira
    case TRY = 'TRY';

    // Trinidad and Tobago Dollar
    case TTD = 'TTD';

    // New Taiwan Dollar
    case TWD = 'TWD';

    // Tanzanian Shilling
    case TZS = 'TZS';

    // Hryvnia
    case UAH = 'UAH';

    // Uganda Shilling
    case UGX = 'UGX';

    // US Dollar
    case USD = 'USD';

    // US Dollar (Next day)
    case USN = 'USN';

    // Uruguay Peso en Unidades Indexadas (UI)
    case UYI = 'UYI';

    // Peso Uruguayo
    case UYU = 'UYU';

    // Unidad Previsional
    case UYW = 'UYW';

    // Uzbekistan Sum
    case UZS = 'UZS';

    // Bolívar Soberano
    case VES = 'VES';

    // Dong
    case VND = 'VND';

    // Vatu
    case VUV = 'VUV';

    // Tala
    case WST = 'WST';

    // CFA Franc BEAC
    case XAF = 'XAF';

    // Silver
    case XAG = 'XAG';

    // Gold
    case XAU = 'XAU';

    // Bond Markets Unit European Composite Unit (EURCO)
    case XBA = 'XBA';

    // Bond Markets Unit European Monetary Unit (E.M.U.-6)
    case XBB = 'XBB';

    // Bond Markets Unit European Unit of Account 9 (E.U.A.-9)
    case XBC = 'XBC';

    // Bond Markets Unit European Unit of Account 17 (E.U.A.-17)
    case XBD = 'XBD';

    // East Caribbean Dollar
    case XCD = 'XCD';

    // SDR (Special Drawing Right)
    case XDR = 'XDR';

    // CFA Franc BCEAO
    case XOF = 'XOF';

    // Palladium
    case XPD = 'XPD';

    // CFP Franc
    case XPF = 'XPF';

    // Platinum
    case XPT = 'XPT';

    // Sucre
    case XSU = 'XSU';

    // Codes specifically reserved for testing purposes
    case XTS = 'XTS';

    // ADB Unit of Account
    case XUA = 'XUA';

    // The codes assigned for transactions where no currency is involved
    case XXX = 'XXX';

    // Yemeni Rial
    case YER = 'YER';

    // Rand
    case ZAR = 'ZAR';

    // Zambian Kwacha
    case ZMW = 'ZMW';

    // Zimbabwe Dollar
    case ZWL = 'ZWL';
}
