GO.mainLayout.on("authenticated", function() {

	if (go.Modules.isAvailable("business", "finance")) {

		Ext.override(go.modules.community.addressbook.ContactDetail, {

			initComponent: go.modules.community.addressbook.ContactDetail.prototype.initComponent.createSequence(function () {
				this.add(new go.modules.business.finance.FinanceDocumentDetailPayments());
			}),
			initToolbar: go.modules.community.addressbook.ContactDetail.prototype.initToolbar.createSequence(function () {

				this.downloadStatementMenu = new go.menu.StoreMenu({
					cls: "x-menu-no-icons",
					displayField: "name",
					store: new go.data.Store({
						fields: ['id', 'name'],
						entityStore: "Business"
					}),
					listeners: {
						scope: this,
						itemclick: function (item, e) {

							go.util.viewFile(go.Jmap.downloadUrl('business/finance/statement/' + this.data.id + '/' + item.record.data.id));
						}
					}
				});

				this.moreMenu.menu.insert(-2, {
					iconCls: "ic-euro-symbol",
					text: t("Download financial statement"),
					menu: this.downloadStatementMenu
				});

				if(go.Modules.isInstalled("legacy", "email")) {
					this.sendStatementMenu = new go.menu.StoreMenu({
						cls: "x-menu-no-icons",
						displayField: "name",
						store: new go.data.Store({
							fields: ['id', 'name'],
							entityStore: "Business"
						}),
						listeners: {
							scope: this,
							itemclick: function (item, e) {

								Ext.getBody().mask(t("Loading..."));
								go.Jmap.request({
									method: "FinanceDocument/statement",
									params: {
										contactId: this.data.id,
										businessId: item.record.data.id
									}
								}).then(function (response) {
									GO.email.showComposer({
										blobs: [response]
									})
								}).finally(function () {
									Ext.getBody().unmask();
								})

							}
						}
					});

					this.moreMenu.menu.insert(-2, {
						iconCls: "ic-euro-symbol",
						text: t("Send financial statement"),
						menu: this.sendStatementMenu
					})
				}
			})
		})
	}

});