go.modules.business.finance.FinanceStatusCombo = Ext.extend(go.form.ComboBox, {
	fieldLabel: t("Status"),
	hiddenName: 'status',
	emptyText: t("Auto"),
	valueField: 'id',
	displayField: 'name',
	triggerAction: "all",
	editable: false,
	selectOnFocus: false,
	forceSelection: true,
	mode: "local",
	onTriggerClick: function() {
		this.focus();
		this.onLoad();
	},
	initComponent: function () {

		Ext.applyIf(this, {
			store: new go.modules.business.finance.StatusStore()
		});

		this.tpl = new Ext.XTemplate(
			'<tpl for=".">',
			'<div class="x-combo-list-item">',
			'<div class="status  business-finance-document-status-{id}" style="background-color: #{color}">{[values.name||values.id]}</div>',
			'</div>',
			'</tpl>'
		);

		go.modules.business.finance.FinanceStatusCombo.superclass.initComponent.call(this);
	}
});

Ext.reg("statuscombo", go.modules.business.finance.FinanceStatusCombo);
