go.modules.business.finance.YearlyReportPanel = Ext.extend(Ext.Panel, {

	// title: t("Monthly report"),

	// width: dp(1200),
	// height: dp(960),
	//
	// autoScroll: true,
	// maximizable: true,
	initComponent: function () {


		this.items = [{
			xtype: "box", cls: "go-pad", autoEl: "p", html: t("Click on a year to zoom in on the months")
		}, {

			xtype: "container", height: dp(400), // layout: "fit",
			style: "padding: 20px",
			items: [
				this.yearlySalesChart = new go.chart.BarChart({

					height: "100%",
					width: "100%",
					options: {
						maintainAspectRatio: false, // for height to work
						scales: {
							y: {
								beginAtZero: true
							}
						}, plugins: {
							legend: {
								display: false
							}, title: {
								display: true, text: t("Totals per year"),
							}
						}
					}
				})
			], bbar: [this.totalField = new Ext.form.Label()]
		}, {

			xtype: "container", cls: 'go-hbox', style: "justify-content: center; column-gap: 20%;", height: dp(400), items: [{
				width: "30%",
				height: "100%",
				xtype: "container",
				style: "padding: 20px",
				items: [this.categoryPieChart = new go.chart.PieChart({
					height: "100%", width: "100%", responsive: true, options: {
						plugins: {
							title: {
								display: true, text: t("Totals per category")
							}
						}
					}
				})]
			}, {
				width: "30%",
				height: "100%",
				xtype: "container",
				style: "padding: 20px",
				items: [this.statusPieChart = new go.chart.PieChart({
					height: "100%", width: "100%", responsive: true, options: {
						plugins: {
							title: {
								display: true, text: t("Totals per status")
							}
						}
					}
				})]
			}]
		}];


		go.modules.business.finance.YearlyReportPanel.superclass.initComponent.call(this);
	},

	load: async function (bookId) {
		this.bookId = bookId;
		this.book = await go.Db.store("FinanceBook").single(bookId);

		go.Jmap.request({
			method: "FinanceDocument/yearlyTotals", params: {
				bookId: this.bookId
			}
		}).then((totals) => {
			let total = 0, count = 0, series = [], labels = [];

			totals.forEach((rec) => {
				series.push(rec.subtotal);

				total += rec.subtotal;

				count += rec.count;

				labels.push(rec.year + " - " + this.book.currency + " " + go.util.Format.number(rec.subtotal, 0));
			});

			this.yearlySalesChart.update([{
				data: series,
				backgroundColor: [
					'rgba(54, 162, 235, 0.2)'
				],
				borderColor: [
					'rgb(54, 162, 235)'
				],
				borderWidth: 1
			}], labels);

			this.totalField.setText(t("Total") + ": " + go.util.Format.valuta(total) + ", " + t("Invoice count") + ": " + count, false);

		});


		go.Jmap.request({
			method: "FinanceDocument/totalsPerCategory", params: {
				bookId: this.bookId
			}
		}).then(totals => {
			if (!go.util.empty(totals)) {
				// const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
				// 	return currentValue.subtotal + accumulator;
				// }, 0);

				const data = {
					series: [], labels: []
				};

				const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
					return currentValue.subtotal + accumulator;
				}, 0);

				for (const category of totals) {
					const perc = parseInt((category.subtotal / sum) * 100);

					if (perc > 0) {
						data.labels.push((category.name ?? t("Uncategorized")) + " " + perc + "%");
						data.series.push({
							value: category.subtotal
						});
					}
				}

				this.categoryPieChart.update([{data: data.series}], data.labels);
			} else {
				this.categoryPieChart.update({});
			}
		});


		go.Jmap.request({
			method: "FinanceDocument/totalsPerStatus", params: {
				bookId: this.bookId
			}
		}).then((totals) => {

			const labels = [], data = [];

			const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
				return currentValue.subtotal + accumulator;
			}, 0);

			if (!go.util.empty(totals)) {

				for (const status in totals) {

					const perc = parseInt((totals[status].subtotal / sum) * 100);

					if (perc > 0) {
						labels.push(go.modules.business.finance.util.humanStatus(status, this.book) + " " + perc + "%");
						data.push({
							value: totals[status].subtotal
						});
					}
				}

				this.statusPieChart.update([{data: data}], labels);
			} else {
				this.statusPieChart.update([], []);
			}

		});


	}
});
