<?php

namespace go\modules\business\onlyoffice;

use go\core;
use go\core\model;
use go\core\model\Group;
use go\core\orm\Property;
use go\modules\business\onlyoffice\model\Settings;

/**
 * Class Module
 * @package go\modules\business\onlyoffice
 */
class Module extends core\Module
{
	/**
	 * The development status of this module
	 * @return string
	 */
	public function getStatus() : string{
		return self::STATUS_STABLE;
	}

	public static function getTitle(): string
	{
		return "Only Office";
	}

	public static function getDescription(): string
	{
		return go()->t("Edit documents in Only Office.");
	}

	public function requiredLicense(): ?string
	{
		return 'groupoffice-pro';
	}

	public function getAuthor(): string
	{
      return 'Michal Charvat <info@michalcharvat.cz>';
  }

  public function depends()
  {
      return array('files');
  }

	protected function rights(): array
	{
		return ['mayManage', 'mayEdit'];
	}
	/**
   * @return Settings|null
   */
  public function getSettings()
  {
      return Settings::get();
  }


	public function autoInstall(): bool
	{
		return true;
	}


	protected function beforeInstall(\go\core\model\Module $model): bool
	{
		// Share module with Internal group
		$model->permissions[Group::ID_INTERNAL] = (new \go\core\model\Permission($model))
			->setRights(['mayRead' => true, 'mayEdit' => true]);

		return parent::beforeInstall($model); // TODO: Change the autogenerated stub
	}


}