CREATE TABLE IF NOT EXISTS `business_privacy_settings` (
       `id` INT(11) UNSIGNED AUTO_INCREMENT NOT NULL,
       `warnXDaysBeforeDeletion` MEDIUMINT UNSIGNED DEFAULT NULL,
       `monitorAddressBooks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
       `trashAddressBook` INT(11) DEFAULT NULL,
       `trashAfterXDays` MEDIUMINT UNSIGNED DEFAULT NULL,
        PRIMARY KEY (`id`)
)
ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `business_privacy_settings` ADD CONSTRAINT `business_privacy_settings_ibfk1` FOREIGN KEY (`trashAddressBook`)
    REFERENCES `addressbook_addressbook`(`id`) ON DELETE SET NULL ON UPDATE SET NULL;

CREATE TABLE IF NOT EXISTS `business_privacy_contact` (
    `contactId` INT(11) NOT NULL,
    `deleteAt`   DATE DEFAULT NULL,
    PRIMARY KEY (`contactId`)
)
ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `business_privacy_contact` ADD CONSTRAINT `business_privacy_contact_ibfk1` FOREIGN KEY (`contactId`)
    REFERENCES `addressbook_contact`(`id`) ON DELETE CASCADE;

