<?php
namespace {namespace}\model;

use go\core\acl\model\AclOwnerEntity;
use go\core\model\Acl;
use go\core\model\Module as ModuleModel;
use go\core\orm\Mapping;
use go\core\orm\Query;
use {namespace}\Module;

class {model} extends AclOwnerEntity {

	public $id;
	public $createdBy;
	public $createdAt;
    public $modifiedBy;
	public $modifiedAt;

	public $name;
	public $filesFolderId;

    protected static function defineMapping(): Mapping
    {
        return parent::defineMapping()
            ->addTable("{tablePrefix}_{tableAlias}", "{tableAlias}");
    }


    protected static function internalDelete(Query $query): bool
    {
        if(!{itemModel}::delete(['{tableAlias}Id' => $query])) {
            return false;
        }
        return parent::internalDelete($query);
    }

    protected static function textFilterColumns(): array
    {
        return ['name'];
    }

    protected function canCreate(): bool
    {
        return Module::get()->getModel()->hasPermissionLevel(Acl::LEVEL_CREATE);
    }

}
