<?php
namespace {namespace}\controller;

use go\core\jmap\EntityController;
use go\core\jmap\exception\InvalidArguments;
use go\core\jmap\exception\StateMismatch;
use go\core\util\ArrayObject;
use Exception;
use {namespace}\model;

/**
 * The controller for the {model} entity
 *
 * @copyright (c) {year}, Intermesh BV https://www.intermesh.nl
 * @author {authorName} <{email}>
* @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
*/
final class {model} extends EntityController
{

	/**
	 * The class name of the entity this controller is for.
	 *
	 * @return class-string<model\{model}>
	 */
	protected function entityClass(): string
	{
		return model\{model}::class;
	}

	/**
	 * Handles the {model} entity's {model}/query command
	 *
	 * @return ArrayObject
	 * @param array $params
	 * @throws InvalidArguments
	 * @see https://jmap.io/spec-core.html#/query
	 */
	public function query(array $params): ArrayObject {
		return $this->defaultQuery($params);
	}

	/**
	 * Handles the {model} entity's {model}/get command
	 *
	 * @param array $params
	 * @return ArrayObject
	 * @throws Exception
	 * @see https://jmap.io/spec-core.html#/get
	 */
	public function get(array $params): ArrayObject {
		return $this->defaultGet($params);
	}

	/**
	 * Handles the {model} entity's {model}/set command
	 *
	 * @see https://jmap.io/spec-core.html#/set
	 * @param array $params
	 * @return ArrayObject
	 * @throws StateMismatch
	 * @throws InvalidArguments
	 */
	public function set(array $params): ArrayObject {
		return $this->defaultSet($params);
	}

	/**
	 * Handles the {model} entity's {model}/changes command

	 * @param array $params
	 * @return ArrayObject
	 * @throws InvalidArguments
	 * @see https://jmap.io/spec-core.html#/changes
	 */
	public function changes(array $params): ArrayObject {
		return $this->defaultChanges($params);
	}

	/**
	 * Handles export
	 *
	 * @param array $params
	 * @return ArrayObject
	 * @throws InvalidArguments
	 */
	public function export(array $params): ArrayObject
	{
		return $this->defaultExport($params);
	}

	/**
	 * Handles import
	 *
	 * @param array $params
	 * @return ArrayObject
	 * @throws Exception
	 */
	public function import(array $params): ArrayObject
	{
		return $this->defaultImport($params);
	}

	/**
	 * Returns a mapping object the client can use for importing data
	 *
	 * @param array $params
	 * @return ArrayObject
	 * @throws Exception
	 */
	public function importCSVMapping(array $params): ArrayObject
	{
		return $this->defaultImportCSVMapping($params);
	}

	/**
	 * Returns columns that can be exported
	 *
	 * @param array $params
	 * @return ArrayObject
	 * @throws Exception
	 */
	public function exportColumns(array $params): ArrayObject
	{
		return $this->defaultExportColumns($params);
	}
}
