go.modules.business.studio.CreateModulePanel = Ext.extend(Ext.Panel, {

	initComponent : function(){
		Ext.apply(this,{
			autoScroll: true,
			layout:'form',
			items:this.initFormItems()
		});
		go.modules.business.studio.CreateModulePanel.superclass.initComponent.call(this);
	},
	initFormItems: function () {

		this.moduleNameField = new Ext.form.TextField({
			name: 'module.name',
			fieldLabel: t("Module", "modules"),
			allowBlank: false,
			anchor: '100%',
			hint: t('A short name for the module', 'studio', 'business'),
			regex: /^[a-z0-9_]+$/,
			regexText: t('Only lower case letters are allowed', 'studio', 'business')

		});

		const settings = go.Modules.get("business", "studio").settings;

		this.packageNameField = new Ext.form.TextField({
			name: 'module.package',
			fieldLabel: t("Package", "modules"),
			allowBlank: false,
			value:  settings.package ? settings.package: "studio",
			disabled: !!settings.package,
			anchor: '100%',
			hint: t('Package name, e.g. name customer or name own company', 'studio', 'business'),
			regex: /^[a-z0-9_]+$/,
			regexText: t('Only lower case letters are allowed', 'studio', 'business')
		});

		this.moduleDescriptionField = new Ext.form.TextArea({
			name: 'module.description',
			fieldLabel: t("Description"),
			anchor: '100%',
			allowBlank: false,
			hint: t('A description for the module, to be displayed in the module manager', 'studio', 'business')
		});

		this.sortOrderField = new GO.form.NumberField({
			serverFormats: false,
			fieldLabel: t("Sort order", "modules"),
			name: 'module.sort_order',
			id: 'sort_order',
			decimals: 0,
			allowBlank: true,
			hidden: true, // Modules are not sorted anymore in 6.6+
			anchor: '100%',
			hint: t('Optional sort order for module', 'studio', 'business')
		});


		this.moduleType = new go.form.RadioGroup({
			anchor: '100%',
			fieldLabel: t("Module type"),
			name: "module.moduleType",
			value: null,
			allowBlank: false,
			items: [
				{boxLabel: t("Access controlled collections of items"), inputValue: "aclBoth"},
				{boxLabel: t("Access controlled items"), inputValue: "aclOwnerOnly"},
				{boxLabel: t("No permissions"), inputValue: "nonAcl"},
			],
			blankText: t("Please select a module type", "studio", "business"),
			hint: t("The module type allows you to select on which level the permissions are to be defined: collection, single item or module.",
				"studio", "business"),
			listeners: {
				change: (cb, checked) => {
					this.entityNameField.hide().disable();
					this.ownerEntityNameField.hide().disable();
					this.itemEntityNameField.hide().disable();
					this.itemEntityNameField.allowBlank = true;
					const selectedValue = checked.inputValue;
					if(selectedValue === "aclBoth") {
						this.itemEntityNameField.allowBlank = false;
						this.itemEntityNameField.enable().show();
						this.ownerEntityNameField.enable().show();
					} else {
						this.entityNameField.enable().show();
					}
				},
				scope: this
			}
		});

		// Default entity field
		this.entityNameField = new Ext.form.TextField({
			name: 'entity.name',
			fieldLabel: t("Entity Name", 'studio','business'),
			allowBlank: false,
			disabled: true,
			hidden: true,
			anchor: '100%',
			hint: t('A short name for the database object, should be singular', 'studio', 'business'),
			regex: /^[a-z0-9]+$/i,
			regexText: t('Only lower case letters are allowed', 'studio', 'business')
		});

		// ACL owner entity, AKA the 'collection'
		this.ownerEntityNameField = new Ext.form.TextField({
			name: 'entity.name',
			fieldLabel: t("Collection name", 'studio','business'),
			allowBlank: false,
			disabled: true,
			hidden: true,
			anchor: '100%',
			hint: t('A short name for the collection, should be singular', 'studio', 'business'),
			regex: /^[a-z0-9]+$/i,
			regexText: t('Only lower case letters are allowed', 'studio', 'business')
		});

		// ACL item entity
		this.itemEntityNameField = new Ext.form.TextField({
			name: 'itemEntity.name',
			fieldLabel: t("Item Entity Name", 'studio','business'),
			allowBlank: false,
			disabled: true,
			hidden: true,
			anchor: '100%',
			hint: t('A short name for the item database object, should be singular', 'studio', 'business'),
			regex: /^[a-z0-9]+$/i,
			regexText: t('Only lower case letters are allowed', 'studio', 'business')

		});

		return [{
			xtype: 'fieldset',
			items: [
				this.moduleNameField,
				this.packageNameField,
				this.moduleDescriptionField,
				this.sortOrderField,
				this.moduleType,
				this.entityNameField,
				this.ownerEntityNameField,
				this.itemEntityNameField
			]
		}];
	}
});