Ext.define('go.modules.business.support.SystemSettingsPanel',{
	extend: go.systemsettings.Panel,

	title: t("Support"),
	iconCls: 'ic-support',

	initComponent: function () {

		this.items = [
			{
				xtype: "fieldset",
				items: [
					{
						xtype: "tasklistcombo",
						role: "support",
						value: null,
						fieldLabel: t("Default tasklist"),
						hiddenName: "defaultTaskListId"
					},

					{
						xtype: "formgroup",
						startWithItem: false,

						addButtonText: t("Add E-mail account"),
						name: "emailAccounts",
						itemCfg: {
							xtype: "formcontainer",
							cls: "go-hbox",
							items: [
								{
									anchor: "",
									xtype: "emailaccountcombo",
									hiddenName: "accountId",
									flex: 1
								},{
									xtype: "box",
									autoEl: 'i',
									cls: 'icon',
									html: 'arrow_forward',
									width: dp(24),
									style: "align-self: center"
								},
								{
									anchor: "",
									flex: 1,
									xtype: "tasklistcombo",
									role: "support",
									value: null
								}
							]
						}
					},

					{
						anchor: "100%",
						xtype: "fieldset",
						title: t("Options"),
						items: [
							this.expireDaysField = new GO.form.NumberField({
								minValue: 0,
								decimalPrecision: 0,
								allowBlank: 0,
								hideLabel: false,
								value: 0,
								name: "expireDays",
								fieldLabel: t("Expiry in days"),
								hint: t("Number of days before support requests that have not been answered by the client, will be automatically closed. Set this to 0 to turn off this feature."),
								listeners: {
									change: function(a,b,c) {
										if ( parseInt(b) > 0) {
											this.sendFeedback.show();
											this.expiryTemplateField.show();
											this.excludeCategoriesFld.show();
											this.excludeListsFld.show();
										} else {
											this.sendFeedback.hide();
											this.expiryTemplateField.hide();
											this.excludeCategoriesFld.hide();
											this.excludeListsFld.hide();
										}
										this.doLayout();
									},
									scope: this
								}
							}),
							this.sendFeedback = new go.form.RadioGroup({
								fieldLabel: t("Send expiry feedback"),
								name: "sendExpireFeedback",
								value: "none",
								hidden: true,
								hint: t("Set here whether or not to create an expiry message and who can read this message"),
								items: [
									{boxLabel: t("No feedback"), inputValue: "none"},
									{boxLabel: t("Private note"), inputValue: "private"},
									{boxLabel: t("Comment"), inputValue: "public"}
								]
							}),
							this.expiryTemplateField = new Ext.form.TextArea({
								anchor: "100%",
								name: "expiryText",
								hidden: true,
								grow: true,
								growMax: 300,
								fieldLabel: t("Expiry message template"),
								value: t("This ticket has been closed after {x} days of inactivity"),
								emptyText: t("This ticket has been closed after {x} days of inactivity"),
								hint: t("Set your expiry message here. Use {x} as a parameter name for the expiry date.")
							}),
							this.excludeCategoriesFld = new go.form.Chips({
								hidden: true,
								name: "excludeCategories",
								fieldLabel: t("Excluded categories") ,
								entityStore: "TaskCategory",
								displayField: "name",
								valueField: "id",
								hint: t("Tickets that have the selected categories will not be automatically closed")
							}),
							this.excludeListsFld = new go.form.Chips({
								hidden: true,
								name: "excludeLists",
								fieldLabel: t("Excluded lists") ,
								entityStore: "SupportList",
								displayField: "name",
								valueField: "id",
								hint: t("Tickets in the selected support lists will not be automatically closed")
							}),
							{
								hint: t("Email account for sending replies"),
								anchor: "",
								xtype: "emailaccountcombo",
								hiddenName: "outgoingEmailAccountId",
								flex: 1,
								valueField: "id",
								displayField: 'email',
								allowBlank: true
							}
						]
					},
					{
						anchor: "100%",
						hideLabel: true,
						xtype: "formcontainer",
						name: "emailTemplate",
						items: [new go.emailtemplate.TemplateFieldset({
							height: dp(800),
							hideLanguage: true,
							title: t("Message template"),
							anchor: "100%",
							noName: true
						})]
					}
					]
			}
		];

		this.addListener("activate", function(a) {
			if(parseInt(a.expireDaysField.value) > 0) {
				a.sendFeedback.show();
				a.expiryTemplateField.show();
				a.excludeCategoriesFld.show();
				a.excludeListsFld.show();
			} else {
				a.sendFeedback.hide();
				a.expiryTemplateField.hide();
				a.excludeCategoriesFld.hide();
				a.excludeListsFld.hide();
			}
			go.Db.store("Tasklist").query({filter:{role: go.modules.community.tasks.listTypes.Support}})
				.then(function(result, reject) {
					const conditions = [
						{
							global: true
						}
					];
					if(result.ids.length) {
						conditions.push({
							tasklistId: result.ids
						});
					}
					a.excludeCategoriesFld.storeBaseParams = {
						filters: {"tasklist": {
								operator: "or",
								conditions: conditions
							}}
					}
				})
		}, this);

		this.callParent();
	},

	/*
	loadSettings: function() {
		debugger;
		const module = go.Modules.get("business", "support");

		if(!module.settings){
			console.debug("Module: "+this.package+"/"+this.module+" has no settings model.");
			return;
		}

		const v = module.settings, f = this.getForm();
		let hasReadOnlyFields = false;

		v.readOnlyKeys.forEach(function(key) {
			const field = f.findField(key);
			if(field) {
				field.setDisabled(true);
				hasReadOnlyFields = true;
			}
		});

		if(hasReadOnlyFields) {
			this.insert(0, {
				xtype: 'box',
				autoEl: 'p',
				cls: 'info',
				html: "<i class='icon'>info</i> " + t("Some fields on this page can't be edited because they have been locked in the server configuration file.")
			});
		}

		this.getForm().setValues(v);
	},*/

});

