<?php
namespace go\modules\business\wopi;

use go\core;
use go\core\model;
use go\core\model\Group;
use go\modules\business\wopi\model\Service;

/**						
 * 
 * 
 * Known issue with safari:
 * 
 * https://github.com/microsoft/Office-Online-Test-Tools-and-Documentation/issues/139
 * 
 * @copyright (c) 2019, Intermesh BV http://www.intermesh.nl
 * @author Merijn Schering <mschering@intermesh.nl>
 * @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
 */
class Module extends core\Module {

	/**
	 * The development status of this module
	 * @return string
	 */
	public function getStatus() : string{
		return self::STATUS_STABLE;
	}

	public function getAuthor(): string
	{
		return "Intermesh BV <info@intermesh.nl>";
	}

	public function autoInstall(): bool
	{
		return true;
	}

	public function getDependencies(): array
	{
		return ['legacy/files'];
	}


	public function requiredLicense(): ?string
	{
		return 'groupoffice-pro';
	}

	protected function afterInstall(model\Module $model): bool
	{
		self::configureIntermeshCloud();

		return parent::afterInstall($model);
	}


	protected function beforeInstall(\go\core\model\Module $model): bool
	{
		// Share module with Internal group
		$model->permissions[Group::ID_INTERNAL] = (new \go\core\model\Permission($model))
			->setRights(['mayRead' => true]);

		return parent::beforeInstall($model); // TODO: Change the autogenerated stub
	}


	public static function configureIntermeshCloud() {
		// Auto configure office 365 on Intermesh cloud domains.
		$host = core\http\Request::get()->getHost();
		if(strstr($host, 'group-office.com') || strstr($host, 'group-office.eu') || strstr($host, 'groupoffice.net')) {

			$service = new Service();
			$service->setUrl('https://onenote.officeapps.live.com');

			$parts = explode(".", $host);
			array_splice($parts, 1, 0, ['wopi']);
			$clientUri = "https://" . implode(".", $parts) .'/wopi/';

			$service->setWopiClientUri($clientUri);

			$service->setAcl([
				model\Group::ID_INTERNAL => model\Acl::LEVEL_WRITE
			]);

			$service->save();
		}
}

}