
CREATE TABLE IF NOT EXISTS `ld_leave_days` (
  `id` int(11) AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `first_date` int(11) NOT NULL DEFAULT '0',
  `last_date` int(11) NOT NULL DEFAULT '0',
  `from_time` time DEFAULT NULL,
  `n_hours` double NOT NULL DEFAULT '0',
  `n_nat_holiday_hours` double NOT NULL DEFAULT '0',
  `description` varchar(50) NOT NULL DEFAULT '',
  `ctime` int(11) NOT NULL DEFAULT '0',
  `mtime` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `ld_credit_type_id` int(11) NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB;


CREATE TABLE IF NOT EXISTS `ld_special_leave_budgets` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`agreement_id` INT(10) UNSIGNED NOT NULL,
	`activity_id` INT(10) UNSIGNED NOT NULL,
	`n_hours` DOUBLE UNSIGNED NOT NULL DEFAULT '0',
	`start_date` DATE DEFAULT NULL,
	`finish_date` DATE DEFAULT NULL,
	`description` VARCHAR(190) NOT NULL,
	PRIMARY KEY(`id`),
    INDEX `fk_ld_special_leave_budget_activity_idx` (`activity_id` ASC),
    INDEX `fk_ld_special_leave_budget_agreement_idx` (`agreement_id` ASC)
)
ENGINE = InnoDB;

ALTER TABLE `ld_special_leave_budgets`
    ADD CONSTRAINT `fk_ld_special_leave_budget_activity_idx`
        FOREIGN KEY (`activity_id`) REFERENCES `business_activity`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;

ALTER TABLE `ld_special_leave_budgets`
    ADD CONSTRAINT `fk_ld_special_leave_budget_agreement_idx`
        FOREIGN KEY (`agreement_id`) REFERENCES `business_agreement`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;
ALTER TABLE `ld_leave_days` ADD `special_budget_id` INT(11) UNSIGNED DEFAULT NULL;

ALTER TABLE `ld_leave_days`
    ADD CONSTRAINT `fk_ld_leave_day_special_idx`
        FOREIGN KEY (`special_budget_id`) REFERENCES `ld_special_leave_budgets`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;

