<?php

$updates['201309111730'][]="ALTER TABLE `ld_year_credits` CHANGE `n_hours` `n_hours` DOUBLE NOT NULL DEFAULT '0';";
$updates['201309111730'][]="ALTER TABLE `ld_leave_days` CHANGE `n_hours` `n_hours` DOUBLE NOT NULL DEFAULT '0';";

$updates['201312121327'][]="ALTER TABLE  `ld_year_credits` ADD  `manager_user_id` INT NULL ;";
$updates['201312121327'][]="ALTER TABLE ld_year_credits DROP PRIMARY KEY";
$updates['201312121327'][]="ALTER TABLE  `ld_year_credits` ADD  `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST ;";
$updates['201312121327'][]="ALTER TABLE  `ld_leave_days` ADD  `approved` BOOLEAN NOT NULL DEFAULT  '0'";

$updates['201312121327'][]="update ld_leave_days set approved=true;";

$updates['201407310900'][]="ALTER TABLE `ld_leave_days` ADD `n_nat_holiday_hours` DOUBLE NOT NULL DEFAULT '0' AFTER `n_hours` ;";
$updates['201407310945'][]="script:1_store_national_holiday_hours.php";

$updates['201509031410'][]="ALTER TABLE `ld_leave_days` CHANGE `approved` `status` INT NOT NULL DEFAULT '0';";
$updates['201509031410'][]="ALTER TABLE `ld_leave_days` ADD `from_time` TIME NULL DEFAULT NULL AFTER `last_date`;";


//
$updates['201512240000'][] = "CREATE TABLE IF NOT EXISTS `ld_credit_types` (
  `id` int(11) AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `credit_doesnt_expired` tinyint(1) NOT NULL DEFAULT '0',
  `sort_index` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

$updates['201512240000'][]="
CREATE TABLE IF NOT EXISTS `ld_credits` (
  `ld_year_credit_id` int(11) NOT NULL,
  `ld_credit_type_id` int(11) NOT NULL,
  `n_hours` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
// Add ld_credit_type_id in to table ld_leave_days
$updates['201512240000'][]="ALTER TABLE `ld_leave_days` ADD `ld_credit_type_id` int(11) NOT NULL;";
// creat credit type
$updates['201512240000'][]="script:2_update_to_credit_types.php";
// copy hours from ld_year_credits to ld_credits and set credit type id 1
$updates['201512240000'][]="INSERT INTO `ld_credits`  (`ld_credits`.`ld_year_credit_id`, `ld_credits`.`ld_credit_type_id`, `ld_credits`.`n_hours`) SELECT `yc`.`id`, 1, `yc`.`n_hours` FROM `ld_year_credits` AS `yc`";
//set the current holyday to credit type 1
$updates['201512240000'][]="UPDATE `ld_leave_days` SET `ld_credit_type_id` = '1'";
$updates['201512240000'][]="ALTER TABLE `ld_credits` ADD PRIMARY KEY (`ld_year_credit_id`,`ld_credit_type_id`);";

$updates['201610281650'][] = 'ALTER TABLE `ld_credit_types` ENGINE=InnoDB;';
$updates['201610281650'][] = 'ALTER TABLE `ld_credit_types` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;';
$updates['201610281650'][] = 'ALTER TABLE `ld_credits` ENGINE=InnoDB;';
$updates['201610281650'][] = 'ALTER TABLE `ld_credits` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;';
$updates['201610281650'][] = 'ALTER TABLE `ld_leave_days` ENGINE=InnoDB;';
$updates['201610281650'][] = 'ALTER TABLE `ld_leave_days` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;';
$updates['201610281650'][] = 'ALTER TABLE `ld_year_credits` ENGINE=InnoDB;';
$updates['201610281650'][] = 'ALTER TABLE `ld_year_credits` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;';

$updates['201812040930'][] = "ALTER TABLE `ld_credit_types` ADD `active` tinyint(1) NOT NULL DEFAULT '1';";

// this most be before core updates 201905201227 function
$updates['201905201226'][] = function() {
	//install business module
	$businessModule = \go\modules\business\business\Module::get();
	if (!$businessModule->isInstalled() && !$businessModule->install()) {
		throw new \Exception("Failed to install business module");
	}

	//remove default activities because they can clash with the migration below
	go()->getDbConnection()->exec("delete from business_activity");
};
// ld_credit_types go into business_activity
$updates['202003010001'][] = function() {
	//$pr2Module = new \GO\Projects2\Projects2Module();
	if(go()->getModule(null, 'projects2') !== false) {
		// set leaveday budget ID to business activity. If the standard_tasks table is empty, the ld_credit_type_id fields
		// are to be upped by two, since the first activity has ID 3
		go()->getDbConnection()->query('UPDATE ld_leave_days SET ld_credit_type_id = ld_credit_type_id+(select COALESCE(max(id),2) FROM pr2_standard_tasks);');

		// insert holiday jars into activities
		go()->getDbConnection()->query('INSERT INTO business_activity (id,type,code,name,units,description,disabled,billable,budgetable,budgetExpires)'.
			'SELECT (select max(id) from pr2_standard_tasks)+id, 2,"",name,8, description, IF(active,0,1) as disabled, 0,1, IF(credit_doesnt_expired,0,1) as budgetExpires FROM ld_credit_types');

	} else {
		go()->getDbConnection()->query('INSERT INTO business_activity (id,type,code,name,units,description,disabled,billable,budgetable,budgetExpires)'.
			'SELECT id, 2,"",name,8, description, IF(active,0,1) as disabled, 0,1, IF(credit_doesnt_expired,0,1) as budgetExpires FROM ld_credit_types');
	}
};
$updates['202003010001'][] = '';
$updates['202003010002'][] = function() {
	// create employee agreements with holiday budgets and use go_working_week for every record
	$createAgreement = function($credit) {
		// agreement
		$agreement = new \go\modules\business\business\model\EmployeeAgreement();
		$agreement->employeeId = $credit['user_id'];
		$agreement->start = new \go\core\util\DateTime($credit['year'].'-01-01');
		// credits
		foreach($credit as $key => $value) {
			if (substr($key, 0, 7) == 'credit_' && $value !== null) {
				$budget = new \go\modules\business\business\model\ActivityBudget($agreement);
				$budget->activityId = substr($key, 7);
				$budget->budget = $value;
				$agreement->budgets[] = $budget;
			}
		}
		// workweek
		$agreement->mo = $credit['mo_work_hours'] ? $credit['mo_work_hours']*60 : 0;
		$agreement->tu = $credit['tu_work_hours'] ? $credit['tu_work_hours']*60 : 0;
		$agreement->we = $credit['we_work_hours'] ? $credit['we_work_hours']*60 : 0;
		$agreement->th = $credit['th_work_hours'] ? $credit['th_work_hours']*60 : 0;
		$agreement->fr = $credit['fr_work_hours'] ? $credit['fr_work_hours']*60 : 0;
		$agreement->sa = $credit['sa_work_hours'] ? $credit['sa_work_hours']*60 : 0;
		$agreement->su = $credit['su_work_hours'] ? $credit['su_work_hours']*60 : 0;
		if(!$agreement->save()) {
			var_dump($agreement->getValidationErrors());
		}

	};
	// 0 Create empty employee records based on non-project employee settings (which is not much)
	try {
		go()->getDbConnection()->exec("INSERT IGNORE INTO `business_employee` (`id`,`businessId`) SELECT `u`.`id`, 1 FROM  `core_user` `u` WHERE `u`.`enabled`=1;");
	}	catch (\Exception $e) {
		// because of a messy situation with merged projects settings upgrade this lead to problems on  new installs not having the pr2_settings_table
	}


	//install business module
	$budgetableActivities = go()->getDbConnection()->select('id')
		->from('business_activity')
		->where(['budgetable'=>1])->andWhere('type', '!=', 1)->execute();
	$yearCreditQuery = go()->getDbConnection()
		->select('y.user_id, year, mo_work_hours, tu_work_hours, we_work_hours, th_work_hours, fr_work_hours, sa_work_hours, su_work_hours')
		->from('ld_year_credits', 'y')
		->fetchMode(\PDO::FETCH_ASSOC)
		->join('go_working_weeks', 'ww', 'ww.user_id = y.user_id', 'LEFT')
		->join('business_employee', 'employee', 'employee.id = y.user_id') // most be employee
		->orderBy(['user_id'=>'ASC','year'=>'ASC']);

	$maxStandardTaskId = 0;
	if(go()->getModule(null, 'projects2') !== false) {
		$maxStandardTaskId = go()->getDbConnection()->select('MAX(id)')->from('pr2_standard_tasks')->execute()->fetchColumn();
		if($maxStandardTaskId == 0) {
			$maxStandardTaskId = go()->getDbConnection()->select('MIN(id) - 1' )->from('business_activity')->execute()->fetchColumn();
		}
	}
	// join all the credits as a column
	while($id = $budgetableActivities->fetchColumn()) {
		// substract this because Standard tasks and Year credits are merged to activities
		$cId = $id - $maxStandardTaskId;
		$yearCreditQuery->join('ld_credits', 'c'.$id,"c$id.ld_year_credit_id = y.id AND c$id.ld_credit_type_id = $cId", 'LEFT');
		$yearCreditQuery->select("c$id.n_hours as credit_$id", true);
	}

	$stmt =	$yearCreditQuery->execute();
	$prevCredit = $stmt->fetch();
	if(empty($prevCredit)) {
		echo "Leavedays: zero credits to migrate.";
		return; // nothing to migrate
	}
	$createAgreement($prevCredit);
	while($currCredit = $stmt->fetch()) {
		if($prevCredit['user_id'] == $currCredit['user_id']) {
			foreach($currCredit as $key => $value) {
				if(substr($key, 0, 7) == 'credit_') {
					if($value != $prevCredit[$key]) {
						$createAgreement($currCredit); // override last credit
						break;
					}
				}
			}
			// skip if same as last credit
		} else {
			$createAgreement($currCredit);
		}
		$prevCredit = $currCredit;
	}

};
// ld_year_credits go into business_agreements
// ld_credits for into business_activity_budget
$updates['202111080948'][] =  function() {
	if(go()->getDbConnection()->getDatabase()->hasTable('ld_year_credits')) {
		go()->getDbConnection()->query('INSERT IGNORE INTO `business_manager` (`subjectId`, `managerId`, `notified`) 
		SELECT `t`.`user_id`, `t`.`manager_user_id`, 1 FROM `ld_year_credits` `t` 
			WHERE `t`.`user_id` IN (SELECT `id` FROM `core_user` WHERE `enabled` = 1) AND 
			      `t`.`manager_user_id` IN (SELECT `id` FROM `core_user` WHERE `enabled` = 1)
			      AND `t`.`year` = ( SELECT MAX(`tt`.`year`) FROM `ld_year_credits` `tt` WHERE `t`.`user_id`=`tt`.`user_id`) 
              GROUP BY `t`.`user_id`;');
	}
};

$updates['202112200945'][] = "
CREATE TABLE IF NOT EXISTS `ld_special_leave_budgets` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`agreement_id` INT(10) UNSIGNED NOT NULL,
	`activity_id` INT(10) UNSIGNED NOT NULL,
	`n_hours` SMALLINT UNSIGNED NOT NULL,
	`start_date` DATE DEFAULT NULL,
	`finish_date` DATE DEFAULT NULL,
	`description` VARCHAR(190) NOT NULL,
	PRIMARY KEY(`id`),
    INDEX `fk_ld_special_leave_budget_activity_idx` (`activity_id` ASC),
    INDEX `fk_ld_special_leave_budget_agreement_idx` (`agreement_id` ASC)
)
ENGINE = InnoDB;";

$updates['202112200945'][] = "ALTER TABLE `ld_special_leave_budgets` 
    ADD CONSTRAINT `fk_ld_special_leave_budget_activity_idx` 
        FOREIGN KEY (`activity_id`) REFERENCES `business_activity`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;";

$updates['202112200945'][] = "ALTER TABLE `ld_special_leave_budgets` 
    ADD CONSTRAINT `fk_ld_special_leave_budget_agreement_idx` 
        FOREIGN KEY (`agreement_id`) REFERENCES `business_agreement`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;";

$updates['202112201700'][] = "ALTER TABLE `ld_leave_days` ADD `special_budget_id` INT(11) UNSIGNED DEFAULT NULL;";

$updates['202112201700'][] = "ALTER TABLE `ld_leave_days` 
    ADD CONSTRAINT `fk_ld_leave_day_special_idx` 
        FOREIGN KEY (`special_budget_id`) REFERENCES `ld_special_leave_budgets`(`id`) ON DELETE RESTRICT ON UPDATE NO ACTION;";

$updates['202210101625'][] = "ALTER TABLE `ld_special_leave_budgets` CHANGE `n_hours` `n_hours` FLOAT UNSIGNED NOT NULL DEFAULT '0';";

$updates['202308091050'][] = "ALTER TABLE `ld_special_leave_budgets` ADD `status` TINYINT UNSIGNED NOT NULL DEFAULT 0;";