/**
 * Upon approving a special leave day, make sure that a special leave budget was actively selected
 * This dialog presents available budgets and forces the manager to select an existnig budget.
 *
 * @author Joachim van de Haterd <jvdhaterd@intermesh.nl>
 */

GO.leavedays.SelectSpecialLeaveBudgetDialog = Ext.extend(GO.dialog.TabbedFormDialog, {

    initComponent : function(){

        Ext.apply(this, {
            modal: true,
            title:t("Select special leave budget", "leavedays"),
			goDialogId:'selectSpecialLeaveBudget',
            height: 200,
            formControllerUrl: 'leavedays/leaveday/update'
        });

        GO.leavedays.SelectSpecialLeaveBudgetDialog.superclass.initComponent.call(this);

    },

    beforeLoad : function(remoteModelId,config) {
        this.specialLeaveBudgetCombo.store.baseParams.activity_id = config.activityId;
        config.loadParams = {
            id : remoteModelId,
        }
    },

    afterLoad: function() {
        this.hiddenStatusField.setValue(1);
    },

    buildForm : function() {
        this.addPanel(new Ext.Panel({
            layout: 'form',
            cls:'go-form-panel',
            items: [
                this.hiddenStatusField = new Ext.form.TextField({
                name : 'status',
                hidden: true
            }), this.specialLeaveBudgetCombo = new GO.form.ComboBoxReset({
                fieldLabel: t('Special leave budget', 'leavedays'),
                hiddenName: 'special_budget_id',
                emptyText: t("Please select..."),
                hint: t("Select existing budget or create a new budget in the \'Leave Budgets\' tab"),
                store: new GO.data.JsonStore({
                    url:GO.url("leavedays/specialleavebudget/store"),
                    baseParams:{
                        activeOnly:true,
                        user_id: GO.leavedays.activeUserId,
                        year: GO.leavedays.activeYear
                    },
                    fields:['id', 'description', 'start_date', 'finish_date', 'n_hours', 'spent_hours'],
                    remoteSort:true
                }),
                pageSize: parseInt(GO.settings.max_rows_list),
                valueField: 'id',
                displayField: 'description',
                mode: 'remote',
                triggerAction: 'all',
                editable: false,
                selectOnFocus: true,
                forceSelection: true,
                allowBlank: false,
                tpl: new Ext.XTemplate(
                    '<tpl for=".">',
                    '<div ext:qtip="{description} ({start_date} - {finish_date}, ({spent_hours} / {n_hours})" class="x-combo-list-item">{description} ({spent_hours} / {n_hours})</div>',
                    '</tpl>'
                )
            })]
        }));
    }

});
