GO.moduleManager.onModuleReady('tasks',function(){
	GO.projects2.TasksPanel = Ext.extend(Ext.Panel, {
		projectId: null,
		autoScroll: true,

		initComponent: function() {

			this.tbar = ['->',
				this.completedFilter = new Ext.form.Checkbox({
					hideLabel: true,
					xtype: "checkbox",
					boxLabel: t("Show completed", "tasks", "community"),
					checked: true,
					value: false,
					listeners: {
						scope: this,
						check: (cb, checked) => {
							this.tasklistContainer.items.each((item) => {
								item.store.setFilter('completed', checked ? null : {complete:  false}).load()
									.then((result) => {
										this.tasklistContainer.doLayout();
									});

							});
						}
					}
				}),
				this.employeeCombo = new go.modules.business.business.EmployeeCombo({
					width: dp(240),
					allowBlank: true,
					emptyText: t("Employee", "business", "business"),
					listeners: {
						scope: this,
						'select':  (combo, record, index) => {
								this.tasklistContainer.items.each((item) => {
									item.store.setFilter('responsibleUserId', {responsibleUserId: record.id}).load()
										.then((result) => {
											this.tasklistContainer.doLayout();
										});
								});
						},
						'clear': (combo, record, index) => {
							this.tasklistContainer.items.each((item) => {
								item.store.setFilter('responsibleUserId', null).load();
							});
							this.tasklistContainer.doLayout();

						}
					}

					}),
				{
					xtype: 'tbsearch',
					listeners: {
						scope: this,
						'search': (cb,v,c) =>  {
							this.tasklistContainer.items.each((item) => {
								item.store.setFilter('text', {text: v}).load().then(() => {
									this.tasklistContainer.doLayout();
								});
							});

						},
						'reset': function(btn) {
							this.tasklistContainer.items.each((item) => {
								item.store.setFilter('text', null).load();
							});
							this.tasklistContainer.doLayout();
						}
					}
				},
			];

			this.store = new go.data.Store({
				entityStore: "Tasklist",
				fields: ['id', 'name'],
				sortInfo: {
					field: 'name',
					direction: 'ASC'
				}
			});

			this.store.on("datachanged", this.draw, this);

			this.items = [

				this.tasklistContainer = new Ext.Container({
					autoHeight: true
				}),

				new Ext.Button({
					iconCls: 'ic-add',
					text: t("Add tasklist", "projects2", "legacy"),
					handler: this.addTasklist,
					scope: this,
					style: "margin: 14px",
				})
			];

			this.supr().initComponent.call(this);

			this.on("render", () => {
				if(this.mustLoad) {
					this.store.load();
				}
			});
		},

		setProjectId : function(projectId) {

			this.store.setFilter("project", {projectId: projectId});
			this.projectId = projectId;
			this.employeeCombo.store.setFilter('resourceForProject', {resourceForProject: this.projectId}).load();

			if(this.rendered) {
				this.store.load();
			} else {
				this.mustLoad = true;
			}
		},

		addTasklist: function() {
			const dlg = new go.modules.community.tasks.TasklistDialog({
				hidePermissions: true
			});

			dlg.setValues({
				role: "project",
				projectId: this.projectId
			}).show();
		},

		draw : function() {
			this.tasklistContainer.removeAll();
			this.store.getRange().forEach((record) => {
				const tl = new GO.projects2.TasklistPanel({
					title: record.data.name,
					tasklistId: record.id,
					projectId: this.projectId,
					forProject: true,
					parentStore: this.store,
					stateId: "project-task-list"
				})

				this.tasklistContainer.add(tl);
			});

			this.tasklistContainer.doLayout();
		}
	});


	GO.projects2.TasklistPanel = Ext.extend(go.modules.community.tasks.TaskGrid,
		{
			tasklistId: null,
			projectId: null,
			border: true,
			style: "margin: " + dp(16) + "px",
			autoHeight: true,
			collapsible: true,
			parentStore: null,

			initComponent : function() {

				this.view = new go.grid.GridView({
					emptyText: '<i>description</i><p>' + t("No items to display") + '</p>',
					totalDisplay: false,
					actionConfig: {
						scope: this,
						menu: this.initTaskMoreMenu()
					},
					hideGroupedColumn: true,
					showGroupName: false
				});

				this.tools = [

					{
						id: 'add',
						tooltip: t("Add task"),
						handler: () => {this.addTask(this.tasklistId, this.projectId);},
						cls: "primary-icon"
					}, {
						id: 'menu',
						menu: [{
							text: t("Edit"),
							iconCls: 'ic-edit',
							handler: () => {this.editTasklist(this.tasklistId);}
						},{
							text: t("Delete"),
							iconCls: 'ic-delete',
							handler: () => {this.deleteTasklist(this.tasklistId)}
						}]

					}
				];

				this.supr().initComponent.call(this);

				this.on("rowdblclick", (grid, rowIndex) => {
					const record = grid.store.getAt(rowIndex);
					this.openTask(record);
				});

				this.store.setFilter('tasklist', {tasklistId: this.tasklistId});
				this.store.load();
			},


			deleteTasklist : function(tasklistId) {
				Ext.MessageBox.confirm(t("Delete"), t("Are you sure you want to delete this item?"), function (btn) {

					if (btn == "yes") {
						go.Db.store("Tasklist").destroy(tasklistId)
							.then((result) => {
								this.parentStore.reload();
							}).catch((result) => {
								if(result.message) {
									GO.errorDialog.show(result.message);
								} else {
									GO.errorDialog.show(result.error.description);
								}
						});
					}
				}, this);
			},

			editTasklist : function(tasklistId) {
				const dlg = new go.modules.community.tasks.TasklistDialog({
					hidePermissions: true
				});

				dlg.load(tasklistId).show();
			},

			addTask : function(tasklistId, projectId) {
				projectId = projectId || false;
				const dlg = new go.modules.community.tasks.TaskDialog({
					role: "project",
					redirectOnSave: false
				});

				if(projectId) {
					dlg.responsibleCombo.store.setFilter('projectId', {'projectId': projectId});
					dlg.tasklistCombo.store.setFilter('projectId', {'projectId': projectId});
				}

				dlg.setValues({tasklistId: tasklistId}).show();
			},

			initTaskMoreMenu : function (node, e, record) {
				return {
					items: [{
						iconCls: 'ic-alarm-add',
						text: t("Time entry", "projects2"),
						handler: function (item) {
							const record = this.store.getAt(item.parentMenu.rowIndex);
							const dlg = new GO.timeregistration2.TimeDialog({
								showUser: true
							});
							dlg.setValues({
								project_id: this.ownerCt.ownerCt.projectId,
								task_id: record.id,
								user_id: record.data.responsible ? record.data.responsible.id : go.User.id
							});
							dlg.show();
						},
						scope: this
					},{
						itemId: "edit",
						iconCls: 'ic-edit',
						text: t("Edit"),
						handler: (item) => {
							const record = this.store.getAt(item.parentMenu.rowIndex);
							this.editTask(record);
						},
						scope: this
					}, {
						itemId: "delete",
						iconCls: "ic-delete",
						text: t("Delete"),
						handler: function (item) {
							Ext.MessageBox.confirm(t("Delete"), t("Are you sure you want to delete this item?"), (btn) => {
								const myStore = this.store;
								const record = myStore.getAt(item.parentMenu.rowIndex);

								if (btn == "yes") {
									if(record.data.percentComplete > 0 || record.data.timeBooked > 0) {
										Ext.MessageBox.alert(t('Error'), t('This task already has booked hours or progress', 'community', 'tasks'));
										return;
									}
									go.Db.store("Task").set({
										destroy: [record.id]
									}).finally(function(){
										myStore.reload();
									});
								}
							}, this);
						},
						scope: this
					}, {
						itemId: "open",
						iconCls: "ic-open-in-new",
						text: t("Open"),
						handler: function (item) {
							const record = this.store.getAt(item.parentMenu.rowIndex);
							this.openTask(record);
						},
						scope: this
					}]
				};
			},

			openTask: function(record) {
				const win = new go.links.LinkDetailWindow({
					entity: "Task"
				});
				// Override edit button with local editTask method! This will force the correct filters to be set to the
				// several combo boxes
				win.detailView.editTaskBtn.setHandler(function(btn, e){
					this.editTask(record)
				}, this);
				win.load(record.id);

			},

			editTask: function(record) {
				const projectId =  record.data.tasklist.projectId;
				const dlg = new go.modules.community.tasks.TaskDialog({
					redirectOnSave: false
				});
				dlg.responsibleCombo.store.setFilter('projectId', {'projectId': projectId});
				dlg.tasklistCombo.store.setFilter('projectId', {'projectId': projectId});
				dlg.load(record.id).setValues({tasklistId: record.json.tasklistId}).show();

			},


		});
});
