go.modules.business.projects2.customfield.ProjectDialog = Ext.extend(go.customfields.FieldDialog, {
	initFormItems: function () {
		var items = go.customfields.type.CheckboxDialog.superclass.initFormItems.call(this);

		items[0].items = items[0].items.concat([
			this.projectStatus = new GO.projects2.SelectStatus({
				anchor: "100%",
				emptyText: t("Select to change", "itpadvduplication"),
				fieldLabel: t("Default status", "projects2"),
				hiddenName: 'options.statusId'
			}),
			this.permissionsSelect = this.createLevelCombo(
				{
					anchor: "100%",
					fieldLabel: t("Permission level"),
					hiddenName: 'options.permissionLevel'
				}
			)
		]);
		items[1].items = items[1].items.concat([{
			xtype: "label",
			text: t("Information panel"),
			autoEl: "legend",
			itemCls: "x-fieldset-header"
		},{
			xtype: "checkbox",
			fieldLabel: t("Show selections in the information panel"),
			name: "options.showInformationPanel",
			value: true
		},{
			xtype: "checkbox",
			fieldLabel: t("Expand panel by default"),
			name: "options.expandByDefault",
			value: true
		},{
			xtype: "textfield",
			name: "options.informationPanelTitle",
			fieldLabel: t("Title"),
			anchor: "100%",
			allowBlank: false
		}]);

		return items;
	},
	createLevelCombo: function () {
		var levelData = [], levelLabels = {}, levels = [];

		levelLabels[go.permissionLevels.read] = t("Read only");
		levelLabels[go.permissionLevels.create] = t("Read and Create only");
		levelLabels[go.permissionLevels.write] = t("Write");
		levelLabels[go.permissionLevels.writeAndDelete] = t("Write and delete");
		levelLabels[GO.projects2.permissionLevelFinance] = t("Finance permissions");
		levelLabels[go.permissionLevels.manage] = t("Manage");

		levels = [
			go.permissionLevels.read,
			go.permissionLevels.create,
			go.permissionLevels.write,
			go.permissionLevels.writeAndDelete,
			GO.projects2.permissionLevelFinance,
			go.permissionLevels.manage
		];

		for (var i = 0, l = levels.length; i < l; i++) {
			if (!levelLabels[levels[i]]) {
				alert('Warning: you must define a label for permission level: ' + levels[i]);
			} else {
				levelData.push([levels[i], levelLabels[levels[i]]]);
			}
		}

		var permissionLevelConfig = {
			store: new Ext.data.SimpleStore({
				id: 0,
				fields: ['value', 'text'],
				data: levelData
			}),
			valueField: 'value',
			displayField: 'text',
			mode: 'local',
			triggerAction: 'all',
			editable: false,
			selectOnFocus: true,
			forceSelection: true,
			anchor: "100%",
			hiddenName: 'options.permissionLevel',
			fieldLabel: t("Permissions")
		};


		return new go.form.ComboBox(permissionLevelConfig);
	}

});