GO.workflow.MainPanel = function(config){
	
	this.workflowGrid = new GO.workflow.WorkflowGrid({
		region:'center',
		id:'wf-center-panel',
		border:true
	});
	
	this.workflowGrid.store.baseParams['show_required_only'] = Ext.state.Manager.get('wf-showrequiredonly');
	this.workflowGrid.store.baseParams['show_completed'] = Ext.state.Manager.get('wf-showcompleted');
	this.workflowGrid.store.baseParams['show_own_created'] = Ext.state.Manager.get('wf-showowncreated');
	
	
	this.showCompletedCheck = new Ext.form.Checkbox({		
		boxLabel: t("Show completed", "workflow"),
		hideLabel: true,
		checked:GO.workflow.showCompleted=Ext.state.Manager.get('wf-showcompleted')
	});
	
	this.showCompletedCheck.on('check', function(cb, checked){		
		
		var isChecked = checked? '1' : '0';
		this.workflowGrid.store.baseParams['show_completed']=isChecked;
		
		Ext.state.Manager.set('wf-showcompleted', isChecked);
		this.workflowGrid.store.load();
	}, this);
	
	this.showRequiredOnlyCheck = new Ext.form.Checkbox({		
		boxLabel: t("Show my required approvals only", "workflow"),
		hideLabel: true,
		checked:GO.workflow.showRequiredOnly=Ext.state.Manager.get('wf-showrequiredonly')
	});
	
	this.showRequiredOnlyCheck.on('check', function(cb, checked){		
		var isChecked = checked? '1' : '0';
		this.workflowGrid.store.baseParams['show_required_only']=isChecked;
		
		Ext.state.Manager.set('wf-showrequiredonly', isChecked);
		this.workflowGrid.store.load();
	}, this);
	
	this.showOwnCreated = new Ext.form.Checkbox({		
		boxLabel: t("Show created by me only", "workflow"),
		hideLabel: true,
		checked:GO.workflow.showOwnCreated=Ext.state.Manager.get('wf-showowncreated')
	});
	
	this.showOwnCreated.on('check', function(cb, checked){		
		var isChecked = checked? '1' : '0';
		this.workflowGrid.store.baseParams['show_own_created']=isChecked;
		
		Ext.state.Manager.set('wf-showowncreated', isChecked);
		this.workflowGrid.store.load();
	}, this);

	this.filterPanel = new Ext.form.FormPanel({
		title:t("Filter", "workflow"),
		cls:'go-form-panel',
		waitMsgTarget:true,
		region:'west',
		width: 220,
		border:true,
		split:true,
		items: [this.showCompletedCheck,this.showRequiredOnlyCheck,this.showOwnCreated]
	});

	if(!config)
		config = {};

	config.items=[this.filterPanel,this.workflowGrid];	
	config.layout='border';
	GO.workflow.MainPanel.superclass.constructor.call(this, config);	
	
	
	this.on('render', function(){
		this.workflowGrid.store.load();
	}, this);
};

Ext.extend(GO.workflow.MainPanel, Ext.Panel, {

});

go.Modules.register("legacy", 'workflow', {
	mainPanel: GO.workflow.MainPanel,
	title: t("Workflow", "workflow"),
	iconCls: 'go-tab-icon-workflow'

});

go.Router.add(/workflow\/approve\/([0-9]+)/, function (id) {
	GO.workflow.approve(id);
});

go.Router.add(/workflow\/decline\/([0-9]+)/, function (id) {
	GO.workflow.decline(id);
});

GO.workflow.approve = function(id){
	if(!GO.workflow.stepHistoryDialog)
		GO.workflow.stepHistoryDialog = new GO.workflow.StepHistoryDialog();

	GO.workflow.stepHistoryDialog.setProcessModelId(id);
	GO.workflow.stepHistoryDialog.setStatus(1);
	GO.workflow.stepHistoryDialog.show();
}

GO.workflow.decline = function(id){
	if(!GO.workflow.stepHistoryDialog)
		GO.workflow.stepHistoryDialog = new GO.workflow.StepHistoryDialog();

	GO.workflow.stepHistoryDialog.setProcessModelId(id);
	GO.workflow.stepHistoryDialog.setStatus(0);
	GO.workflow.stepHistoryDialog.show();
}

GO.workflow.showVisual = function(id){
	if(!GO.workflow.visualTemplateWindow)
		GO.workflow.visualTemplateWindow = new GO.workflow.VisualTemplateWindow();
	GO.workflow.visualTemplateWindow.show(id);
}
