import { Field } from "./Field";
export declare abstract class InputField extends Field {
    protected _input: HTMLInputElement | HTMLTextAreaElement | HTMLSelectElement | undefined;
    protected fireChangeOnBlur: boolean;
    constructor();
    /**
     * Get the DOM HTMLInputElement
     */
    get input(): HTMLInputElement | HTMLSelectElement | HTMLTextAreaElement | undefined;
    set title(title: string);
    focus(o?: FocusOptions): void;
    protected createControl(): HTMLElement;
    protected createInput(): HTMLInputElement | HTMLSelectElement | HTMLTextAreaElement;
    setInvalid(msg: string): void;
    clearInvalid(): void;
    protected internalSetValue(v?: string | number | boolean | undefined): void;
    protected internalGetValue(): string | number | boolean | any[] | Record<string, any> | undefined;
    set name(name: string);
    get name(): string;
    set type(type: string);
    get type(): string;
    /**
     * Autocomplete value
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete
     *
     * @param autocomplete
     */
    set autocomplete(autocomplete: AutoFill);
    get autocomplete(): AutoFill;
    /**
     * When the field is empty this will be displayed inside the field
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/placeholder
     *
     * @param placeholder
     */
    set placeholder(placeholder: string);
    get placeholder(): string;
    /**
     * Make field read only
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly
     * @param readOnly
     */
    set readOnly(readOnly: boolean);
    get readOnly(): boolean;
    /**
     * Make field required
     */
    get required(): boolean;
    set required(required: boolean);
    get disabled(): boolean;
    set disabled(disabled: boolean);
    protected validate(): void;
}
//# sourceMappingURL=InputField.d.ts.map