/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Config } from "../Observable";
import { FieldEventMap } from "./Field";
import { DateTime } from "../../util";
import { InputField } from "./InputField";
export interface DateField {
    /**
     * The value of the date is in Y-m-d  or  Y-m-d H:i when withTime is true. {@link DateTime.format}
     * @param v
     */
    set value(v: string | undefined);
    get value(): string | undefined;
    get input(): HTMLInputElement;
}
/**
 * Date field
 *
 * @property min The minimum value allowed. Same format as {@link DateField.value}.
 * @property max The maximum value allowed. Same format as {@link DateField.value}.
 *
 * @see Form
 */
export declare class DateField extends InputField {
    protected baseCls: string;
    /**
     * When switching the "withTime" property, this default time will be used.
     *
     * Use H:i format see {@link DateField.format}
     */
    defaultTime?: string;
    constructor();
    /**
     * Also render time input
     *
     * @param withTime
     */
    set withTime(withTime: boolean);
    private appendTime;
    get withTime(): boolean;
    protected internalSetValue(v?: string | undefined): void;
    protected outputFormat(): string;
    /**
     * The minimum number allowed
     *
     * The value of the time input is always in 24-hour format that includes leading zeros: hh:mm
     *
     * @param min
     */
    set min(min: string);
    get min(): string;
    /**
     * The maximum number allowed
     *
     * The value of the time input is always in 24-hour format that includes leading zeros: hh:mm
     *
     * @param max
     */
    set max(max: string);
    get max(): string;
    /**
     * Get the date as DateTime object
     */
    getValueAsDateTime(): DateTime | undefined;
}
/**
 * Shorthand function to create {@see DateField}
 *
 * @param config
 */
export declare const datefield: (config?: Config<DateField, FieldEventMap<DateField>>) => DateField;
//# sourceMappingURL=DateField.d.ts.map