/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Component } from "../Component.js";
import { Config } from "../Observable";
/**
 * Display field
 *
 * Component used to display data only.
 *
 * A {@see Form} can be used to edit data but also to present data using display fields
 */
export declare class DisplayField extends Field {
    tagName: keyof HTMLElementTagNameMap;
    renderer: DisplayFieldRenderer;
    /**
     *
     * @param tagName Tagname defaults to ="label". If you pass another tag like h3 for example it will render a simple tag: <h3>{renderedValue}</h3>
     * @param renderer Renderer function for the value of the field
     */
    constructor(tagName?: keyof HTMLElementTagNameMap, renderer?: DisplayFieldRenderer);
    protected baseCls: string;
    /**
     * Escape value HTML
     *
     * {@link Format.escapeHTML}
     */
    escapeValue: boolean;
    /**
     * Hide this field when the value is empty
     */
    hideWhenEmpty: boolean;
    protected renderTagOnly: boolean;
    protected createControl(): HTMLElement | undefined;
    protected internalSetValue(v?: any): void;
    protected renderControl(): void;
}
type DisplayFieldRenderer = (v: any, field: DisplayField) => string | Promise<string>;
type DisplayFieldConfig = Config<DisplayField, FieldEventMap<DisplayField>> & {
    /**
     * Renderer function for the value of the field
     */
    renderer?: DisplayFieldRenderer;
};
/**
 * Shortcut function to create a {@see DisplayField}
 *
 * @param config
 * @param items
 */
export declare const displayfield: (config: DisplayFieldConfig, ...items: Component[]) => DisplayField;
/**
 * Create display field with date icon and renderer
 *
 * @param config
 * @param items
 */
export declare const displaydatefield: (config: DisplayFieldConfig, ...items: Component[]) => DisplayField;
export {};
//# sourceMappingURL=DisplayField.d.ts.map