/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { createComponent } from "../Component.js";
import { Field } from "./Field.js";
import { btn } from "../Button.js";
import { Menu, menu } from "../menu/Menu.js";
import { listpicker } from "../picker";
/**
 * ColorField component
 *
 * @see Form
 */
export class ListField extends Field {
    constructor(list, valueProperty = "id") {
        super();
        this.list = list;
        this.valueProperty = valueProperty;
        this.baseCls = "goui-form-field listfield";
        this.picker = listpicker({
            list: this.list,
        });
        this.picker.on("select", (tablePicker, record) => {
            tablePicker.list.findAncestorByType(Menu).hide();
            this.focus();
            //set value after focus for change event
            this.value = this.pickerRecordToValue(this, record);
            this.fire('select', this, record);
        });
        this.menu = menu({
            height: 300,
            cls: "scroll",
            listeners: {
                hide: (menu) => {
                    if (menu.rendered) {
                        const f = menu.findAncestorByType(ListField);
                        f.focus();
                    }
                }
            }
        }, this.picker);
        this.menuButton = btn({
            icon: "expand_more",
            type: "button",
            handler: () => {
                //this.fire("autocomplete", this, "");
                void this.list.store.load();
                this.picker.show();
            },
            menu: this.menu
        });
    }
    internalRender() {
        this.buttons = this.buttons || [];
        this.buttons.push(this.menuButton);
        const el = super.internalRender();
        this.menu.alignTo = this.wrap;
        this.menu.alignToInheritWidth = true;
        return el;
    }
    pickerRecordToValue(_field, record) {
        return record[this.valueProperty];
    }
    createControl() {
        this.container = document.createElement("div");
        return this.container;
    }
    internalSetValue(v) {
        if (v == undefined) {
            return super.internalSetValue(v);
        }
        this.renderValue(this, v + "").then(v => {
            if (this.container)
                this.container.innerHTML = v;
        });
    }
    /**
     * This method transforms the value in to a HTML representation
     *
     * @param field
     * @param value
     */
    async renderValue(field, value) {
        return "";
    }
}
/**
 * Shorthand function to create {@link ListField}
 *
 * @param config
 */
export const listfield = (config) => createComponent(new ListField(config.list), config);
//# sourceMappingURL=ListField.js.map