/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { DateTime } from "./DateTime.js";
interface RecurrenceConfig {
    rule: RecurrenceRule;
    dtstart: Date;
    ff: Date;
}
type NDay = {
    day: string;
    nthOfPeriod?: number;
};
export type Frequency = "yearly" | "monthly" | "weekly" | "daily";
type DayOfWeek = 'mo' | 'tu' | 'we' | 'th' | 'fr' | 'sa' | 'su';
export type RecurrenceRule = {
    frequency: Frequency;
    interval?: number;
    skip?: 'omit' | 'backward' | 'forward';
    firstDayOfWeek?: DayOfWeek;
    count?: number;
    until?: string;
    byDay?: NDay[];
    byMonthDay?: number[];
    byMonth?: string[];
    bySetPosition?: number[];
    byWeekNo?: number[];
    byYearDay?: number[];
    byHour?: number[];
};
/**
 * Class for looping date for Recurrence Rule
 *
 * @category Utility
 */
export declare class Recurrence {
    static dayMap: string[];
    completed?: boolean;
    rule: RecurrenceRule & {
        interval: number;
    };
    dtstart: Date;
    until?: Date;
    current: DateTime;
    last?: DateTime;
    occurrence: number;
    indices: {
        BYSECOND: number;
        BYMINUTE: number;
        BYHOUR: number;
        BYDAY: number;
        BYMONTH: number;
        BYWEEKNO: number;
        BYMONTHDAY: number;
    };
    private dayNb;
    constructor(config: RecurrenceConfig);
    next(): DateTime | null;
    private nDayHas;
    private nextDaily;
    private nextWeekly;
    private nextMonthly;
    private nextYearly;
    private validate;
}
export {};
//# sourceMappingURL=Recurrence.d.ts.map