go.modules.business.contracts.ContractDetail = Ext.extend(go.detail.Panel, {
	entityStore: "Contract",
	stateId: 'no-Contract-detail',

	relations: ["book"],

	initComponent: function () {
		this.frontendConfig = go.modules.business.contracts.ModuleConfig.frontendOptions;

		this.tbar = this.initToolbar();

		this.items = this.createItems();


		go.modules.business.contracts.ContractDetail.superclass.initComponent.call(this);

		this.addCustomFields();

		if(this.frontendConfig.showLinks) {
			this.addLinks();
		}
		if(this.frontendConfig.showComments) {
			this.addComments();
		}
		if(this.frontendConfig.showFileUploads) {
			this.addFiles();
		}
		if(this.frontendConfig.showModifyPanel) {
			this.add(new go.detail.CreateModifyPanel());
		}
	},



	createItems: function () {
		var me = this;
		var tplConfig = Ext.apply({
			currency: function () {
				return me.data.book.currency;
			},

			total: function(items) {

				var cost = 0;
				Object.values(items).forEach(function(i) {
					cost += i.quantity * i.unitPrice;
				});

				return cost;
			},


		}, go.modules.business.contracts.util);

		return [{
			tpl: new Ext.XTemplate(

				'<div class="pad">' +
					'{[this.getStatusBadge(values)]}'+
					'<h3>' + t("Contract") + ': {number}<br /><small>{description}</small></h3>' +
				'</div>' +
				'<div class="icons">' +
				'<p class="s4">' +
				'<i class="icon label">schedule</i>' +
				'<span>{[go.util.Format.date(values.startsAt)]}</span>	' +
				'<label>{[t("Starts at")]}</label>' +
				'</p>' +

				'<p class="s4">' +
				'<i class="icon label">schedule</i>' +
				'<span>{[values.endsAt ? go.util.Format.date(values.endsAt) : "-"]}</span>	' +
				'<label>{[t("Ends at")]}</label>' +
				'</p>' +

				'<p class="s4">' +
				'<i class="icon label">schedule</i>' +
				'<span>{[go.util.Format.date(values.nextAt)]}</span>	' +
				'<label>{[t("Next invoice at")]}</label>' +
				'</p>' +

				'<a class="s4" href="#contact/{customerId}">' +
					'<i class="icon label">business</i>' +
					'<span>{customer}</span>	' +
					'<label>{[t("Customer", "addressbook", "community")]}</label>' +
				'</a>' +

				'<tpl if="reference">' +
				'<p class="s4">' +
				'<i class="icon label">star</i>' +
				'<span>{reference}</span>	' +
				'<label>{[t("Reference")]}</label>' +
				'</p>' +
				'</tpl>' +

				'</div>',
				tplConfig
			)
		},

			{
				collapsible: true,
				stateId: 'finance-detail-items',
				title: t("Items"),
				tpl: new Ext.XTemplate(
					'<div class="pad">' +
					'<table class="display-panel">' +
					'<tr class="line">' +
					'<th>{[t("Quantity")]}</th>' +
					'<th>{[t("Description")]}</th>' +
					'<th class="right">{[t("Unit price")]}</th>' +
					'</tr>' +

					'<tpl for="items">' +
						'<tr  class="line">' +
						'<td>{[go.util.Format.number(values.quantity,2)]}</td>' +
						'<td>{description}</td>' +
						'<td class="right">{[this.currency()]} {[go.util.Format.number(values.unitPrice,2)]}</td>' +

						'</tr>' +
					'</tpl>' +

					'<tr>' +
						'<td colspan="2" class="right">' + t("Total") + ':</td>' +
						'<td class="right"><strong>{[this.currency()]} {[go.util.Format.number(this.total(values.items), 2)]}</strong></td>' +

					'</tr>' +

					'</table>' +
					'</div>',
					tplConfig)
			}
			];
	},


	onLoad: function () {
		this.getTopToolbar().getComponent("edit").setDisabled(this.data.permissionLevel < go.permissionLevels.write);
		this.deleteItem.setDisabled(this.data.permissionLevel < go.permissionLevels.writeAndDelete);

		go.modules.business.contracts.ContractDetail.superclass.onLoad.call(this);
	},

	initToolbar: function () {
		var items = this.tbar || [];
		items = items.concat([
			'->',
			{
				itemId: "edit",
				iconCls: 'ic-edit',
				tooltip: t("Edit"),
				handler: function (btn, e) {
					var editDlg = new go.modules.business.contracts.ContractDialog();
					editDlg.load(this.data.id).show();
				},
				scope: this
			},

			this.moreMenu = {
				iconCls: 'ic-more-vert',
				menu: [{
				iconCls: "btn-print",
				text: t("Print"),
				handler: function () {
					this.body.print({title: this.data.name});
				},
				scope: this
			},
			"-",
			this.deleteItem = new Ext.menu.Item({
				itemId: "delete",
				iconCls: 'ic-delete',
				text: t("Delete"),
				handler: function () {
					Ext.MessageBox.confirm(t("Confirm delete"), t("Are you sure you want to delete this item?"), function (btn) {
						if (btn !== "yes") {
						return;
					}
					this.entityStore.set({destroy: [this.currentId]});
				}, this);
				},
				scope: this
			})
		]
		}]);
		if(this.frontendConfig.showLinks) {
			items.splice(3, 0, new go.detail.addButton({
				detailView: this
			}), {xtype: "linkbrowserbutton"});
		}

		if(this.frontendConfig.showFileUploads && go.Modules.isAvailable("legacy", "files")) {
			items.splice(items.length - 1, 0,{
				xtype: "detailfilebrowserbutton"
			});
		}

		var tbarCfg = {
			disabled: true,
			items: items
		};
		return new Ext.Toolbar(tbarCfg);
	}
});
