
go.modules.business.finance.DebtorProfileGrid = Ext.extend(go.grid.GridPanel, {
	businessId: null,
	viewConfig: {
		emptyText: 	'<p>' +t("No items to display") + '</p>'
	},

	initComponent: function () {
		this.viewConfig.actionConfig = {
			scope: this,
			menu: {
				items: [
					{
						itemId: "edit",
						iconCls: 'ic-edit',
						text: t("Edit"),
						handler: function(item) {

							var record = this.store.getAt(item.parentMenu.rowIndex);
							this.edit(record.data.id);

						},
						scope: this
					},{
						itemId: "delete",
						iconCls: 'ic-delete',
						text: t("Delete"),
						handler: function(item) {
							var record = this.store.getAt(item.parentMenu.rowIndex);
							this.getSelectionModel().selectRecords([record]);
							this.deleteSelected();
						},
						scope: this
					}

				]
			}
		};

		Ext.apply(this, {
			tbar: [
				'->',
				{
					xtype: 'tbsearch'
				},
				{
					iconCls: 'ic-add',
					handler: function() {
						var dlg = new go.modules.business.finance.DebtorProfileDialog();
						dlg.setValues({businessId: this.store.getFilter("businessId").businessId}).show();
					},
					scope: this
				}],

			store: new go.data.Store({
				fields: ['id', 'name'],
				entityStore: "DebtorProfile"
			}),
			autoHeight: true,
			columns: [
				{
					id: 'name',
					header: t('Name'),
					sortable: false,
					dataIndex: 'name'
				}
			],
			listeners : {
				render: function() {
					if(!this.disabled) {
						this.store.load();
					}
				},
				scope: this
			},
			autoExpandColumn: 'name'
		});

		go.smtp.GridPanel.superclass.initComponent.call(this);

		this.on("rowdblclick", function(grid, rowIndex, e) {
			var record = grid.getStore().getAt(rowIndex);
			this.edit(record.data.id);
		}, this);
	},


	edit: function(id) {
		var dlg = new go.modules.business.finance.DebtorProfileDialog();
		dlg.load(id).show();
	}
});