/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */

go.modules.business.finance.FinanceDocumentMainPanel = Ext.extend(go.modules.ModulePanel, {
	layout: 'responsive',
	layoutConfig: {
		triggerWidth: 1000
	},

	initComponent: function () {
		this.createFinanceDocumentGrid();

		this.FinanceDocumentDetail = new go.modules.business.finance.FinanceDocumentDetail({
			region: 'center',
			split: true,
			tbar: [{
				cls: 'go-narrow', //will only show on small devices
				iconCls: "ic-arrow-back",
				handler: function () {
					this.westPanel.show();
					go.Router.goto("finance");
				},
				scope: this
			}]
		});

		var sum = function(a, b) { return a + b };

		this.pieChart = new go.chart.PieChart({
			height: dp(200),
			width: dp(200),
			options: {
				plugins: [
					Chartist.plugins.tooltip({
						currency: '€'
					})
				]
			}
		});

		this.sidePanel = new Ext.Panel({

			width: dp(300),
			cls: 'go-sidenav',
			region: "west",
			split: true,
			hidden: true,
			autoScroll: true,
			layout: "anchor",
			defaults: {
				anchor: "100%"
			},
			items: [
				this.createBookPanel(),
				{
					xtype: "button",
					cls: "go-list-btn",
					text: t("Payments"),
					scope: this,
					handler: function() {
						this.ownerCt.getLayout().setActiveItem(1);
					}
				},
				this.debtorBtn = new Ext.Button({
					xtype: "button",
					cls: "go-list-btn",

					text: t("Debtors"),
					scope: this,
					handler: function() {
						this.ownerCt.getLayout().setActiveItem(2);
					}
				}),
				this.createStatusGrid(),
				this.pieChart,
				this.createFilterPanel()
			]
		});

		this.westPanel = new Ext.Panel({
			region: "west",
			layout: "responsive",
			stateId: "go-finance-west",
			split: true,
			width: dp(900),
			narrowWidth: dp(400), //this will only work for panels inside another panel with layout=responsive. Not ideal but at the moment the only way I could make it work
			items: [
				this.FinanceDocumentGrid, //first is default in narrow mode
				this.sidePanel
			]
		});

		this.items = [
			this.westPanel //first is default in narrow mode
		];

		this.items.push(this.FinanceDocumentDetail);
		this.sidePanel.show();

		go.modules.business.finance.FinanceDocumentMainPanel.superclass.initComponent.call(this);

		//use viewready so load mask can show
		this.FinanceDocumentGrid.on("viewready", this.runModule, this);
	},

	createStatusGrid : function() {
		this.statusGrid = new go.modules.business.finance.StatusGrid({
			autoHeight: true,
			pieChart: this.pieChart
		});

		this.statusGrid.getSelectionModel().on('selectionchange', this.onStatusSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first

		return this.statusGrid;
	},

	onStatusSelectionChange : function (sm) {
		var statuses = [];

		Ext.each(sm.getSelections(), function (r) {
			statuses.push(r.data.id);
		}, this);

		this.FinanceDocumentGrid.store.setFilter("status", statuses.length ? {status: statuses} : null);
		this.FinanceDocumentGrid.store.load();

	},

	runModule: function () {
		this.financeBookGrid.store.load();
		// this.FinanceDocumentGrid.store.load();
	},

	createBookPanel : function() {
		this.financeBookGrid = new go.modules.business.finance.FinanceBookGrid({
			tbar: [{
				xtype: 'tbtitle',
				text: t('Books')
			}, '->', {
				xtype: "tbsearch"
			},{
				iconCls: 'ic-add',
				tooltip: t('Add'),
				handler: function (e, toolEl) {
					var dlg = new go.modules.business.finance.FinanceBookDialog();
					dlg.show();
				}
			},
				{
					cls: 'go-narrow',
					iconCls: "ic-arrow-forward",
					tooltip: t("Notes"),
					handler: function () {
						this.FinanceDocumentGrid.show();
					},
					scope: this
				}],
			filterName: "bookId",
			filteredStore: this.FinanceDocumentGrid.store,
			saveSelection: true,
			stateId: "finance-books",
			region: "north",
			autoHeight: true
		});
		this.financeBookGrid.getSelectionModel().on('selectionchange', this.onFinanceBookSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first

		return this.financeBookGrid;
	},

	onFinanceBookSelectionChange : async function (sm, ids) {

		var selected = sm.getSelected();
		if(!selected) {
			Ext.MessageBox.alert(t("No book", "There are no books defined yet in the system settings"));
			this.setDisabled(true);
		}

		go.modules.business.finance.business = selected.data;

		this.bookId = selected.id;
		this.addButton.setDisabled(!this.bookId);
		// this.FinanceDocumentGrid.store.setFilter("book", {bookId: this.bookId});
		// this.FinanceDocumentGrid.store.load();

		this.book = await go.Db.store("FinanceBook").single(selected.id);

		this.FinanceDocumentGrid.book = this.book;
		this.statusGrid.setBook(this.book);

	},


	// createDocumentTypeGrid: function() {
	// 	this.documentTypeGrid = new go.modules.business.finance.DocumentTypeGrid();
	//
	// 	return this.documentTypeGrid;
	// },
	//
	// onDocumentTypeSelectionChange : function (sm) {
	//
	// 	var selected = sm.getSelected();
	// 	if(!selected) {
	// 		Ext.MessageBox.alert(t("No business", "There are no businesses defined yet in the system settings"));
	// 		this.setDisabled(true);
	// 	}
	//
	// 	go.modules.business.finance.type = selected.data.value;
	//
	// 	this.documentType = selected.data.value;
	//
	// 	if(this.documentType == 'payments') {
	// 		this.ownerCt.getLayout().setActiveItem(1);
	//
	//
	// 	}else {
	// 		this.ownerCt.getLayout().setActiveItem(0);
	//
	// 		this.FinanceDocumentGrid.store.setFilter("type", {type: this.documentType});
	// 		this.FinanceDocumentGrid.store.load();
	// 	}
	//
	// 	this.statusGrid.documentType = this.documentType;
	//
	// },

	createFilterPanel: function () {
		return new Ext.Panel({
			region: "center",
			minHeight: dp(200),
			autoScroll: true,
			tbar: [{
				xtype: 'tbtitle',
				text: t("Filters")
			},
				'->',
				{
					xtype: 'filteraddbutton',
					entity: 'FinanceDocument'
				}],
			items: [
				this.filterGrid = new go.filter.FilterGrid({
					filterStore: this.FinanceDocumentGrid.store,
					entity: "FinanceDocument"
				}),
				{
					xtype: 'variablefilterpanel',
					filterStore: this.FinanceDocumentGrid.store,
					entity: "FinanceDocument"
				}
			]
		});
	},
	createFinanceDocumentGrid: function () {
		this.FinanceDocumentGrid = new go.modules.business.finance.FinanceDocumentGrid({
			region: 'center',
			summary: false,
			multiSelectToolbarItems: [
				{
					hidden: go.customfields.CustomFields.getFieldSets('FinanceDocument').length == 0,
					iconCls: 'ic-edit',
					tooltip: t("Batch edit"),
					handler: function() {
						var dlg = new go.form.BatchEditDialog({
							entityStore: "FinanceDocument"
						});
						dlg.setIds(this.FinanceDocumentGrid.getSelectionModel().getSelections().column('id')).show();
					},
					scope: this
				}
			],
			tbar: [{
				cls: 'go-narrow', //Shows on mobile only
				iconCls: "ic-menu",
				handler: function () {
					this.sidePanel.show();
				},
				scope: this
			},
				'->',
				{
					xtype: 'tbsearch',
				},
				this.addButton = new Ext.Button({
					iconCls: 'ic-add',
					tooltip: t('Add'),
					cls: "primary",
					handler: function (btn) {
						var FinanceDocumentForm = new go.modules.business.finance.FinanceDocumentDialog({
							type: this.book.type
						});
						FinanceDocumentForm.setValues({
							bookId: this.bookId
						})
						FinanceDocumentForm.show();
					},
					scope: this
				}),
				this.moreBtn = new Ext.Button({
					iconCls: 'ic-more-vert',
					menu: [{
						iconCls: "ic-show-chart",
						text: t("Report"),
						handler: function() {
							const win = new go.modules.business.finance.MonthlyReportWindow();
							win.load(this.bookId, (new Date).getFullYear());
							win.show();
						},
						scope: this
					}]
				})],
			listeners: {
				rowdblclick: this.onGridDblClick,
				scope: this,
				keypress: this.onGridKeyPress
			}
		});

		this.FinanceDocumentGrid.on('navigate', function (grid, rowIndex, record) {
			go.Router.goto("FinanceDocument/" + record.id);
		}, this);

		this.FinanceDocumentGrid.store.on('load', function(store, records, options) {
			if(!options.add) {
				this.statusGrid.updateTotals(options.params);
			}
		}, this);

		this.moreBtn.menu.add('-', {
				iconCls: 'ic-cloud-upload',
				text: t("Import"),
				handler: function () {
					go.util.importFile(
						'FinanceDocument',
						'.csv,.xlsx',
						{
							bookId: this.bookId
						},
						{}
					);
				},
				scope: this
			},
			this.exportButton = new Ext.menu.Item({
				iconCls: 'ic-cloud-download',
				text: t("Export"),
				menu: [
					{
						text: 'PDF in ZIP file',
						iconCls: 'filetype filetype-pdf',
						handler: function() {
							go.util.exportToFile(
								'FinanceDocument',
								Object.assign(go.util.clone(this.FinanceDocumentGrid.store.baseParams), this.FinanceDocumentGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'pdf');
						},
						scope: this
					},{
						text: 'Microsoft Excel',
						iconCls: 'filetype filetype-xls',
						handler: function() {
							go.util.exportToFile(
								'FinanceDocument',
								Object.assign(go.util.clone(this.FinanceDocumentGrid.store.baseParams), this.FinanceDocumentGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'xlsx');
						},
						scope: this
					},{
						text: 'Comma Separated Values',
						iconCls: 'filetype filetype-csv',
						handler: function() {
							go.util.exportToFile(
								'FinanceDocument',
								Object.assign(go.util.clone(this.FinanceDocumentGrid.store.baseParams), this.FinanceDocumentGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'csv');
						},
						scope: this
					},
					{
						iconCls: 'filetype filetype-json',
						text: 'JSON',
						handler: function() {
							go.util.exportToFile(
								'FinanceDocument',
								Ext.apply(go.util.clone(this.FinanceDocumentGrid.store.baseParams), this.FinanceDocumentGrid.store.lastOptions.params, {limit: 0, start: 0}),
								'json');
						},
						scope: this
					}
				]
			})

		);


		return this.FinanceDocumentGrid;
	},
	onGridDblClick: function (grid, rowIndex, e) {

		var record = grid.getStore().getAt(rowIndex);
		if (record.get('permissionLevel') < go.permissionLevels.write) {
			return;
		}

		var dlg = new go.modules.business.finance.FinanceDocumentDialog();
		dlg.load(record.id).show();
	},

	onGridKeyPress: function (e) {
		if (e.keyCode != e.ENTER) {
			return;
		}
		var record = this.FinanceDocumentGrid.getSelectionModel().getSelected();
		if (!record) {
			return;
		}

		if (record.get('permissionLevel') < go.permissionLevels.write) {
			return;
		}

		var dlg = new go.modules.business.finance.FinanceDocumentDialog();
		dlg.load(record.id).show();
	}
});