<?php

use go\core\model\Module as CoreModuleModel;

$updates['202202071158'][] = "alter table studio_studio add moduleAclId int null;";
$updates['202202071158'][] = function() {
	foreach(\go\modules\business\studio\model\Studio::find() as $mod) {

		$mod->save();

		$module = CoreModuleModel::findByName($mod->package, $mod->moduleName);
		if(!$module) {
			echo "Module not found : " .$mod->package . "/" . $mod->moduleName ."\n";
			continue;
		}

		if(!\go\core\model\Module::isInstalled("legacy", "files")) {
			continue;
		}

		$entities = $module->getEntities();
		foreach($entities as $e) {
			$cls = $e->getClassName();
			$folderIds = $cls::find()->selectSingleValue('filesFolderId');

			$updateQ = go()->getDbConnection()
				->update("fs_folders",
					['acl_id' => $mod->moduleAclId],
					(new \go\core\db\Query())->where('id', 'in', $folderIds)
				);

			echo $updateQ ."\n";

			$updateQ->execute();

		}
	}
};

$updates['202202071158'][] = "alter table studio_studio
    add constraint studio_studio_core_acl_id_fk
        foreign key (moduleAclId) references core_acl (id);";
