import {
	avatar,
	btn,
	comp,
	Component,
	DataSourceStore,
	datasourcestore,
	Format,

	Notifier,
	QuoteStripper,
	t,
	win
} from "@intermesh/goui";
import {client, Image, img, JmapDataSource, jmapds} from "@intermesh/groupoffice-core";

export class CommentList extends Component {
	store: DataSourceStore;

	constructor() {
		super();

		this.cls = "comments main";

		this.store = datasourcestore({
			dataSource: jmapds("Comment"),
			listeners: {
				load: (store, records) => {
					const comments = this;

					comments.items.clear();

					const imgProms: Promise<any>[] = [];

					records.forEach(record => {

						const qs = new QuoteStripper(record.text), quote = qs.getQuote();

						let quoteLess = qs.getBodyWithoutQuote();


						const text = comp({
							cls: "text normalize",
							html: quoteLess,
							listeners: {

								beforerender: (cmp) => {
									imgProms.push(Image.replaceImages(cmp.el));

									// Enlarge images when clicked in window
									cmp.el.addEventListener("click", (e) => {
										if (e.target && (e.target as HTMLElement).tagName == "IMG") {
											const img = e.target as HTMLImageElement

											const imageWin = win({
													width: window.innerWidth - 50,
													height: window.innerHeight - 50,
													maximized: true,
													maximizable: true,
													modal: true,
													title: img.alt ?? "Image",
												},
												comp({
													flex: 1,
													itemId: "img-cont",

													style: {
														alignItems: "center",
														justifyContent: "center"
													},
													listeners: {
														beforerender: (w) => {
															const i = img.cloneNode() as HTMLImageElement;
															i.style.height = "100%";
															i.style.width = "100%";
															i.style.objectFit = "contain";
															w.el.appendChild(i);
														}
													}
												})
											);

											imageWin.show();

										}
									});
								}
							}
						});

						const name = record.creator?.displayName ?? t("Unknown user");

						const comment = comp({
								cls: "comment"
							},
							comp({
									cls: "meta"
								},
								record.creator?.avatarId ?

									img({
										cls: "goui-avatar",
										blobId: record.creator.avatarId,
										title: name
									}) :

									avatar({
										displayName: name
									}),

								comp({
									cls: "author",
									html: name
								}),
								comp({cls: "divider"}),

								comp({
									cls: "date",
									html: Format.dateTime(record.createdAt)
								})
							),

							text

						)

						if(quote) {
							text.items.add(
								btn({
									cls: "raised",
									text: t("More"),
									handler: (btn) => {
										text.html = record.text;

										Image.replaceImages(text.el);
										btn.remove();
									}
								})
							);
						}

						const attachments = comp({cls: "attachments"});

						record.attachments.forEach((a: any) => {
							attachments.items.add(
								btn({
									icon: "description",
									text: a.name,
									handler: () => {
										client.downloadBlobId(a.blobId, a.name).catch((error) => {
											Notifier.error(error);
										})
									}
								}))
						});

						comment.items.add(attachments);

						comments.items.add(comment);
					});
				}
			},
			relations: {
				creator: {
					path: "createdBy",
					dataSource: jmapds("UserDisplay")
				}
			},
			queryParams: {
				filter: {
					entity: "Task"
				}
			}
		});
	}
}