<?php


namespace GO\Timeregistration2;


use go\core\model\User;
use go\core\orm\Mapping;
use go\core\orm\Property;
use go\core\orm\Query;
use go\modules\community\tasks\model\Task;

class Timeregistration2Module extends \GO\Professional\Module {

	public function depends() {
		return array('projects2');
	}

    public function defineListeners() {
        User::on(Property::EVENT_MAPPING, static::class, 'onMap');
	    Task::on(Property::EVENT_MAPPING, static::class, 'onTaskMap');

    }

    public static function onMap(Mapping $mapping) {
        $mapping->addHasOne('timeRegistrationSettings', \GO\Timeregistration2\Model\UserSettings::class, ['id' => 'userId'], true);
    }


	public static function onTaskMap(Mapping $mapping)
	{
		$mapping->addQuery((new Query())
			->select('COALESCE(SUM(prh.duration) * 60, 0) AS timeBooked')
		    ->join('pr2_hours', 'prh', 'prh.task_id = task.id', 'left')
		    ->groupBy(['task.id'])
	    );
    }


	/**
	 * The module settings
	 * @var \GO\Projects2\Model\Settings
	 * @see getSettings()
	 */
	private $_settings;

	public function getSettings() {
		if (!isset($this->_settings))
			$this->_settings = \GO\Projects2\Model\Settings::load();
		return $this->_settings;
	}

	public function autoInstall() {
		return true;
	}

}
