Ext.define('GO.timeregistration2.TimeDialog', {
    extend: go.Window,
    width: dp(800),
    height: dp(700),
    layout:'fit',
    showUser: false,
    stateId: 'timeregistration2-timedialog',
    customFieldType: 'TimeEntry',
    title: t('Time entry'),
    listeners: {
        show: function(win) {
            win.items.get(0).focus();
        }
    },

    initComponent: function() {

        const now = new Date();
        this._panels = [{
            xtype:'panel',
            cls:'go-form-panel',
            autoScroll:true,
            layout:'form',
            items: [
                {
                    xtype:'textarea',
                    hideLabel:true,
                    height: 120,
                    name: 'comments',
                    placeholder: t('What did you do?'),
                    width: '100%'
                },{
                    xtype:'container',
                    layout:'column',
                    defaults: {
                        layout: 'form',
                        xtype:'container',
                        labelAlign:'top'
                    },
                    items:[{columnWidth: .35,items:[{
                            xtype:'datefield',
                            fieldLabel: t("Date"),
                            name: "date",
                            allowBlank:false,
                            value: now
                        }]},{columnWidth: .45,
                        items:[{
                            xtype: "container",
                            layout:'hbox',
                            fieldLabel: t("Time"),
                            items: [
                                {
                                    itemId:'start',
                                    xtype:'nativetimefield',
                                    inMinutes:true,
                                    value: now.getHours() * 60 + now.getMinutes() - 60,
                                    listeners: {
                                        change: function(me,start) {
                                            var form = me.findParentByType('form'),
                                                endField = form.find('itemId', 'end')[0],
                                                durationField = form.find('itemId', 'duration')[0];
                                            if (durationField.getValue()) {
                                                var duration = durationField.getMinutes();
                                                endField.setMinutes(start + duration);
                                            } else if (endField.getValue()) {
                                                var end = endField.getMinutes();
                                                durationField.setMinutes(end - start);
                                            }
                                        }
                                    }
                                },
                                {html:'-', padding:0},
                                {
                                    xtype:'nativetimefield',
                                    submit:false,
                                    inMinutes:true,
                                    itemId: 'end',
                                    value: now.getHours() * 60 + now.getMinutes(),
                                    listeners:{
                                        change: function(me,end){
                                            var form =  me.findParentByType('form'),
                                                startField = form.find('itemId', 'start')[0],
                                                durationField = form.find('itemId', 'duration')[0];
                                            if (startField.getValue()) {
                                                var start = startField.getMinutes();
                                                durationField.setMinutes(end - start);
                                            } else if(durationField.getValue()) {
                                                var duration = durationField.getMinutes();
                                                startField.setMinutes(end - duration);
                                            }
                                        }
                                    }
                                }
                            ]
                        }]},{columnWidth: .2,items:[{
                            xtype:'nativetimefield',
                            fieldLabel: t("Duration"),
                            itemId: "duration",
                            allowBlank:false,
                            value: 60,
                            inMinutes: true,
                            listeners:{
                                change: function(me,duration){
                                    var form =  me.findParentByType('form'),
                                        startField = form.find('itemId', 'start')[0],
                                        endField = form.find('itemId', 'end')[0];

                                    if(startField.getValue()) {
                                        var start = startField.getMinutes();
                                        endField.setMinutes(start + duration);
                                    } else if(endField.getValue()) {
                                        var end = endField.getMinutes();
                                        startField.setMinutes(end - duration);
                                    }
                                }
                            }
                        }]}]
                },this.activityField = new go.modules.business.business.ActivityCombo({
                    hiddenName: 'standard_task_id',
                    anchor:'100%',
                    emptyText: t("Standard working hours", "projects2"),
                    allowBlank: true,
                    hideLabel:true,
                }),
                this.projectField = new GO.projects2.SelectProject({
                    anchor:'100%',
                    allowBlank:false,
                    emptyText:'',
                    store:GO.projects2.selectBookableProjectStore,
                    listeners:{
                        change:function(cmp, newVal, oldVal){
                            this.taskField.store.setFilter("project", {projectId: newVal});

                            this.taskField.setDisabled(!newVal);

                            var record = GO.projects2.selectBookableProjectStore.getById(newVal);

                            if(record && !this.modelId) {
                                this.travelDistanceField.setValue(record.data.default_distance);
                            }
                            this.taskField.setValue("");
                            if(this.showUser) {
                                this.selectUser.store.setFilter('projectId', {projectId: newVal})
                                this.selectUser.setDisabled(!newVal);
                            }
                        },
                        scope:this
                    }
                }),
                this.taskField = new go.modules.community.tasks.TaskCombo({
                    anchor:'100%',
                    disabled: true,
                    hiddenName: 'task_id',
                    listeners: {
                        setvalue: function(combo, v) {
                            combo.setDisabled(!this.projectField.getValue());
                        },
                        scope: this
                    }
                }),
                this.travelDistanceField = new GO.form.NumberField({
                    fieldLabel:t("Travel distance", "projects2"),
                    name:'travel_distance',
                    width:dp(100)
                }),
                this.customFieldsContainer = new Ext.Container()
            ]
        }];

        if(this.showUser) {
            this.selectUser = new go.users.UserCombo({
                hiddenName: 'user_id'
            })

            this._panels[0].items.splice(this._panels[0].items.length - 2, 0, this.selectUser);
            this.selectUser.store.setFilter('isEmployee', {isEmployee: true});
        }

        // Use function from tabbed form dialog this fill customfields container
        this.addPanel = GO.projects2.TimeEntryDialog.superclass.addPanel;
        GO.projects2.TimeEntryDialog.superclass.addCustomFields.call(this);

        this.buttons = [
            {text: t('Save'),
            handler: function() {

                var formattedParams = {
                    start: this.formPanel.find('itemId', 'start')[0].getValue(),
                    duration: this.formPanel.find('itemId', 'duration')[0].getValue(),
                };
                if(this.modelId) {
                    formattedParams.id = this.modelId;
                }

                this.formPanel.getForm().submit({
                    clientValidation: true,
                    url: GO.url('projects2/timeEntry/submit'),
                    params: formattedParams,
                    scope:this,
                    success: function(form, action) {
                        this.close();
                    },
                    failure: function(form, action) {
                        switch (action.failureType) {
                            case Ext.form.Action.CLIENT_INVALID:
                                //Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
                                break;
                            case Ext.form.Action.CONNECT_FAILURE:
                                Ext.Msg.alert('Failure', 'Communication failed');
                                break;
                            case Ext.form.Action.SERVER_INVALID:
                                Ext.Msg.alert('Failure', action.result.feedback);
                        }
                    }
                });
            },scope:this}
        ];

        this.formPanel = new Ext.form.FormPanel({
            waitMsgTarget:true,
            border: false,
            layout:'fit'
        });
        this.items = [this.formPanel];

        this.callParent();


        if(this._panels.length === 1) {
            this.formPanel.add(this._panels[0]);
        } else {
            this._panels[0].title = t('General');
            this.formPanel.add(new Ext.TabPanel({
                activeTab: 0,
                enableTabScroll:true,
                deferredRender: false,
                border: false,
                anchor: '100% 100%',
                items: this._panels
            }));
        }
    },

    setValues: function(v) {
        if(v.id) {
            this.modelId = v.id;
        }

        if(v.task_id) {
            // carry on!
        } else if(v.project_id) {
            go.Db.store("Project").single(v.project_id).then((project) =>{

                this.projectField.setValue(project.id);
                this.projectField.setRemoteText(project.path);
                this.projectField.fireEvent('change', this, v.project_id);


                this.taskField.setValue(v.task_id);

            });
        }
        this.formPanel.form.setValues(v);
        if(v.project_name) {
            this.projectField.setRemoteText(v.project_name);
        }
    }
});