/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
import { InputField } from "./InputField";
export type TextFieldType = ("text" | "password" | "email" | "url" | "tel" | "search");
export interface TextField {
    get input(): HTMLInputElement;
}
/**
 * TextField component
 *
 * @see Form
 */
export declare class TextField extends InputField {
    protected baseCls: string;
    constructor();
    /**
     * The input type
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/text
     * @param type
     */
    set type(type: TextFieldType);
    get type(): TextFieldType;
    /**
     * Pattern regex for validation
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/pattern
     *
     * @param pattern
     */
    set pattern(pattern: HTMLInputElement["pattern"]);
    get pattern(): HTMLInputElement["pattern"];
}
/**
 * Shorthand function to create {@see TextField}
 *
 * @param config
 */
export declare const textfield: (config?: Config<TextField, FieldEventMap<TextField>>) => TextField;
//# sourceMappingURL=TextField.d.ts.map