import { root } from "@intermesh/goui";
import { client } from "../jmap/index.js";
import { Login } from "./Login";
/**
 * Authentication manager
 */
class AuthManager {
    /**
     * Will continue if user is authenticated and present login dialog if not
     *
     * @todo what if there are concurrent requests to this method?
     */
    async requireLogin() {
        if (this._requireLogin) {
            return this._requireLogin;
        }
        this._requireLogin = new Promise(async (resolve) => {
            root.mask();
            let user = await client.isLoggedIn();
            root.unmask();
            while (!user) {
                await this.showLogin();
                user = await client.isLoggedIn();
            }
            resolve(user);
        });
        return this._requireLogin;
    }
    showLogin() {
        return new Promise((resolve, reject) => {
            const login = new Login();
            login.show();
            login.on('login', () => {
                resolve();
            });
            login.on('cancel', () => {
                reject();
            });
        });
    }
}
export const authManager = new AuthManager();
//# sourceMappingURL=AuthManager.js.map