import { comp, Component, createComponent, FunctionUtil } from "@intermesh/goui";
export class FilterPanel extends Component {
    constructor(entityName, store) {
        super();
        this.entityName = entityName;
        this.store = store;
        this.items.add(comp({}, //somehow an extra comp is needed for the ext toolbar to resize properly
        this.goFilterPanel = new go.filter.FilterPanel({
            entity: entityName,
            store: store
        })));
        this.on("render", () => {
            const ro = new ResizeObserver(FunctionUtil.onRepaint(() => {
                this.goFilterPanel.setWidth(this.el.offsetWidth);
            }));
            ro.observe(this.el);
        });
    }
}
export const filterpanel = (config) => createComponent(new FilterPanel(config.entityName, config.store), config);
//# sourceMappingURL=FilterPanel.js.map