/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
// import {LanguageKeys} from "../locale/LanguageKeys";
import { ObjectUtil } from "./util/ObjectUtil.js";
export class Translate {
    constructor() {
        this.lang = {};
        this.missing = {};
        this.defaultPkg = "core";
        this.defaultModule = "core";
    }
    setDefaultModule(pkg, module) {
        this.defaultModule = module;
        this.defaultPkg = pkg;
    }
    load(lang, pkg = "core", module = "core") {
        if (!this.lang[pkg]) {
            this.lang[pkg] = {};
        }
        if (!this.lang[pkg][module]) {
            this.lang[pkg][module] = {};
        }
        ObjectUtil.merge(this.lang[pkg][module], lang);
        this.setDefaultModule(pkg, module);
    }
    /**
     * Translate a string
     *
     * @param key Translate key. Usually the english text.
     * @param pkg The module package
     * @param module The module name
     */
    static t(key, pkg, module) {
        var _a, _b, _c;
        if (!pkg) {
            pkg = translate.defaultPkg;
        }
        if (!module) {
            module = translate.defaultModule;
        }
        if ((_c = (_b = (_a = translate.lang) === null || _a === void 0 ? void 0 : _a[pkg]) === null || _b === void 0 ? void 0 : _b[module]) === null || _c === void 0 ? void 0 : _c[key]) {
            return translate.lang[pkg][module][key];
        }
        else if (pkg == "core" && module == "core") {
            if (!translate.missing[pkg]) {
                translate.missing[pkg] = {};
            }
            if (!translate.missing[pkg][module]) {
                translate.missing[pkg][module] = {};
            }
            translate.missing[pkg][module][key] = key;
            return key;
        }
        else {
            return t(key, "core", "core");
        }
    }
}
export const translate = new Translate();
export const t = Translate.t;
//# sourceMappingURL=Translate.js.map