/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
/**
 * @inheritDoc
 */
type ArrayFieldConfig = Config<ArrayField, FieldEventMap<ArrayField>, "buildField">;
type FieldBuilder = (value?: Record<string, any>) => Field;
type ArrayFieldValue = Record<string, any>[];
export interface ArrayField {
}
/**
 * Field to return an array with objects
 *
 * @see Form
 */
export declare class ArrayField extends Field {
    buildField: FieldBuilder;
    /**
     *
     * @param buildField Function that returns a new form field for an array item
     */
    constructor(buildField: FieldBuilder);
    protected renderControl(): void;
    private enableChangeEvent;
    set value(v: ArrayFieldValue);
    get value(): ArrayFieldValue;
    /**
     * Add value to the values array. Also fires change event
     *
     * @param value
     */
    addValue(value?: Record<string, any>): this;
    private internalAddValue;
    reset(): void;
}
/**
 * Shorthand function to create {@see ArrayField}
 *
 * @param config
 * @param items
 */
export declare const arrayfield: (config: ArrayFieldConfig, ...items: Field[]) => ArrayField;
export {};
//# sourceMappingURL=ArrayField.d.ts.map