/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { DateTime } from "../../util/DateTime.js";
import { RecurrenceRule } from "../../util/index.js";
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
export declare class RecurrenceField extends Field {
    private readonly picker;
    private readonly pickerButton;
    protected control: HTMLInputElement | undefined;
    protected baseCls: string;
    constructor();
    protected internalSetValue(v?: any): void;
    protected createControl(): HTMLInputElement;
    setStartDate(date: DateTime): void;
    static toText(rule: RecurrenceRule, start: DateTime): any;
    private static getSuffix;
}
/**
 * Shorthand function to create {@see RecurrenceField}
 *
 * @param config
 */
export declare const recurrencefield: (config?: Config<RecurrenceField, FieldEventMap<RecurrenceField>>) => RecurrenceField;
//# sourceMappingURL=RecurrenceField.d.ts.map