<?php
namespace Zotlabs\Module;

require_once('include/acl_selectors.php');
require_once('include/crypto.php');
require_once('include/items.php');
require_once('include/taxonomy.php');
require_once('include/conversation.php');
require_once('include/bookmarks.php');

/**
 * remote bookmark
 *
 * https://yoursite/rbmark?f=&title=&url=&private=&remote_return=
 *
 * This can be called via either GET or POST, use POST for long body content as suhosin often limits GET parameter length
 *
 * f= placeholder, often required
 * title= link text
 * url= URL to bookmark
 * ischat=1 if this bookmark is a chatroom
 * private= Don't share this link
 * remote_return= absolute URL to return after posting is finished
 *
 */
class Rbmark extends \Zotlabs\Web\Controller {

	public function post(): void {
		if($_POST['submit'] !== t('Save'))
			return;

		logger('rbmark_post: ' . print_r($_REQUEST,true));

		$channel = \App::get_channel();

		$t = array('url' => escape_tags($_REQUEST['url']),'term' => escape_tags($_REQUEST['title']));

		bookmark_add($channel,$channel,$t,((x($_REQUEST,'private')) ? intval($_REQUEST['private']) : 0),
			array('menu_id' => ((x($_REQUEST,'menu_id')) ? intval($_REQUEST['menu_id']) : 0),
			'menu_name' => ((x($_REQUEST,'menu_name')) ? escape_tags($_REQUEST['menu_name']) : ''),
			'ischat' => ((x($_REQUEST['ischat'])) ? intval($_REQUEST['ischat']) : 0)
			));

		goaway(z_root() . '/bookmarks');
	}


	public function get(): string {

		$channel_id = local_channel();
		if($channel_id === false) {

			// The login procedure is going to bugger our $_REQUEST variables
			// so save them in the session.

			if(array_key_exists('url',$_REQUEST)) {
				$_SESSION['bookmark'] = $_REQUEST;
			}
			return login();
		}

		// If we have saved rbmark session variables, but nothing in the
		// current $_REQUEST, recover the saved variables

		if((! array_key_exists('url',$_REQUEST)) && (array_key_exists('bookmark',$_SESSION))) {
			$_REQUEST = $_SESSION['bookmark'];
			unset($_SESSION['bookmark']);
		}

		$menu_select = [
			'menu_id',
			t('Select a bookmark folder'),
			false,
			'',
			$this->get_bookmark_folders(intval($channel_id)),
			null,
		];

		return replace_macros(get_markup_template('rbmark.tpl'), array(
			'$header' => t('Save Bookmark'),
			'$url' => array('url',t('URL of bookmark'),$_REQUEST['url'], null, null, null),
			'$title' => array('title',t('Description'),$_REQUEST['title'], null, null, null),
			'$ischat' => ((x($_REQUEST,'ischat')) ? intval($_REQUEST['ischat']) : 0),
			'$private' => ((x($_REQUEST,'private')) ? intval($_REQUEST['private']) : 0),
			'$submit' => t('Save'),
			'$menu_name' => array('menu_name',t('Or enter new bookmark folder name'),'','', null, null),
			'$menus' => $menu_select
		));
	}

	private function get_bookmark_folders(int $channel_id): array {
		$menu_list = menu_list($channel_id, '', MENU_BOOKMARK);

		$menus = [ 0 => '' ];

		if ($menu_list !== false) {
			foreach($menu_list as $n) {
				$menus[$n['menu_id']] = $n['menu_name'];
			}
		}

		return $menus;
	}
}
