# SodiumPlus Methods

This describes the methods in the public API for Sodium-Plus.
If you're not sure which method to use, please refer to the
[Libsodium Quick Reference](https://paragonie.com/blog/2017/06/libsodium-quick-reference-quick-comparison-similar-functions-and-which-one-use)
for guidance.

* [AEAD (XChaCha20-Poly1305)](AEAD.md#aead)
  * [crypto_aead_xchacha20poly1305_ietf_decrypt](AEAD.md#crypto_aead_xchacha20poly1305_ietf_decrypt)
  * [crypto_aead_xchacha20poly1305_ietf_encrypt](AEAD.md#crypto_aead_xchacha20poly1305_ietf_encrypt)
  * [crypto_aead_xchacha20poly1305_ietf_keygen](AEAD.md#crypto_aead_xchacha20poly1305_ietf_keygen)
  * [Example for crypto_aead_xchacha20poly1305_ietf_*](AEAD.md#example-for-crypto_aead_xchacha20poly1305_ietf_)
* [Shared-key authentication](shared-key-authentication.md)
  * [crypto_auth](shared-key-authentication.md#crypto_auth)
  * [crypto_auth_verify](shared-key-authentication.md#crypto_auth_verify)
  * [crypto_auth_keygen](shared-key-authentication.md#crypto_auth_keygen)
  * [Example for crypto_auth](shared-key-authentication.md#example-for-crypto_auth)
* [Authenticated public-key encryption](authenticated-public-key-encryption.md)
  * [crypto_box](authenticated-public-key-encryption.md#crypto_box)
  * [crypto_box_open](authenticated-public-key-encryption.md#crypto_box_open)
  * [crypto_box_keypair](authenticated-public-key-encryption.md#crypto_box_keypair)
  * [crypto_box_keypair_from_secretkey_and_secretkey](authenticated-public-key-encryption.md#crypto_box_keypair_from_secretkey_and_secretkey)
  * [crypto_box_publickey](authenticated-public-key-encryption.md#crypto_box_publickey)
  * [crypto_box_secretkey](authenticated-public-key-encryption.md#crypto_box_secretkey)
  * [crypto_box_publickey_from_secretkey](authenticated-public-key-encryption.md#crypto_box_publickey_from_secretkey)
  * [Example for crypto_box](authenticated-public-key-encryption.md#example-for-crypto_box)
* [Sealed boxes (anonymous public-key encryption)](sealed-boxes.md)
  * [crypto_box_seal](sealed-boxes.md#crypto_box_seal)
  * [crypto_box_seal_open](sealed-boxes.md#crypto_box_seal_open)
  * [Example for crypto_box_seal](sealed-boxes.md#example-for-crypto_box_seal)
* [General-purpose cryptographic hash](general-purpose-cryptographic-hash.md)
  * [crypto_generichash](general-purpose-cryptographic-hash.md#crypto_generichash)
  * [crypto_generichash_init](general-purpose-cryptographic-hash.md#crypto_generichash_init)
  * [crypto_generichash_update](general-purpose-cryptographic-hash.md#crypto_generichash_update)
  * [crypto_generichash_final](general-purpose-cryptographic-hash.md#crypto_generichash_final)
  * [crypto_generichash_keygen](general-purpose-cryptographic-hash.md#crypto_generichash_keygen)
  * [Example for crypto_generichash](general-purpose-cryptographic-hash.md#example-for-crypto_generichash)
* [Key derivation](key-derivation.md)
  * [crypto_kdf_derive_from_key](key-derivation.md#crypto_kdf_derive_from_key)
  * [crypto_kdf_keygen](key-derivation.md#crypto_kdf_keygen)
  * [Example for crypto_kdf](key-derivation.md#example-for-crypto_kdf)
* [Key exchange](key-exchange.md)
  * [crypto_kx_keypair](key-exchange.md#crypto_kx_keypair)
  * [crypto_kx_seed_keypair](key-exchange.md#crypto_kx_seed_keypair)
  * [crypto_kx_client_session_keys](key-exchange.md#crypto_kx_client_session_keys)
  * [crypto_kx_server_session_keys](key-exchange.md#crypto_kx_server_session_keys)
  * [Example for crypto_kx](key-exchange.md#example-for-crypto_kx)
* [One-time authentication](one-time-authentication.md)
  * [crypto_onetimeauth](one-time-authentication.md#crypto_onetimeauth)
  * [crypto_onetimeauth_verify](one-time-authentication.md#crypto_onetimeauth_verify)
  * [crypto_onetimeauth_keygen](one-time-authentication.md#crypto_onetimeauth_keygen)
  * [Example for crypto_onetimeauth](one-time-authentication.md#example-for-crypto_onetimeauth)
* [Password-based key derivation](password-based-key-derivation.md)
  * [crypto_pwhash](password-based-key-derivation.md#crypto_pwhash)
  * [Example for crypto_pwhash](password-based-key-derivation.md#example-for-crypto_pwhash)
* [Password hashing and storage](password-hashing-and-storage.md)
  * [crypto_pwhash_str](password-hashing-and-storage.md#crypto_pwhash_str)
  * [crypto_pwhash_str_needs_rehash](password-hashing-and-storage.md#crypto_pwhash_str_needs_rehash)
  * [crypto_pwhash_str_verify](password-hashing-and-storage.md#crypto_pwhash_str_verify)
  * [Example for crypto_pwhash_str](password-hashing-and-storage.md#example-for-crypto_pwhash_str)
* [Scalar multiplication over Curve25519 (advanced)](scalar-multiplication.md)
  * [crypto_scalarmult](scalar-multiplication.md#crypto_scalarmult)
  * [crypto_scalarmult_base](scalar-multiplication.md#crypto_scalarmult_base)
  * [Example for crypto_scalarmult](scalar-multiplication.md#example-for-crypto_scalarmult)
* [Shared-key authenticated encryption](shared-key-authenticated-encryption.md)
  * [crypto_secretbox](shared-key-authenticated-encryption.md#crypto_secretbox)
  * [crypto_secretbox_open](shared-key-authenticated-encryption.md#crypto_secretbox_open)
  * [crypto_secretbox_keygen](shared-key-authenticated-encryption.md#crypto_secretbox_keygen)
  * [Example for crypto_secretbox](shared-key-authenticated-encryption.md#example-for-crypto_secretbox)
* [Encrypted streams](encrypted-streams.md)
  * [crypto_secretstream_xchacha20poly1305_init_push](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_init_push)
  * [crypto_secretstream_xchacha20poly1305_init_pull](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_init_pull)
  * [crypto_secretstream_xchacha20poly1305_push](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_push)
  * [crypto_secretstream_xchacha20poly1305_pull](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_pull)
  * [crypto_secretstream_xchacha20poly1305_keygen](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_keygen)
  * [crypto_secretstream_xchacha20poly1305_rekey](encrypted-streams.md#crypto_secretstream_xchacha20poly1305_rekey)
  * [Example for crypto_secretstream_xchacha20poly1305](encrypted-streams.md#example-for-crypto_secretstream_xchacha20poly1305)
* [Short-input hashing](short-input-hashing.md)
  * [crypto_shorthash](short-input-hashing.md#crypto_shorthash)
  * [crypto_shorthash_keygen](short-input-hashing.md#crypto_shorthash_keygen)
  * [Example for crypto_shorthash](short-input-hashing.md#example-for-crypto_shorthash)
* [Digital signatures](digital-signatures.md)
  * [crypto_sign](digital-signatures.md#crypto_sign)
  * [crypto_sign_open](digital-signatures.md#crypto_sign_open)
  * [crypto_sign_detached](digital-signatures.md#crypto_sign_detached)
  * [crypto_sign_verify_detached](digital-signatures.md#crypto_sign_verify_detached)
  * [crypto_sign_keypair](digital-signatures.md#crypto_sign_keypair)
  * [crypto_sign_publickey](digital-signatures.md#crypto_sign_publickey)
  * [crypto_sign_secretkey](digital-signatures.md#crypto_sign_secretkey)
  * [crypto_sign_ed25519_sk_to_curve25519](digital-signatures.md#crypto_sign_ed25519_sk_to_curve25519)
  * [crypto_sign_ed25519_pk_to_curve25519](digital-signatures.md#crypto_sign_ed25519_pk_to_curve25519)
  * [Example for crypto_sign](digital-signatures.md#example-for-crypto_sign)
* [Randomness](randomness.md)
  * [randombytes_buf](randomness.md#randombytes_buf)
  * [randombytes_uniform](randomness.md#randombytes_uniform)
  * [Example for randombytes](randomness.md#example-for-randombytes)
* [Utilities](utilities.md)
  * [sodium_bin2hex](utilities.md#sodium_bin2hex)
  * [sodium_hex2bin](utilities.md#sodium_bin2hex)
