SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `humhub1175`
--
-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

CREATE TABLE `activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `object_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `activity`
--

INSERT INTO `activity` VALUES
(1, 'humhub\\modules\\space\\activities\\Created', 'space', 'humhub\\modules\\space\\models\\Space', 1),
(2, 'humhub\\modules\\content\\activities\\ContentCreated', 'content', 'humhub\\modules\\post\\models\\Post', 1),
(3, 'humhub\\modules\\space\\activities\\MemberAdded', 'space', 'humhub\\modules\\space\\models\\Space', 1),
(4, 'humhub\\modules\\space\\activities\\MemberAdded', 'space', 'humhub\\modules\\space\\models\\Space', 1),
(5, 'humhub\\modules\\content\\activities\\ContentCreated', 'content', 'humhub\\modules\\post\\models\\Post', 2),
(6, 'humhub\\modules\\comment\\activities\\NewComment', 'comment', 'humhub\\modules\\comment\\models\\Comment', 1),
(7, 'humhub\\modules\\comment\\activities\\NewComment', 'comment', 'humhub\\modules\\comment\\models\\Comment', 2),
(8, 'humhub\\modules\\like\\activities\\Liked', 'like', 'humhub\\modules\\like\\models\\Like', 1),
(9, 'humhub\\modules\\like\\activities\\Liked', 'like', 'humhub\\modules\\like\\models\\Like', 2);

-- --------------------------------------------------------

--
-- Table structure for table `comment`
--

CREATE TABLE `comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_comment-created_by` (`created_by`),
  KEY `idx_comment_target` (`object_id`,`object_model`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `comment`
--

INSERT INTO `comment` VALUES
(1, 'Nike – Just buy it. :wink:', 'humhub\\modules\\post\\models\\Post', 2, '[[regtime]]', 2, '[[regtime]]', 2),
(2, 'Calvin Klein – Between love and madness lies obsession.', 'humhub\\modules\\post\\models\\Post', 2, '[[regtime]]', 3, '[[regtime]]', 3);

-- --------------------------------------------------------

--
-- Table structure for table `content`
--

CREATE TABLE `content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `contentcontainer_id` int(11) DEFAULT NULL,
  `stream_channel` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT 'default',
  `stream_sort_date` datetime DEFAULT NULL,
  `visibility` tinyint(3) NOT NULL DEFAULT '0',
  `state` tinyint(3) NOT NULL DEFAULT '1',
  `was_published` tinyint(1) NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `locked_comments` tinyint(1) NOT NULL DEFAULT '0',
  `scheduled_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_object_model` (`object_model`,`object_id`),
  UNIQUE KEY `index_guid` (`guid`),
  KEY `fk-contentcontainer` (`contentcontainer_id`),
  KEY `fk-create-user` (`created_by`),
  KEY `fk-update-user` (`updated_by`),
  KEY `stream_channe` (`stream_channel`),
  KEY `idx_stream_created` (`created_at`),
  KEY `idx_stream_updated` (`stream_sort_date`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=12 ;

--
-- Dumping data for table `content`
--

INSERT INTO `content` VALUES
(1, '6ab2d85d-d1aa-4b84-ad79-a1ea9a5fb1c4', 'humhub\\modules\\activity\\models\\Activity', 1, 2, 'activity', '[[regtime]]', 1, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(2, 'c2cd8b16-12da-40f5-a809-eb7150cb9849', 'humhub\\modules\\post\\models\\Post', 1, 2, 'default', '[[regtime]]', 1, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(3, '5f44860c-66aa-45f8-948d-09094fee547c', 'humhub\\modules\\activity\\models\\Activity', 2, 2, 'activity', '[[regtime]]', 1, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(4, '992fb8b2-b1a4-4255-8b6c-7784411d9dec', 'humhub\\modules\\activity\\models\\Activity', 3, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 2, '[[regtime]]', 1),
(5, 'c12197c6-829e-4075-9a59-b6a4f5b24ca6', 'humhub\\modules\\activity\\models\\Activity', 4, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 3, '[[regtime]]', 1),
(6, '33a164f9-ddca-464a-b46c-af831c9fb285', 'humhub\\modules\\post\\models\\Post', 2, 2, 'default', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(7, '6922ebef-59b5-4c94-99d0-d07c51909889', 'humhub\\modules\\activity\\models\\Activity', 5, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(8, '86701a96-41c8-4cac-a42c-c32204fb4ac9', 'humhub\\modules\\activity\\models\\Activity', 6, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 2, '[[regtime]]', 2),
(9, '4c848fd2-b8c0-40b0-bf28-deb01827d107', 'humhub\\modules\\activity\\models\\Activity', 7, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 3, '[[regtime]]', 3),
(10, 'bb0054e8-8146-4a20-872c-cebfd286fb0e', 'humhub\\modules\\activity\\models\\Activity', 8, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 3, '[[regtime]]', 3),
(11, '70c683c0-b723-40f3-8ca7-8bacd490b646', 'humhub\\modules\\activity\\models\\Activity', 9, 2, 'activity', '[[regtime]]', 0, 1, 0, 0, 0, 0, 0, NULL, '[[regtime]]', 3, '[[regtime]]', 3);

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer`
--

CREATE TABLE `contentcontainer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` char(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pk` int(11) DEFAULT NULL,
  `owner_user_id` int(11) DEFAULT NULL,
  `tags_cached` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_guid` (`guid`),
  UNIQUE KEY `unique_target` (`class`,`pk`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `contentcontainer`
--

INSERT INTO `contentcontainer` VALUES
(1, 'e0a06746-ac69-4eef-8bc8-0a71cfa872f1', 'humhub\\modules\\user\\models\\User', 1, 1, 'Administration, Support, HumHub'),
(2, '9796124c-3f1a-4bf0-ab17-e54c40946140', 'humhub\\modules\\space\\models\\Space', 1, 1, NULL),
(3, '6b78f1f5-d133-4803-9ee2-bf8257d20eea', 'humhub\\modules\\user\\models\\User', 2, 2, 'Microsoft Office, Marketing, SEM, Digital Native'),
(4, '576bf5a1-210d-42d6-8585-eef4aa364974', 'humhub\\modules\\user\\models\\User', 3, 3, 'Yoga, Travel, English, German, French');

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_blocked_users`
--

CREATE TABLE `contentcontainer_blocked_users` (
  `contentcontainer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`contentcontainer_id`,`user_id`),
  KEY `fk-contentcontainer-blocked-users-rel-user-id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_default_permission`
--

CREATE TABLE `contentcontainer_default_permission` (
  `permission_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentcontainer_class` char(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`permission_id`,`group_id`,`module_id`,`contentcontainer_class`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_module`
--

CREATE TABLE `contentcontainer_module` (
  `contentcontainer_id` int(11) NOT NULL,
  `module_id` char(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_state` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`contentcontainer_id`,`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_permission`
--

CREATE TABLE `contentcontainer_permission` (
  `permission_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentcontainer_id` int(11) NOT NULL,
  `group_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`permission_id`,`group_id`,`module_id`,`contentcontainer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_setting`
--

CREATE TABLE `contentcontainer_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentcontainer_id` int(11) NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings-unique` (`module_id`,`contentcontainer_id`,`name`),
  KEY `fk-contentcontainerx` (`contentcontainer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_tag`
--

CREATE TABLE `contentcontainer_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentcontainer_class` char(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique-contentcontainer-tag` (`contentcontainer_class`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `contentcontainer_tag`
--

INSERT INTO `contentcontainer_tag` VALUES
(1, 'Administration', 'humhub\\modules\\user\\models\\User'),
(7, 'Digital Native', 'humhub\\modules\\user\\models\\User'),
(10, 'English', 'humhub\\modules\\user\\models\\User'),
(12, 'French', 'humhub\\modules\\user\\models\\User'),
(11, 'German', 'humhub\\modules\\user\\models\\User'),
(3, 'HumHub', 'humhub\\modules\\user\\models\\User'),
(5, 'Marketing', 'humhub\\modules\\user\\models\\User'),
(4, 'Microsoft Office', 'humhub\\modules\\user\\models\\User'),
(6, 'SEM', 'humhub\\modules\\user\\models\\User'),
(2, 'Support', 'humhub\\modules\\user\\models\\User'),
(9, 'Travel', 'humhub\\modules\\user\\models\\User'),
(8, 'Yoga', 'humhub\\modules\\user\\models\\User');

-- --------------------------------------------------------

--
-- Table structure for table `contentcontainer_tag_relation`
--

CREATE TABLE `contentcontainer_tag_relation` (
  `contentcontainer_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`contentcontainer_id`,`tag_id`),
  KEY `fk-contentcontainer-tag-rel-tag-id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `contentcontainer_tag_relation`
--

INSERT INTO `contentcontainer_tag_relation` VALUES
(1, 1),
(1, 2),
(1, 3),
(3, 4),
(3, 5),
(3, 6),
(3, 7),
(4, 8),
(4, 9),
(4, 10),
(4, 11),
(4, 12);

-- --------------------------------------------------------

--
-- Table structure for table `content_fulltext`
--

CREATE TABLE `content_fulltext` (
  `content_id` int(11) DEFAULT NULL,
  `contents` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `files` text COLLATE utf8mb4_unicode_ci,
  KEY `fk_content_fulltext` (`content_id`),
  FULLTEXT KEY `ftx` (`contents`,`comments`,`files`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `content_fulltext`
--

INSERT INTO `content_fulltext` VALUES
(6, '6 \nWe''re looking for great slogans of famous brands. Maybe you can come up with some samples? \n', '\n\nNike – Just buy it. :wink:\n\n\n\nCalvin Klein – Between love and madness lies obsession.\n\n \n', ' \n');

-- --------------------------------------------------------

--
-- Table structure for table `content_tag`
--

CREATE TABLE `content_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentcontainer_id` int(11) DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `color` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx-content-tag` (`module_id`,`contentcontainer_id`,`name`),
  KEY `fk-content-tag-container-id` (`contentcontainer_id`),
  KEY `fk-content-tag-parent-id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content_tag_relation`
--

CREATE TABLE `content_tag_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk-content-tag-rel-content-id` (`content_id`),
  KEY `fk-content-tag-rel-tag-id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `file`
--

CREATE TABLE `file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '1',
  `category` int(11) unsigned NOT NULL DEFAULT '0',
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `object_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `content_id` int(11) unsigned DEFAULT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mime_type` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `show_in_stream` tinyint(1) DEFAULT '1',
  `hash_sha1` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ux-file-guid` (`guid`),
  KEY `fk_file-created_by` (`created_by`),
  KEY `ix-file-object` (`object_model`,`object_id`,`sort_order`),
  KEY `ix-file-category` (`category`,`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `file_history`
--

CREATE TABLE `file_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `size` bigint(20) NOT NULL,
  `hash_sha1` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_file_history` (`file_id`),
  KEY `fk_file_history_user` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group`
--

CREATE TABLE `group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_dn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_admin_group` tinyint(1) NOT NULL DEFAULT '0',
  `is_default_group` tinyint(1) NOT NULL DEFAULT '0',
  `is_protected` tinyint(1) NOT NULL DEFAULT '0',
  `show_at_registration` tinyint(1) NOT NULL DEFAULT '1',
  `show_at_directory` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `notify_users` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `group`
--

INSERT INTO `group` VALUES
(1, 'Administrators', 'Default group for administrators of this HumHub Installation', '[[regtime]]', NULL, NULL, NULL, NULL, 1, 0, 0, 0, 0, 100, 0),
(2, 'Users', 'Default group for all newly registered users of the network', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 0, 1, 0, 1, 0, 100, 0);

-- --------------------------------------------------------

--
-- Table structure for table `group_permission`
--

CREATE TABLE `group_permission` (
  `permission_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_id` int(11) NOT NULL,
  `module_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`permission_id`,`group_id`,`module_id`),
  KEY `fk_group_permission-group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `group_space`
--

CREATE TABLE `group_space` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `space_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx-group_space` (`space_id`,`group_id`),
  KEY `fk-group_space-group` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_user`
--

CREATE TABLE `group_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `is_group_manager` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx-group_user` (`user_id`,`group_id`),
  KEY `fk-group-group` (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `group_user`
--

INSERT INTO `group_user` VALUES
(1, 1, 2, 0, '[[regtime]]', NULL, '[[regtime]]', NULL),
(2, 1, 1, 0, '[[regtime]]', NULL, '[[regtime]]', NULL),
(3, 2, 2, 0, '[[regtime]]', 1, '[[regtime]]', 1),
(4, 3, 2, 0, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `like`
--

CREATE TABLE `like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `target_user_id` int(11) DEFAULT NULL,
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique-object-user` (`object_model`,`object_id`,`created_by`),
  KEY `index_object` (`object_model`,`object_id`),
  KEY `fk_like-created_by` (`created_by`),
  KEY `fk_like-target_user_id` (`target_user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `like`
--

INSERT INTO `like` VALUES
(1, NULL, 'humhub\\modules\\comment\\models\\Comment', 1, '[[regtime]]', 3, '[[regtime]]', 3),
(2, NULL, 'humhub\\modules\\post\\models\\Post', 2, '[[regtime]]', 3, '[[regtime]]', 3);

-- --------------------------------------------------------

--
-- Table structure for table `live`
--

CREATE TABLE `live` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentcontainer_id` int(11) DEFAULT NULL,
  `visibility` int(1) DEFAULT NULL,
  `serialized_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contentcontainer` (`contentcontainer_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `live`
--

INSERT INTO `live` VALUES
(1, 2, 1, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:1;s:9:"contentId";i:1;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"e0a06746-ac69-4eef-8bc8-0a71cfa872f1";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:1;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(2, 2, 1, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:1;s:9:"contentId";i:3;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"e0a06746-ac69-4eef-8bc8-0a71cfa872f1";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:2;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(3, 2, 1, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:1;s:9:"contentId";i:2;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"e0a06746-ac69-4eef-8bc8-0a71cfa872f1";s:11:"sourceClass";s:31:"humhub\\modules\\post\\models\\Post";s:8:"sourceId";i:1;s:6:"silent";b:0;s:13:"streamChannel";s:7:"default";s:6:"insert";b:1;}', [[timestamp]]),
(4, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:4;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"6b78f1f5-d133-4803-9ee2-bf8257d20eea";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:3;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(5, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:5;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"576bf5a1-210d-42d6-8585-eef4aa364974";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:4;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(6, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:7;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"e0a06746-ac69-4eef-8bc8-0a71cfa872f1";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:5;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(7, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:6;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"e0a06746-ac69-4eef-8bc8-0a71cfa872f1";s:11:"sourceClass";s:31:"humhub\\modules\\post\\models\\Post";s:8:"sourceId";i:2;s:6:"silent";b:0;s:13:"streamChannel";s:7:"default";s:6:"insert";b:1;}', [[timestamp]]),
(8, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:8;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"6b78f1f5-d133-4803-9ee2-bf8257d20eea";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:6;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(9, 1, 0, 'O:38:"humhub\\modules\\comment\\live\\NewComment":4:{s:18:"contentContainerId";i:1;s:10:"visibility";i:0;s:9:"commentId";i:1;s:9:"contentId";i:6;}', [[timestamp]]),
(10, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:9;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"576bf5a1-210d-42d6-8585-eef4aa364974";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:7;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(11, 1, 0, 'O:38:"humhub\\modules\\comment\\live\\NewComment":4:{s:18:"contentContainerId";i:1;s:10:"visibility";i:0;s:9:"commentId";i:2;s:9:"contentId";i:6;}', [[timestamp]]),
(12, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:10;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"576bf5a1-210d-42d6-8585-eef4aa364974";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:8;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(13, 2, 0, 'O:38:"humhub\\modules\\content\\live\\NewContent":11:{s:18:"contentContainerId";i:2;s:10:"visibility";i:0;s:9:"contentId";i:11;s:5:"sguid";s:36:"9796124c-3f1a-4bf0-ab17-e54c40946140";s:5:"uguid";N;s:10:"originator";s:36:"576bf5a1-210d-42d6-8585-eef4aa364974";s:11:"sourceClass";s:39:"humhub\\modules\\activity\\models\\Activity";s:8:"sourceId";i:9;s:6:"silent";b:1;s:13:"streamChannel";s:8:"activity";s:6:"insert";b:1;}', [[timestamp]]),
(14, 1, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:1;s:10:"visibility";i:2;s:14:"notificationId";i:1;s:17:"notificationGroup";s:81:"humhub\\modules\\comment\\notifications\\NewComment:humhub\\modules\\post\\models\\Post-2";s:4:"text";s:94:"David Roberts commented post "We''re looking for great slogans of famous brands. Maybe you...".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]),
(15, 4, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:4;s:10:"visibility";i:2;s:14:"notificationId";i:2;s:17:"notificationGroup";s:81:"humhub\\modules\\comment\\notifications\\NewComment:humhub\\modules\\post\\models\\Post-2";s:4:"text";s:94:"David Roberts commented post "We''re looking for great slogans of famous brands. Maybe you...".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]),
(16, 1, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:1;s:10:"visibility";i:2;s:14:"notificationId";i:3;s:17:"notificationGroup";s:81:"humhub\\modules\\comment\\notifications\\NewComment:humhub\\modules\\post\\models\\Post-2";s:4:"text";s:94:"Sara Schuster commented post "We''re looking for great slogans of famous brands. Maybe you...".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]),
(17, 3, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:3;s:10:"visibility";i:2;s:14:"notificationId";i:4;s:17:"notificationGroup";s:81:"humhub\\modules\\comment\\notifications\\NewComment:humhub\\modules\\post\\models\\Post-2";s:4:"text";s:94:"Sara Schuster commented post "We''re looking for great slogans of famous brands. Maybe you...".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]),
(18, 3, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:3;s:10:"visibility";i:2;s:14:"notificationId";i:5;s:17:"notificationGroup";s:81:"humhub\\modules\\like\\notifications\\NewLike:humhub\\modules\\comment\\models\\Comment-1";s:4:"text";s:57:"Sara Schuster likes comment "Nike – Just buy it. ?".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]),
(19, 1, 2, 'O:48:"humhub\\modules\\notification\\live\\NewNotification":6:{s:18:"contentContainerId";i:1;s:10:"visibility";i:2;s:14:"notificationId";i:6;s:17:"notificationGroup";s:75:"humhub\\modules\\like\\notifications\\NewLike:humhub\\modules\\post\\models\\Post-2";s:4:"text";s:90:"Sara Schuster likes post "We''re looking for great slogans of famous brands. Maybe you...".";s:2:"ts";i:[[timestamp]];}', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `log`
--

CREATE TABLE `log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` int(11) DEFAULT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_time` double DEFAULT NULL,
  `prefix` mediumtext COLLATE utf8mb4_unicode_ci,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_log_level` (`level`),
  KEY `idx_log_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `logging`
--

CREATE TABLE `logging` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logtime` int(11) DEFAULT NULL,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `migration`
--

CREATE TABLE `migration` (
  `version` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apply_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migration`
--

INSERT INTO `migration` VALUES
('m000000_000000_base', [[timestamp]]),
('m131023_164513_initial', [[timestamp]]),
('m131023_165411_initial', [[timestamp]]),
('m131023_165625_initial', [[timestamp]]),
('m131023_165755_initial', [[timestamp]]),
('m131023_165835_initial', [[timestamp]]),
('m131023_170033_initial', [[timestamp]]),
('m131023_170135_initial', [[timestamp]]),
('m131023_170159_initial', [[timestamp]]),
('m131023_170253_initial', [[timestamp]]),
('m131023_170339_initial', [[timestamp]]),
('m131203_110444_oembed', [[timestamp]]),
('m131213_165552_user_optimize', [[timestamp]]),
('m140226_111945_ldap', [[timestamp]]),
('m140303_125031_password', [[timestamp]]),
('m140304_142711_memberautoadd', [[timestamp]]),
('m140321_000917_content', [[timestamp]]),
('m140324_170617_membership', [[timestamp]]),
('m140507_150421_create_settings_table', [[timestamp]]),
('m140507_171527_create_settings_table', [[timestamp]]),
('m140512_141414_i18n_profilefields', [[timestamp]]),
('m140513_180317_createlogging', [[timestamp]]),
('m140701_000611_profile_genderfield', [[timestamp]]),
('m140701_074404_protect_default_profilefields', [[timestamp]]),
('m140702_143912_notify_notification_unify', [[timestamp]]),
('m140703_104527_profile_birthdayfield', [[timestamp]]),
('m140704_080659_installationid', [[timestamp]]),
('m140705_065525_emailing_settings', [[timestamp]]),
('m140706_135210_lastlogin', [[timestamp]]),
('m140829_122906_delete', [[timestamp]]),
('m140830_145504_following', [[timestamp]]),
('m140901_080147_indizies', [[timestamp]]),
('m140901_080432_indices', [[timestamp]]),
('m140901_112246_addState', [[timestamp]]),
('m140901_153403_addState', [[timestamp]]),
('m140901_170329_group_create_space', [[timestamp]]),
('m140902_091234_session_key_length', [[timestamp]]),
('m140907_140822_zip_field_to_text', [[timestamp]]),
('m140930_205511_fix_default', [[timestamp]]),
('m140930_205859_fix_default', [[timestamp]]),
('m140930_210142_fix_default', [[timestamp]]),
('m140930_210635_fix_default', [[timestamp]]),
('m140930_212528_fix_default', [[timestamp]]),
('m141015_173305_follow_notifications', [[timestamp]]),
('m141019_093319_mentioning', [[timestamp]]),
('m141020_162639_fix_default', [[timestamp]]),
('m141020_193920_rm_alsocreated', [[timestamp]]),
('m141020_193931_rm_alsoliked', [[timestamp]]),
('m141021_162639_oembed_setting', [[timestamp]]),
('m141022_094635_addDefaults', [[timestamp]]),
('m141106_185632_log_init', [[timestamp]]),
('m150204_103433_html5_notified', [[timestamp]]),
('m150210_190006_user_invite_lang', [[timestamp]]),
('m150302_114347_add_visibility', [[timestamp]]),
('m150322_194403_remove_type_field', [[timestamp]]),
('m150322_195619_allowedExt2Text', [[timestamp]]),
('m150429_223856_optimize', [[timestamp]]),
('m150629_220311_change', [[timestamp]]),
('m150703_012735_typelength', [[timestamp]]),
('m150703_024635_activityTypes', [[timestamp]]),
('m150703_033650_namespace', [[timestamp]]),
('m150703_130157_migrate', [[timestamp]]),
('m150704_005338_namespace', [[timestamp]]),
('m150704_005418_namespace', [[timestamp]]),
('m150704_005434_namespace', [[timestamp]]),
('m150704_005452_namespace', [[timestamp]]),
('m150704_005504_namespace', [[timestamp]]),
('m150713_054441_timezone', [[timestamp]]),
('m150714_093525_activity', [[timestamp]]),
('m150714_100355_cleanup', [[timestamp]]),
('m150831_061628_notifications', [[timestamp]]),
('m150910_223305_fix_user_follow', [[timestamp]]),
('m150924_133344_update_notification_fix', [[timestamp]]),
('m150924_154635_user_invite_add_first_lastname', [[timestamp]]),
('m150927_190830_create_contentcontainer', [[timestamp]]),
('m150928_103711_permissions', [[timestamp]]),
('m150928_134934_groups', [[timestamp]]),
('m150928_140718_setColorVariables', [[timestamp]]),
('m151010_124437_group_permissions', [[timestamp]]),
('m151010_175000_default_visibility', [[timestamp]]),
('m151013_223814_include_dashboard', [[timestamp]]),
('m151022_131128_module_fix', [[timestamp]]),
('m151106_090948_addColor', [[timestamp]]),
('m151223_171310_fix_notifications', [[timestamp]]),
('m151226_164234_authclient', [[timestamp]]),
('m160125_053702_stored_filename', [[timestamp]]),
('m160205_203840_foreign_keys', [[timestamp]]),
('m160205_203913_foreign_keys', [[timestamp]]),
('m160205_203939_foreign_keys', [[timestamp]]),
('m160205_203955_foreign_keys', [[timestamp]]),
('m160205_204000_foreign_keys', [[timestamp]]),
('m160205_204010_foreign_keys', [[timestamp]]),
('m160205_205540_foreign_keys', [[timestamp]]),
('m160216_160119_initial', [[timestamp]]),
('m160217_161220_addCanLeaveFlag', [[timestamp]]),
('m160220_013525_contentcontainer_id', [[timestamp]]),
('m160221_222312_public_permission_change', [[timestamp]]),
('m160225_180229_remove_website', [[timestamp]]),
('m160227_073020_birthday_date', [[timestamp]]),
('m160229_162959_multiusergroups', [[timestamp]]),
('m160309_141222_longerUserName', [[timestamp]]),
('m160408_100725_rename_groupadmin_to_manager', [[timestamp]]),
('m160415_180332_wall_remove', [[timestamp]]),
('m160501_220850_activity_pk_int', [[timestamp]]),
('m160507_202611_settings', [[timestamp]]),
('m160508_005740_settings_cleanup', [[timestamp]]),
('m160509_214811_spaceurl', [[timestamp]]),
('m160517_132535_group', [[timestamp]]),
('m160523_105732_profile_searchable', [[timestamp]]),
('m160714_142827_remove_space_id', [[timestamp]]),
('m161031_161947_file_directories', [[timestamp]]),
('m170110_151419_membership_notifications', [[timestamp]]),
('m170110_152425_space_follow_reset_send_notification', [[timestamp]]),
('m170111_190400_disable_web_notifications', [[timestamp]]),
('m170112_115052_settings', [[timestamp]]),
('m170118_162332_streamchannel', [[timestamp]]),
('m170119_160740_initial', [[timestamp]]),
('m170123_125622_pinned', [[timestamp]]),
('m170211_105743_show_in_stream', [[timestamp]]),
('m170224_100937_fix_default_modules', [[timestamp]]),
('m170723_133337_content_tag', [[timestamp]]),
('m170723_133338_content_tag_sort_order', [[timestamp]]),
('m170805_211208_authclient_id', [[timestamp]]),
('m170810_220543_group_sort', [[timestamp]]),
('m171015_155102_contentcontainer_module', [[timestamp]]),
('m171025_142030_queue_update', [[timestamp]]),
('m171025_200312_utf8mb4_fixes', [[timestamp]]),
('m171027_220519_exclusive_jobs', [[timestamp]]),
('m180305_084435_membership_pk', [[timestamp]]),
('m180315_112748_fix_email_length', [[timestamp]]),
('m181029_160453_collation', [[timestamp]]),
('m190211_133045_channel_length', [[timestamp]]),
('m190309_201944_rename_settings', [[timestamp]]),
('m190920_142605_fix_language_codes', [[timestamp]]),
('m200217_122108_profile_translation_fix', [[timestamp]]),
('m200218_122109_profile_translation_fix2', [[timestamp]]),
('m200323_162006_fix_visibility', [[timestamp]]),
('m200604_204445_remove_post_field', [[timestamp]]),
('m200715_171721_defaultOption', [[timestamp]]),
('m200715_184207_commentIndex', [[timestamp]]),
('m200729_080349_commentIndex_fix_order', [[timestamp]]),
('m200930_151639_add_about', [[timestamp]]),
('m201020_130431_fix_default_file_setting_value', [[timestamp]]),
('m201025_095247_spaces_of_users_group', [[timestamp]]),
('m201115_083832_add_notify_users_to_group', [[timestamp]]),
('m201130_073907_default_permissions', [[timestamp]]),
('m201130_073908_disable_legacy_richtextparser', [[timestamp]]),
('m201217_081828_fix_oembed_setting', [[timestamp]]),
('m201228_064513_default_group', [[timestamp]]),
('m210111_105355_hash', [[timestamp]]),
('m210203_122333_profilePermissions', [[timestamp]]),
('m210204_054203_fix_settings_unique_index', [[timestamp]]),
('m210211_051243_container_tag', [[timestamp]]),
('m210217_055359_protected_group', [[timestamp]]),
('m210310_103412_fix_hash', [[timestamp]]),
('m210331_115144_default_timezone', [[timestamp]]),
('m210506_060737_profile_field_directory_filter', [[timestamp]]),
('m210721_055137_content_locked_comments', [[timestamp]]),
('m210727_102150_follow_friend', [[timestamp]]),
('m210924_114847_container_blocked_users', [[timestamp]]),
('m210928_162609_stream_sort_idx', [[timestamp]]),
('m211022_152413_file_history', [[timestamp]]),
('m211124_180441_admin_group_label', [[timestamp]]),
('m220121_193617_oembed_setting_update', [[timestamp]]),
('m220207_183901_add_payload_column_to_notification_table', [[timestamp]]),
('m220302_135158_add_content_id', [[timestamp]]),
('m220606_205507_mailer_settings', [[timestamp]]),
('m220608_125539_displaysubformat', [[timestamp]]),
('m220919_104234_auth_key', [[timestamp]]),
('m221111_100450_rename_profile_url', [[timestamp]]),
('m221117_214310_rename_setting', [[timestamp]]),
('m230127_195245_content_state', [[timestamp]]),
('m230130_140944_rename_auth_invite_setting', [[timestamp]]),
('m230217_112400_content_scheduled_at', [[timestamp]]),
('m230217_175411_content_hidden', [[timestamp]]),
('m230419_102455_add_sort_order_column_to_space_table', [[timestamp]]),
('m230618_135508_file_add_sorting_column', [[timestamp]]),
('m230618_135509_file_add_category_column', [[timestamp]]),
('m230618_135510_file_add_metadata_column', [[timestamp]]),
('m230618_135511_file_add_state_column', [[timestamp]]),
('m230618_135512_file_add_guid_unique_index', [[timestamp]]),
('m231024_062218_content_was_published', [[timestamp]]),
('m240203_112155_search', [[timestamp]]),
('m240419_095931_fix_user_profile_country_code', [[timestamp]]),
('m240422_162959_new_is_untouched_settings', [[timestamp]]),
('m240423_170311_profile_checkbox_list_field', [[timestamp]]),
('m240425_144905_unique_index', [[timestamp]]),
('m240523_081438_fix_null_password', [[timestamp]]),
('m240622_082606_fix_captcha_in_registration', [[timestamp]]),
('m240715_150726_fulltext_index', [[timestamp]]),
('m240807_230603_add_permissions_to_existing_user_groups', [[timestamp]]),
('m240916_150536_extend_language', [[timestamp]]),
('m241004_093044_server_timezone', [[timestamp]]),
('m241022_084028_delete_desktop_notified', [[timestamp]]),
('m250715_070647_group_name_length', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `module_enabled`
--

CREATE TABLE `module_enabled` (
  `module_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notification`
--

CREATE TABLE `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `seen` tinyint(4) DEFAULT NULL,
  `source_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_pk` int(11) DEFAULT NULL,
  `space_id` int(11) DEFAULT NULL,
  `emailed` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `originator_user_id` int(11) DEFAULT NULL,
  `module` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `group_key` varchar(75) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_web_notifications` tinyint(1) DEFAULT '1',
  `payload` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `index_user_id` (`user_id`),
  KEY `index_seen` (`seen`),
  KEY `index_desktop_emailed` (`emailed`),
  KEY `index_groupuser` (`user_id`,`class`,`group_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `notification`
--

INSERT INTO `notification` VALUES
(1, 'humhub\\modules\\comment\\notifications\\NewComment', 1, 0, 'humhub\\modules\\comment\\models\\Comment', 1, 1, 0, '[[regtime]]', 2, 'comment', 'humhub\\modules\\post\\models\\Post-2', 1, NULL),
(2, 'humhub\\modules\\comment\\notifications\\NewComment', 3, 0, 'humhub\\modules\\comment\\models\\Comment', 1, 1, 0, '[[regtime]]', 2, 'comment', 'humhub\\modules\\post\\models\\Post-2', 1, NULL),
(3, 'humhub\\modules\\comment\\notifications\\NewComment', 1, 0, 'humhub\\modules\\comment\\models\\Comment', 2, 1, 0, '[[regtime]]', 3, 'comment', 'humhub\\modules\\post\\models\\Post-2', 1, NULL),
(4, 'humhub\\modules\\comment\\notifications\\NewComment', 2, 0, 'humhub\\modules\\comment\\models\\Comment', 2, 1, 0, '[[regtime]]', 3, 'comment', 'humhub\\modules\\post\\models\\Post-2', 1, NULL),
(5, 'humhub\\modules\\like\\notifications\\NewLike', 2, 0, 'humhub\\modules\\like\\models\\Like', 1, 1, 0, '[[regtime]]', 3, 'like', 'humhub\\modules\\comment\\models\\Comment-1', 1, NULL),
(6, 'humhub\\modules\\like\\notifications\\NewLike', 1, 0, 'humhub\\modules\\like\\models\\Like', 2, 1, 0, '[[regtime]]', 3, 'like', 'humhub\\modules\\post\\models\\Post-2', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `post`
--

CREATE TABLE `post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `post`
--

INSERT INTO `post` VALUES
(1, 'Yay! I''ve just installed HumHub :sunglasses:', NULL, '[[regtime]]', 1, '[[regtime]]', 1),
(2, 'We''re looking for great slogans of famous brands. Maybe you can come up with some samples?', NULL, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `profile`
--

CREATE TABLE `profile` (
  `user_id` int(11) NOT NULL,
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `birthday_hide_year` int(1) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `about` text COLLATE utf8mb4_unicode_ci,
  `phone_private` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_work` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `im_xmpp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_facebook` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_linkedin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_instagram` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_xing` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_youtube` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_vimeo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_tiktok` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_twitter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_mastodon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `profile`
--

INSERT INTO `profile` VALUES
(1, '[[admin_fname]]', '[[admin_lname]]', 'System Administration', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'David', 'Roberts', 'Late riser', NULL, '2443 Queens Lane', '24574', 'Allwood', 'Virginia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'Sara', 'Schuster', 'Do-gooder', NULL, 'Schmarjestrasse 51', '17095', 'Friedland', 'Niedersachsen', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `profile_field`
--

CREATE TABLE `profile_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_field_category_id` int(11) NOT NULL,
  `module_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_type_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type_config` mediumtext COLLATE utf8mb4_unicode_ci,
  `internal_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `required` tinyint(4) DEFAULT NULL,
  `show_at_registration` tinyint(4) DEFAULT NULL,
  `editable` tinyint(4) NOT NULL DEFAULT '1',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_attribute` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `translation_category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_system` int(1) DEFAULT NULL,
  `searchable` tinyint(1) DEFAULT '1',
  `directory_filter` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `index_profile_field_category` (`profile_field_category_id`),
  KEY `index_directory_filter` (`directory_filter`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=28 ;

--
-- Dumping data for table `profile_field`
--

INSERT INTO `profile_field` VALUES
(1, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":20,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'firstname', 'First name', NULL, 100, 1, 1, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'givenName', NULL, 1, 1, 0),
(2, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":30,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'lastname', 'Last name', NULL, 200, 1, 1, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'sn', NULL, 1, 1, 0),
(3, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":50,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'title', 'Title', NULL, 300, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'title', NULL, 1, 1, 0),
(4, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Select', '{"type":"dropdownlist","options":"male=>Male\\nfemale=>Female\\ndiverse=>Diverse","canBeDirectoryFilter":true,"fieldTypes":[],"isVirtual":false}', 'gender', 'Gender', NULL, 300, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(5, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":150,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'street', 'Street', NULL, 400, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(6, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":10,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'zip', 'Zip', NULL, 500, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(7, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'city', 'City', NULL, 600, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(8, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\CountrySelect', '{"type":"dropdownlist","options":null,"canBeDirectoryFilter":true,"fieldTypes":[],"isVirtual":false}', 'country', 'Country', NULL, 700, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(9, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'state', 'State', NULL, 800, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(10, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Birthday', '{"type":"datetime","defaultHideAge":"0","fieldTypes":[],"isVirtual":false,"canBeDirectoryFilter":false}', 'birthday', 'Birthday', NULL, 900, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(11, 1, NULL, 'humhub\\modules\\user\\models\\fieldtype\\TextArea', '{"type":"textarea","fieldTypes":[],"isVirtual":false,"canBeDirectoryFilter":false}', 'about', 'About', NULL, 900, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(12, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'phone_private', 'Phone Private', NULL, 100, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(13, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'phone_work', 'Phone Work', NULL, 200, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(14, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'mobile', 'Mobile', NULL, 300, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(15, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\UserEmail', '{"type":"hidden","isVirtual":true,"fieldTypes":[],"canBeDirectoryFilter":false}', 'email_virtual', 'E-Mail', NULL, 350, 0, 0, 0, 0, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, NULL, 0, 0),
(16, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'fax', 'Fax', NULL, 400, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(17, 2, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"email","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'im_xmpp', 'XMPP Jabber Address', NULL, 800, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(18, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url', 'Website URL', NULL, 100, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(19, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_facebook', 'Facebook URL', NULL, 200, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(20, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_linkedin', 'LinkedIn URL', NULL, 300, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(21, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_instagram', 'Instagram URL', NULL, 350, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(22, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_xing', 'Xing URL', NULL, 400, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(23, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_youtube', 'Youtube URL', NULL, 500, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(24, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_vimeo', 'Vimeo URL', NULL, 600, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(25, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_tiktok', 'TikTok URL', NULL, 700, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(26, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_twitter', 'Twitter URL', NULL, 800, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0),
(27, 3, NULL, 'humhub\\modules\\user\\models\\fieldtype\\Text', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null,"canBeDirectoryFilter":true,"linkPrefix":null,"type":"text","fieldTypes":[],"isVirtual":false}', 'url_mastodon', 'Mastodon URL', NULL, 900, NULL, NULL, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `profile_field_category`
--

CREATE TABLE `profile_field_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `module_id` int(11) DEFAULT NULL,
  `visibility` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `translation_category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_system` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `profile_field_category`
--

INSERT INTO `profile_field_category` VALUES
(1, 'General', '', 100, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1),
(2, 'Communication', '', 200, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1),
(3, 'Social bookmarks', '', 300, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `queue`
--

CREATE TABLE `queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job` blob NOT NULL,
  `pushed_at` int(11) NOT NULL,
  `ttr` int(11) NOT NULL,
  `delay` int(11) NOT NULL,
  `priority` int(11) unsigned NOT NULL DEFAULT '1024',
  `reserved_at` int(11) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `done_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `channel` (`channel`),
  KEY `reserved_at` (`reserved_at`),
  KEY `priority` (`priority`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `queue`
--

INSERT INTO `queue` VALUES
(1, 'queue', 'O:46:"humhub\\modules\\content\\jobs\\SearchRebuildIndex":0:{}', [[timestamp]], 3600, 0, 1024, NULL, NULL, NULL),
(2, 'queue', 'O:53:"humhub\\modules\\notification\\jobs\\SendBulkNotification":2:{s:12:"notification";O:51:"humhub\\modules\\content\\notifications\\ContentCreated":3:{s:11:"sourceClass";s:31:"humhub\\modules\\post\\models\\Post";s:8:"sourcePk";i:1;s:13:"originator_id";i:1;}s:5:"query";O:46:"humhub\\modules\\user\\components\\ActiveQueryUser":34:{s:27:"\0yii\\base\\Component\0_events";a:0:{}s:35:"\0yii\\base\\Component\0_eventWildcards";a:0:{}s:30:"\0yii\\base\\Component\0_behaviors";a:0:{}s:6:"select";N;s:12:"selectOption";N;s:8:"distinct";b:0;s:4:"from";N;s:7:"groupBy";N;s:4:"join";a:1:{i:0;a:3:{i:0;s:9:"LEFT JOIN";i:1;s:16:"space_membership";i:2;s:32:"space_membership.user_id=user.id";}}s:6:"having";N;s:5:"union";a:1:{i:0;a:2:{s:5:"query";O:46:"humhub\\modules\\user\\components\\ActiveQueryUser":34:{s:27:"\0yii\\base\\Component\0_events";a:0:{}s:35:"\0yii\\base\\Component\0_eventWildcards";a:0:{}s:30:"\0yii\\base\\Component\0_behaviors";a:0:{}s:6:"select";N;s:12:"selectOption";N;s:8:"distinct";b:0;s:4:"from";N;s:7:"groupBy";N;s:4:"join";N;s:6:"having";N;s:5:"union";N;s:11:"withQueries";N;s:6:"params";a:0:{}s:18:"queryCacheDuration";N;s:20:"queryCacheDependency";N;s:5:"where";a:3:{i:0;s:3:"and";i:1;a:1:{s:11:"user.status";i:1;}i:2;a:2:{i:0;s:6:"exists";i:1;O:18:"yii\\db\\ActiveQuery":33:{s:27:"\0yii\\base\\Component\0_events";a:0:{}s:35:"\0yii\\base\\Component\0_eventWildcards";a:0:{}s:30:"\0yii\\base\\Component\0_behaviors";a:0:{}s:6:"select";N;s:12:"selectOption";N;s:8:"distinct";b:0;s:4:"from";N;s:7:"groupBy";N;s:4:"join";N;s:6:"having";N;s:5:"union";N;s:11:"withQueries";N;s:6:"params";a:0:{}s:18:"queryCacheDuration";N;s:20:"queryCacheDependency";N;s:5:"where";a:4:{i:0;s:3:"and";i:1;a:2:{s:24:"user_follow.object_model";s:33:"humhub\\modules\\space\\models\\Space";s:21:"user_follow.object_id";i:1;}i:2;s:27:"user_follow.user_id=user.id";i:3;a:1:{s:30:"user_follow.send_notifications";i:1;}}s:5:"limit";N;s:6:"offset";N;s:7:"orderBy";N;s:7:"indexBy";N;s:16:"emulateExecution";b:0;s:3:"sql";N;s:2:"on";N;s:8:"joinWith";N;s:10:"modelClass";s:33:"humhub\\modules\\user\\models\\Follow";s:4:"with";N;s:7:"asArray";N;s:8:"multiple";N;s:12:"primaryModel";N;s:4:"link";N;s:3:"via";N;s:9:"inverseOf";N;s:26:"\0yii\\db\\ActiveQuery\0viaMap";N;}}}s:5:"limit";N;s:6:"offset";N;s:7:"orderBy";N;s:7:"indexBy";N;s:16:"emulateExecution";b:0;s:3:"sql";N;s:2:"on";N;s:8:"joinWith";N;s:10:"modelClass";s:31:"humhub\\modules\\user\\models\\User";s:4:"with";N;s:7:"asArray";N;s:8:"multiple";N;s:12:"primaryModel";N;s:4:"link";N;s:3:"via";N;s:9:"inverseOf";N;s:26:"\0yii\\db\\ActiveQuery\0viaMap";N;s:31:"\0*\0multiCharacterSearchVariants";a:2:{i:0;a:3:{i:0;s:1:"''";i:1;s:3:"’";i:2;s:1:"`";}i:1;a:3:{i:0;s:1:""";i:1;s:3:"”";i:2;s:3:"“";}}}s:3:"all";b:0;}}s:11:"withQueries";N;s:6:"params";a:0:{}s:18:"queryCacheDuration";N;s:20:"queryCacheDependency";N;s:5:"where";a:5:{i:0;s:3:"and";i:1;a:1:{s:11:"user.status";i:1;}i:2;a:1:{s:23:"space_membership.status";i:3;}i:3;a:1:{s:35:"space_membership.send_notifications";i:1;}i:4;a:1:{s:8:"space_id";i:1;}}s:5:"limit";N;s:6:"offset";N;s:7:"orderBy";a:1:{s:16:"profile.lastname";i:4;}s:7:"indexBy";N;s:16:"emulateExecution";b:0;s:3:"sql";N;s:2:"on";N;s:8:"joinWith";a:1:{i:0;a:3:{i:0;a:1:{i:0;s:7:"profile";}i:1;b:1;i:2;s:9:"LEFT JOIN";}}s:10:"modelClass";s:31:"humhub\\modules\\user\\models\\User";s:4:"with";N;s:7:"asArray";N;s:8:"multiple";N;s:12:"primaryModel";N;s:4:"link";N;s:3:"via";N;s:9:"inverseOf";N;s:26:"\0yii\\db\\ActiveQuery\0viaMap";N;s:31:"\0*\0multiCharacterSearchVariants";a:2:{i:0;a:3:{i:0;s:1:"''";i:1;s:3:"’";i:2;s:1:"`";}i:1;a:3:{i:0;s:1:""";i:1;s:3:"”";i:2;s:3:"“";}}}}', [[timestamp]], 3600, 0, 1024, NULL, NULL, NULL),
(3, 'queue', 'O:48:"humhub\\modules\\content\\jobs\\SearchUpdateDocument":1:{s:9:"contentId";i:2;}', [[timestamp]], 3600, 0, 1024, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `queue_exclusive`
--

CREATE TABLE `queue_exclusive` (
  `id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_message_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job_status` smallint(6) DEFAULT '2',
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `queue_exclusive`
--

INSERT INTO `queue_exclusive` VALUES
('content-search.rebuild-index', '1', 2, '[[regtime]]'),
('content-search.update.2', '3', 2, '[[regtime]]'),
('content-search.update.6', '6', 2, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `setting`
--

CREATE TABLE `setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci,
  `module_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique-setting` (`name`,`module_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=71 ;

--
-- Dumping data for table `setting`
--

INSERT INTO `setting` VALUES
(1, 'oembedProviders', '{"Facebook Video":{"pattern":"/facebook\\\\.com\\\\/(.*)(video)/","endpoint":"https://graph.facebook.com/v12.0/oembed_video?url=%url%&access_token="},"Facebook Post":{"pattern":"/facebook\\\\.com\\\\/(.*)(post|activity|photo|permalink|media|question|note)/","endpoint":"https://graph.facebook.com/v12.0/oembed_post?url=%url%&access_token="},"Facebook Page":{"pattern":"/^(https\\\\:\\\\/\\\\/)*(www\\\\.)*facebook\\\\.com\\\\/((?!video|post|activity|photo|permalink|media|question|note).)*$/","endpoint":"https://graph.facebook.com/v12.0/oembed_post?url=%url%&access_token="},"Instagram":{"pattern":"/instagram\\\\.com/","endpoint":"https://graph.facebook.com/v12.0/instagram_oembed?url=%url%&access_token="},"Twitter":{"pattern":"/twitter\\\\.com/","endpoint":"https://publish.twitter.com/oembed?url=%url%&maxwidth=450"},"YouTube":{"pattern":"/youtube\\\\.com|youtu.be/","endpoint":"https://www.youtube.com/oembed?scheme=https&url=%url%&format=json&maxwidth=450"},"Soundcloud":{"pattern":"/soundcloud\\\\.com/","endpoint":"https://soundcloud.com/oembed?url=%url%&format=json&maxwidth=450"},"Vimeo":{"pattern":"/vimeo\\\\.com/","endpoint":"https://vimeo.com/api/oembed.json?scheme=https&url=%url%&format=json&maxwidth=450"},"SlideShare":{"pattern":"/slideshare\\\\.net/","endpoint":"https://www.slideshare.net/api/oembed/2?url=%url%&format=json&maxwidth=450"},"Reddit":{"pattern":"/reddit\\\\.com/","endpoint":"https://www.reddit.com/oembed?format=json&url=%url%"}}', 'base'),
(2, 'defaultVisibility', '1', 'space'),
(3, 'defaultJoinPolicy', '1', 'space'),
(4, 'includeCommunityModules', '1', 'marketplace'),
(5, 'richtextCompatMode', '0', 'content'),
(6, 'auth.showRegistrationUserGroup', '1', 'user'),
(7, 'displayNameSubFormat', 'title', 'base'),
(8, 'serverTimeZone', 'America/New_York', 'base'),
(9, 'themeParents', '[]', 'base'),
(10, 'theme.var.HumHub.default', '#e7e7e7', 'base'),
(11, 'theme.var.HumHub.primary', '#435f6f', 'base'),
(12, 'theme.var.HumHub.info', '#21A1B3', 'base'),
(13, 'theme.var.HumHub.success', '#97d271', 'base'),
(14, 'theme.var.HumHub.warning', '#FFC107', 'base'),
(15, 'theme.var.HumHub.danger', '#FC4A64', 'base'),
(16, 'theme.var.HumHub.link', '#21A1B3', 'base'),
(17, 'theme.var.HumHub.isFluid', 'false', 'base'),
(18, 'theme.var.HumHub.text-color-main', '#555', 'base'),
(19, 'theme.var.HumHub.text-color-default', '#4b4b4b', 'base'),
(20, 'theme.var.HumHub.text-color-secondary', '#7a7a7a', 'base'),
(21, 'theme.var.HumHub.text-color-highlight', '#000', 'base'),
(22, 'theme.var.HumHub.text-color-soft', '#555555', 'base'),
(23, 'theme.var.HumHub.text-color-soft2', '#aeaeae', 'base'),
(24, 'theme.var.HumHub.text-color-soft3', '#bac2c7', 'base'),
(25, 'theme.var.HumHub.text-color-contrast', '#fff', 'base'),
(26, 'theme.var.HumHub.background-color-main', '#fff', 'base'),
(27, 'theme.var.HumHub.background-color-secondary', '#f9f9f9', 'base'),
(28, 'theme.var.HumHub.background-color-page', '#ededed', 'base'),
(29, 'theme.var.HumHub.background-color-highlight', 'fade(@info, 20%)', 'base'),
(30, 'theme.var.HumHub.background-color-highlight-soft', 'lighten(desaturate(spin(@info, 6), 16), 55)', 'base'),
(31, 'theme.var.HumHub.background3', '#d7d7d7', 'base'),
(32, 'theme.var.HumHub.background4', '#b2b2b2', 'base'),
(33, 'theme.var.HumHub.background-color-success', '#f7fbf4', 'base'),
(34, 'theme.var.HumHub.text-color-success', '#84be5e', 'base'),
(35, 'theme.var.HumHub.border-color-success', '#97d271', 'base'),
(36, 'theme.var.HumHub.background-color-warning', '#fffbf7', 'base'),
(37, 'theme.var.HumHub.text-color-warning', '#e9b168', 'base'),
(38, 'theme.var.HumHub.border-color-warning', '#fdd198', 'base'),
(39, 'theme.var.HumHub.background-color-danger', '#fff6f6', 'base'),
(40, 'theme.var.HumHub.text-color-danger', '#ff8989', 'base'),
(41, 'theme.var.HumHub.border-color-danger', '#ff8989', 'base'),
(42, 'theme.var.HumHub.mail-font-family', '''Open Sans'', Arial, Tahoma, Helvetica, sans-serif', 'base'),
(43, 'name', '[[site_name]]', 'base'),
(44, 'baseUrl', '[[softurl]]', 'base'),
(45, 'paginationSize', '10', 'base'),
(46, 'displayNameFormat', '{profile.firstname} {profile.lastname}', 'base'),
(47, 'horImageScrollOnMobile', '1', 'base'),
(48, 'cronLastDailyRun', '[[timestamp]]', 'base'),
(49, 'auth.needApproval', '0', 'user'),
(50, 'auth.anonymousRegistration', '1', 'user'),
(51, 'auth.internalUsersCanInviteByEmail', '1', 'user'),
(52, 'auth.internalUsersCanInviteByLink', '1', 'user'),
(53, 'mailer.transportType', 'php', 'base'),
(54, 'mailer.systemEmailAddress', 'social@example.com', 'base'),
(55, 'mailer.systemEmailName', '[[site_name]]', 'base'),
(56, 'mailSummaryInterval', '2', 'activity'),
(57, 'maxFileSize', '41943040', 'file'),
(58, 'excludeMediaFilesPreview', '1', 'file'),
(59, 'cacheClass', 'yii\\caching\\FileCache', 'base'),
(60, 'cacheExpireTime', '3600', 'base'),
(61, 'installationId', '[[installationId]]', 'admin'),
(62, 'spaceOrder', '0', 'space'),
(63, 'enable', '1', 'tour'),
(64, 'cronLastRun', '[[timestamp]]', 'base'),
(65, 'defaultLanguage', '[[language]]', 'base'),
(66, 'useCase', 'other', 'base'),
(67, 'group.adminGroupId', '1', 'user'),
(68, 'sampleData', '1', 'installer'),
(69, 'secret', '[[secret]]', 'base'),
(70, 'defaultTimeZone', 'America/New_York', 'base');

-- --------------------------------------------------------

--
-- Table structure for table `space`
--

CREATE TABLE `space` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `about` text COLLATE utf8mb4_unicode_ci,
  `join_policy` tinyint(4) DEFAULT NULL,
  `visibility` tinyint(4) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_dn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_add_new_members` int(4) DEFAULT NULL,
  `contentcontainer_id` int(11) DEFAULT NULL,
  `default_content_visibility` tinyint(1) DEFAULT NULL,
  `color` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `members_can_leave` int(11) DEFAULT '1',
  `url` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `url-unique` (`url`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `space`
--

INSERT INTO `space` VALUES
(1, '9796124c-3f1a-4bf0-ab17-e54c40946140', 'Welcome Space', 'Your first sample space to discover the platform.', NULL, 2, 2, 1, 100, '[[regtime]]', 1, '[[regtime]]', 1, NULL, 1, 2, NULL, '#6fdbe8', 1, 'welcome-space');

-- --------------------------------------------------------

--
-- Table structure for table `space_membership`
--

CREATE TABLE `space_membership` (
  `space_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `originator_user_id` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `request_message` mediumtext COLLATE utf8mb4_unicode_ci,
  `last_visit` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `group_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'member',
  `show_at_dashboard` tinyint(1) DEFAULT '1',
  `can_cancel_membership` int(11) DEFAULT '1',
  `send_notifications` tinyint(1) DEFAULT '0',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `index_status` (`status`),
  KEY `fk_space_membership-space_id` (`space_id`),
  KEY `fk_space_membership-user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `space_membership`
--

INSERT INTO `space_membership` VALUES
(1, 1, NULL, 3, NULL, NULL, '[[regtime]]', 1, '[[regtime]]', 1, 'admin', 1, 1, 0, 1),
(1, 2, NULL, 3, NULL, NULL, '[[regtime]]', 1, '[[regtime]]', 1, 'member', 1, 1, 0, 2),
(1, 3, NULL, 3, NULL, NULL, '[[regtime]]', 1, '[[regtime]]', 1, 'member', 1, 1, 0, 3);

-- --------------------------------------------------------

--
-- Table structure for table `url_oembed`
--

CREATE TABLE `url_oembed` (
  `url` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preview` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `username` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` char(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_mode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `visibility` int(1) DEFAULT '1',
  `time_zone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contentcontainer_id` int(11) DEFAULT NULL,
  `authclient_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_key` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_email` (`email`),
  UNIQUE KEY `unique_username` (`username`),
  UNIQUE KEY `unique_guid` (`guid`),
  UNIQUE KEY `unique_authclient_id` (`authclient_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, 'e0a06746-ac69-4eef-8bc8-0a71cfa872f1', 1, '[[admin_username]]', '[[admin_email]]', 'local', '', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1, NULL, 1, NULL, '[[auth_key]]'),
(2, '6b78f1f5-d133-4803-9ee2-bf8257d20eea', 1, 'david1986', 'david.roberts@example.com', 'local', '', '[[regtime]]', 1, '[[regtime]]', 1, NULL, 1, NULL, 3, NULL, NULL),
(3, '576bf5a1-210d-42d6-8585-eef4aa364974', 1, 'sara1989', 'sara.schuster@example.com', 'local', '', '[[regtime]]', 1, '[[regtime]]', 1, NULL, 1, NULL, 4, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_auth`
--

CREATE TABLE `user_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_follow`
--

CREATE TABLE `user_follow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `send_notifications` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `index_user` (`user_id`),
  KEY `index_object` (`object_model`,`object_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `user_follow`
--

INSERT INTO `user_follow` VALUES
(1, 'humhub\\modules\\post\\models\\Post', 1, 1, 1),
(2, 'humhub\\modules\\post\\models\\Post', 2, 1, 1),
(3, 'humhub\\modules\\post\\models\\Post', 2, 2, 1),
(4, 'humhub\\modules\\post\\models\\Post', 2, 3, 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_friendship`
--

CREATE TABLE `user_friendship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `friend_user_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx-friends` (`user_id`,`friend_user_id`),
  KEY `fk-friend` (`friend_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_http_session`
--

CREATE TABLE `user_http_session` (
  `id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`id`),
  KEY `fk_user_http_session-user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_invite`
--

CREATE TABLE `user_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_originator_id` int(11) DEFAULT NULL,
  `space_invite_id` int(11) DEFAULT NULL,
  `email` char(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `language` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_email` (`email`),
  UNIQUE KEY `unique_token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_mentioning`
--

CREATE TABLE `user_mentioning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_user` (`user_id`),
  KEY `i_object` (`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_password`
--

CREATE TABLE `user_password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `algorithm` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` mediumtext COLLATE utf8mb4_unicode_ci,
  `salt` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_password`
--

INSERT INTO `user_password` VALUES
(1, 1, 'bcrypt', '[[admin_pass]]', '[[salt]]', '[[regtime]]');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `comment`
--
ALTER TABLE `comment`
  ADD CONSTRAINT `fk_comment-created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `content`
--
ALTER TABLE `content`
  ADD CONSTRAINT `fk-contentcontainer` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk-create-user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk-update-user` FOREIGN KEY (`updated_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `contentcontainer_blocked_users`
--
ALTER TABLE `contentcontainer_blocked_users`
  ADD CONSTRAINT `fk-contentcontainer-blocked-users-rel-contentcontainer-id` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-contentcontainer-blocked-users-rel-user-id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `contentcontainer_module`
--
ALTER TABLE `contentcontainer_module`
  ADD CONSTRAINT `fk_contentcontainer` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contentcontainer_setting`
--
ALTER TABLE `contentcontainer_setting`
  ADD CONSTRAINT `fk-contentcontainerx` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contentcontainer_tag_relation`
--
ALTER TABLE `contentcontainer_tag_relation`
  ADD CONSTRAINT `fk-contentcontainer-tag-rel-contentcontainer-id` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-contentcontainer-tag-rel-tag-id` FOREIGN KEY (`tag_id`) REFERENCES `contentcontainer_tag` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `content_fulltext`
--
ALTER TABLE `content_fulltext`
  ADD CONSTRAINT `fk_content_fulltext` FOREIGN KEY (`content_id`) REFERENCES `content` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `content_tag`
--
ALTER TABLE `content_tag`
  ADD CONSTRAINT `fk-content-tag-container-id` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-content-tag-parent-id` FOREIGN KEY (`parent_id`) REFERENCES `content_tag` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `content_tag_relation`
--
ALTER TABLE `content_tag_relation`
  ADD CONSTRAINT `fk-content-tag-rel-content-id` FOREIGN KEY (`content_id`) REFERENCES `content` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-content-tag-rel-tag-id` FOREIGN KEY (`tag_id`) REFERENCES `content_tag` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `file`
--
ALTER TABLE `file`
  ADD CONSTRAINT `fk_file-created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `file_history`
--
ALTER TABLE `file_history`
  ADD CONSTRAINT `fk_file_history` FOREIGN KEY (`file_id`) REFERENCES `file` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_file_history_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE SET NULL;

--
-- Constraints for table `group_permission`
--
ALTER TABLE `group_permission`
  ADD CONSTRAINT `fk_group_permission-group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `group_space`
--
ALTER TABLE `group_space`
  ADD CONSTRAINT `fk-group_space-group` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-group_space-space` FOREIGN KEY (`space_id`) REFERENCES `space` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `group_user`
--
ALTER TABLE `group_user`
  ADD CONSTRAINT `fk-group-group` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-user-group` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `like`
--
ALTER TABLE `like`
  ADD CONSTRAINT `fk_like-created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_like-target_user_id` FOREIGN KEY (`target_user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `live`
--
ALTER TABLE `live`
  ADD CONSTRAINT `contentcontainer` FOREIGN KEY (`contentcontainer_id`) REFERENCES `contentcontainer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `notification`
--
ALTER TABLE `notification`
  ADD CONSTRAINT `fk_notification-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `profile`
--
ALTER TABLE `profile`
  ADD CONSTRAINT `fk_profile-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `profile_field`
--
ALTER TABLE `profile_field`
  ADD CONSTRAINT `fk_profile_field-profile_field_category_id` FOREIGN KEY (`profile_field_category_id`) REFERENCES `profile_field_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `space_membership`
--
ALTER TABLE `space_membership`
  ADD CONSTRAINT `fk_space_membership-space_id` FOREIGN KEY (`space_id`) REFERENCES `space` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_space_membership-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_auth`
--
ALTER TABLE `user_auth`
  ADD CONSTRAINT `fk_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_follow`
--
ALTER TABLE `user_follow`
  ADD CONSTRAINT `fk_user_follow-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_friendship`
--
ALTER TABLE `user_friendship`
  ADD CONSTRAINT `fk-friend` FOREIGN KEY (`friend_user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk-user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_http_session`
--
ALTER TABLE `user_http_session`
  ADD CONSTRAINT `fk_user_http_session-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_mentioning`
--
ALTER TABLE `user_mentioning`
  ADD CONSTRAINT `fk_user_mentioning-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_password`
--
ALTER TABLE `user_password`
  ADD CONSTRAINT `fk_user_password-user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
