
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `humogen671`
--

-- --------------------------------------------------------

--
-- Table structure for table `humo_addresses`
--

CREATE TABLE `humo_addresses` (
  `address_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `address_tree_id` smallint(5) DEFAULT NULL,
  `address_gedcomnr` varchar(25) DEFAULT NULL,
  `address_shared` varchar(1) DEFAULT '',
  `address_order` mediumint(6) DEFAULT NULL,
  `address_connect_kind` varchar(25) DEFAULT NULL,
  `address_connect_sub_kind` varchar(30) DEFAULT NULL,
  `address_connect_id` varchar(25) DEFAULT NULL,
  `address_address` text,
  `address_zip` varchar(20) DEFAULT NULL,
  `address_place` varchar(120) DEFAULT NULL,
  `address_phone` varchar(20) DEFAULT NULL,
  `address_date` varchar(35) DEFAULT NULL,
  `address_text` text,
  `address_quality` varchar(1) DEFAULT '',
  `address_new_user` varchar(200) DEFAULT NULL,
  `address_new_date` varchar(35) DEFAULT NULL,
  `address_new_time` varchar(25) DEFAULT NULL,
  `address_changed_user` varchar(200) DEFAULT NULL,
  `address_changed_date` varchar(35) DEFAULT NULL,
  `address_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`address_id`),
  KEY `address_tree_id` (`address_tree_id`),
  KEY `address_gedcomnr` (`address_gedcomnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_cms_menu`
--

CREATE TABLE `humo_cms_menu` (
  `menu_id` int(10) NOT NULL AUTO_INCREMENT,
  `menu_parent_id` int(10) NOT NULL DEFAULT '0',
  `menu_order` int(5) NOT NULL DEFAULT '0',
  `menu_name` varchar(25) DEFAULT '',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_cms_pages`
--

CREATE TABLE `humo_cms_pages` (
  `page_id` int(10) NOT NULL AUTO_INCREMENT,
  `page_status` varchar(1) DEFAULT '',
  `page_menu_id` int(10) NOT NULL DEFAULT '0',
  `page_order` int(10) NOT NULL DEFAULT '0',
  `page_counter` int(10) NOT NULL DEFAULT '0',
  `page_date` datetime DEFAULT NULL,
  `page_edit_date` datetime DEFAULT NULL,
  `page_title` varchar(50) DEFAULT '',
  `page_text` longtext,
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_connections`
--

CREATE TABLE `humo_connections` (
  `connect_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `connect_tree_id` smallint(5) DEFAULT NULL,
  `connect_order` mediumint(6) DEFAULT NULL,
  `connect_kind` varchar(25) DEFAULT NULL,
  `connect_sub_kind` varchar(30) DEFAULT NULL,
  `connect_connect_id` varchar(25) DEFAULT NULL,
  `connect_date` varchar(35) DEFAULT NULL,
  `connect_place` varchar(120) DEFAULT NULL,
  `connect_time` varchar(25) DEFAULT NULL,
  `connect_page` text,
  `connect_role` varchar(75) DEFAULT NULL,
  `connect_text` text,
  `connect_source_id` varchar(25) DEFAULT NULL,
  `connect_item_id` varchar(25) DEFAULT NULL,
  `connect_status` varchar(10) DEFAULT NULL,
  `connect_quality` varchar(1) DEFAULT '',
  `connect_new_user` varchar(200) DEFAULT NULL,
  `connect_new_date` varchar(35) DEFAULT NULL,
  `connect_new_time` varchar(25) DEFAULT NULL,
  `connect_changed_user` varchar(200) DEFAULT NULL,
  `connect_changed_date` varchar(35) DEFAULT NULL,
  `connect_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`connect_id`),
  KEY `connect_connect_id` (`connect_connect_id`),
  KEY `connect_tree_id` (`connect_tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_events`
--

CREATE TABLE `humo_events` (
  `event_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_tree_id` smallint(5) DEFAULT NULL,
  `event_gedcomnr` varchar(25) DEFAULT NULL,
  `event_order` mediumint(6) DEFAULT NULL,
  `event_connect_kind` varchar(25) DEFAULT NULL,
  `event_connect_id` varchar(25) DEFAULT NULL,
  `event_connect_kind2` varchar(25) DEFAULT NULL,
  `event_connect_id2` varchar(25) DEFAULT NULL,
  `event_pers_age` varchar(15) DEFAULT NULL,
  `event_kind` varchar(20) DEFAULT NULL,
  `event_event` text,
  `event_event_extra` text,
  `event_gedcom` varchar(20) DEFAULT NULL,
  `event_date` varchar(35) DEFAULT NULL,
  `event_place` varchar(120) DEFAULT NULL,
  `event_text` text,
  `event_quality` varchar(1) DEFAULT '',
  `event_new_user` varchar(200) DEFAULT NULL,
  `event_new_date` varchar(35) DEFAULT NULL,
  `event_new_time` varchar(25) DEFAULT NULL,
  `event_changed_user` varchar(200) DEFAULT NULL,
  `event_changed_date` varchar(35) DEFAULT NULL,
  `event_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event_tree_id` (`event_tree_id`),
  KEY `event_connect_id` (`event_connect_id`),
  KEY `event_connect_id2` (`event_connect_id2`),
  KEY `event_kind` (`event_kind`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_families`
--

CREATE TABLE `humo_families` (
  `fam_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fam_tree_id` mediumint(7) DEFAULT NULL,
  `fam_gedcomnumber` varchar(25) DEFAULT NULL,
  `fam_man` varchar(25) DEFAULT NULL,
  `fam_man_age` varchar(15) DEFAULT NULL,
  `fam_woman` varchar(25) DEFAULT NULL,
  `fam_woman_age` varchar(15) DEFAULT NULL,
  `fam_children` text,
  `fam_kind` varchar(50) DEFAULT NULL,
  `fam_relation_date` varchar(35) DEFAULT NULL,
  `fam_relation_place` varchar(120) DEFAULT NULL,
  `fam_relation_text` text,
  `fam_relation_end_date` varchar(35) DEFAULT NULL,
  `fam_marr_notice_date` varchar(35) DEFAULT NULL,
  `fam_marr_notice_place` varchar(120) DEFAULT NULL,
  `fam_marr_notice_text` text,
  `fam_marr_date` varchar(35) DEFAULT NULL,
  `fam_marr_place` varchar(120) DEFAULT NULL,
  `fam_marr_text` text,
  `fam_marr_authority` text,
  `fam_marr_church_notice_date` varchar(35) DEFAULT NULL,
  `fam_marr_church_notice_place` varchar(120) DEFAULT NULL,
  `fam_marr_church_notice_text` text,
  `fam_marr_church_date` varchar(35) DEFAULT NULL,
  `fam_marr_church_place` varchar(120) DEFAULT NULL,
  `fam_marr_church_text` text,
  `fam_religion` varchar(50) DEFAULT NULL,
  `fam_div_date` varchar(35) DEFAULT NULL,
  `fam_div_place` varchar(120) DEFAULT NULL,
  `fam_div_text` text,
  `fam_div_authority` text,
  `fam_text` text,
  `fam_alive` int(1) DEFAULT NULL,
  `fam_cal_date` varchar(35) DEFAULT NULL,
  `fam_quality` varchar(1) DEFAULT '',
  `fam_counter` mediumint(7) DEFAULT NULL,
  `fam_new_user` varchar(200) DEFAULT NULL,
  `fam_new_date` varchar(35) DEFAULT NULL,
  `fam_new_time` varchar(25) DEFAULT NULL,
  `fam_changed_user` varchar(200) DEFAULT NULL,
  `fam_changed_date` varchar(35) DEFAULT NULL,
  `fam_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`fam_id`),
  KEY `fam_tree_id` (`fam_tree_id`),
  KEY `fam_gedcomnumber` (`fam_gedcomnumber`),
  KEY `fam_man` (`fam_man`),
  KEY `fam_woman` (`fam_woman`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_groups`
--

CREATE TABLE `humo_groups` (
  `group_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(25) DEFAULT NULL,
  `group_privacy` varchar(1) DEFAULT NULL,
  `group_menu_places` varchar(1) DEFAULT NULL,
  `group_admin` varchar(1) DEFAULT NULL,
  `group_statistics` varchar(1) NOT NULL DEFAULT 'j',
  `group_menu_persons` varchar(1) NOT NULL DEFAULT 'j',
  `group_menu_names` varchar(1) NOT NULL DEFAULT 'j',
  `group_menu_login` varchar(1) NOT NULL DEFAULT 'j',
  `group_birthday_rss` varchar(1) NOT NULL DEFAULT 'j',
  `group_birthday_list` varchar(1) NOT NULL DEFAULT 'j',
  `group_latestchanges` varchar(1) NOT NULL DEFAULT 'j',
  `group_contact` varchar(1) NOT NULL DEFAULT 'j',
  `group_googlemaps` varchar(1) NOT NULL DEFAULT 'j',
  `group_relcalc` varchar(1) NOT NULL DEFAULT 'j',
  `group_showstatistics` varchar(1) NOT NULL DEFAULT 'j',
  `group_sources` varchar(1) DEFAULT NULL,
  `group_show_restricted_source` varchar(1) NOT NULL DEFAULT 'y',
  `group_source_presentation` varchar(20) DEFAULT NULL,
  `group_text_presentation` varchar(20) NOT NULL DEFAULT 'show',
  `group_pictures` varchar(1) DEFAULT NULL,
  `group_photobook` varchar(1) NOT NULL DEFAULT 'n',
  `group_gedcomnr` varchar(1) DEFAULT NULL,
  `group_living_place` varchar(1) DEFAULT NULL,
  `group_places` varchar(1) DEFAULT NULL,
  `group_religion` varchar(1) DEFAULT NULL,
  `group_place_date` varchar(1) DEFAULT NULL,
  `group_kindindex` varchar(1) DEFAULT NULL,
  `group_event` varchar(1) DEFAULT NULL,
  `group_addresses` varchar(1) DEFAULT NULL,
  `group_own_code` varchar(1) DEFAULT NULL,
  `group_user_notes` varchar(1) NOT NULL DEFAULT 'n',
  `group_user_notes_notes` varchar(1) NOT NULL DEFAULT 'n',
  `group_user_notes_show` varchar(1) NOT NULL DEFAULT 'n',
  `group_family_presentation` varchar(10) NOT NULL DEFAULT 'compact',
  `group_maps_presentation` varchar(10) NOT NULL DEFAULT 'hide',
  `group_show_age_living_person` varchar(1) NOT NULL DEFAULT 'y',
  `group_pdf_button` varchar(1) DEFAULT NULL,
  `group_rtf_button` varchar(1) NOT NULL DEFAULT 'n',
  `group_work_text` varchar(1) DEFAULT NULL,
  `group_texts` varchar(1) DEFAULT NULL,
  `group_text_pers` varchar(1) DEFAULT NULL,
  `group_texts_pers` varchar(1) DEFAULT NULL,
  `group_texts_fam` varchar(1) DEFAULT NULL,
  `group_alive` varchar(1) DEFAULT NULL,
  `group_alive_date_act` varchar(1) DEFAULT NULL,
  `group_alive_date` varchar(4) DEFAULT NULL,
  `group_death_date_act` varchar(1) DEFAULT NULL,
  `group_death_date` varchar(4) DEFAULT NULL,
  `group_filter_date` varchar(1) NOT NULL DEFAULT 'n',
  `group_filter_death` varchar(1) DEFAULT NULL,
  `group_filter_total` varchar(1) DEFAULT NULL,
  `group_filter_name` varchar(1) DEFAULT NULL,
  `group_filter_fam` varchar(1) DEFAULT NULL,
  `group_filter_pers_show_act` varchar(1) DEFAULT NULL,
  `group_filter_pers_show` varchar(50) DEFAULT NULL,
  `group_filter_pers_hide_act` varchar(1) DEFAULT NULL,
  `group_filter_pers_hide` varchar(50) DEFAULT NULL,
  `group_pers_hide_totally_act` varchar(1) NOT NULL DEFAULT 'n',
  `group_pers_hide_totally` varchar(50) NOT NULL DEFAULT 'X',
  `group_gen_protection` varchar(1) NOT NULL DEFAULT 'n',
  `group_hide_trees` varchar(200) NOT NULL DEFAULT '',
  `group_edit_trees` varchar(200) NOT NULL DEFAULT '',
  `group_hide_photocat` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `humo_groups`
--

INSERT INTO `humo_groups` VALUES
(1, 'admin', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'y', NULL, 'show', 'j', 'n', 'j', 'j', 'j', 'j', 'n', 'n', 'j', 'j', 'j', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'y', 'j', 'j', 'j', 'j', 'j', 'n', 'n', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', ''),
(2, 'family', 'n', 'n', 'n', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'n', 'y', NULL, 'show', 'n', 'n', 'n', 'j', 'j', 'n', 'n', 'n', 'j', 'j', 'j', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'n', 'j', 'j', 'j', 'j', 'j', 'n', 'n', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', ''),
(3, 'guest', 'n', 'n', 'n', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'n', 'y', NULL, 'show', 'n', 'n', 'n', 'n', 'j', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'n', 'n', 'j', 'j', 'j', 'j', 'n', 'j', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', ''),
(4, 'group 4', 'n', 'n', 'n', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'n', 'y', NULL, 'show', 'n', 'n', 'n', 'n', 'j', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'n', 'n', 'j', 'j', 'j', 'j', 'n', 'j', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', ''),
(5, 'group 5', 'j', 'n', 'n', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'n', 'y', NULL, 'show', 'n', 'n', 'n', 'n', 'j', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'n', 'n', 'j', 'j', 'j', 'j', 'n', 'j', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', ''),
(6, 'group 6', 'n', 'n', 'n', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'j', 'n', 'y', NULL, 'show', 'n', 'n', 'n', 'n', 'j', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'compact', 'hide', 'y', 'y', 'n', 'n', 'j', 'j', 'j', 'j', 'n', 'j', '1920', 'n', '1980', 'n', 'n', 'n', 'j', 'j', 'j', '*', 'n', '#', 'n', 'X', 'n', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `humo_persons`
--

CREATE TABLE `humo_persons` (
  `pers_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pers_gedcomnumber` varchar(25) DEFAULT NULL,
  `pers_tree_id` mediumint(7) DEFAULT NULL,
  `pers_tree_prefix` varchar(10) DEFAULT NULL,
  `pers_famc` varchar(50) DEFAULT NULL,
  `pers_fams` varchar(150) DEFAULT NULL,
  `pers_indexnr` varchar(25) DEFAULT NULL,
  `pers_firstname` varchar(60) DEFAULT NULL,
  `pers_callname` varchar(50) DEFAULT NULL,
  `pers_prefix` varchar(20) DEFAULT NULL,
  `pers_lastname` varchar(60) DEFAULT NULL,
  `pers_patronym` varchar(50) DEFAULT NULL,
  `pers_name_text` text,
  `pers_sexe` varchar(1) DEFAULT NULL,
  `pers_own_code` varchar(100) DEFAULT NULL,
  `pers_birth_place` varchar(120) DEFAULT NULL,
  `pers_birth_date` varchar(35) DEFAULT NULL,
  `pers_birth_time` varchar(25) DEFAULT NULL,
  `pers_birth_text` text,
  `pers_stillborn` varchar(1) DEFAULT 'n',
  `pers_bapt_place` varchar(120) DEFAULT NULL,
  `pers_bapt_date` varchar(35) DEFAULT NULL,
  `pers_bapt_text` text,
  `pers_religion` varchar(50) DEFAULT NULL,
  `pers_death_place` varchar(120) DEFAULT NULL,
  `pers_death_date` varchar(35) DEFAULT NULL,
  `pers_death_time` varchar(25) DEFAULT NULL,
  `pers_death_text` text,
  `pers_death_cause` varchar(255) DEFAULT NULL,
  `pers_death_age` varchar(15) DEFAULT NULL,
  `pers_buried_place` varchar(120) DEFAULT NULL,
  `pers_buried_date` varchar(35) DEFAULT NULL,
  `pers_buried_text` text,
  `pers_cremation` varchar(1) DEFAULT NULL,
  `pers_place_index` text,
  `pers_text` text,
  `pers_alive` varchar(20) DEFAULT NULL,
  `pers_cal_date` varchar(35) DEFAULT NULL,
  `pers_quality` varchar(1) DEFAULT '',
  `pers_new_user` varchar(200) DEFAULT NULL,
  `pers_new_date` varchar(35) DEFAULT NULL,
  `pers_new_time` varchar(25) DEFAULT NULL,
  `pers_changed_user` varchar(200) DEFAULT NULL,
  `pers_changed_date` varchar(35) DEFAULT NULL,
  `pers_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`pers_id`),
  KEY `pers_prefix` (`pers_prefix`),
  KEY `pers_lastname` (`pers_lastname`),
  KEY `pers_gedcomnumber` (`pers_gedcomnumber`),
  KEY `pers_tree_id` (`pers_tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_repositories`
--

CREATE TABLE `humo_repositories` (
  `repo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo_tree_id` smallint(5) DEFAULT NULL,
  `repo_gedcomnr` varchar(25) DEFAULT NULL,
  `repo_name` text,
  `repo_address` text,
  `repo_zip` varchar(20) DEFAULT NULL,
  `repo_place` varchar(120) DEFAULT NULL,
  `repo_phone` varchar(25) DEFAULT NULL,
  `repo_date` varchar(35) DEFAULT NULL,
  `repo_text` text,
  `repo_mail` varchar(100) DEFAULT NULL,
  `repo_url` varchar(150) DEFAULT NULL,
  `repo_quality` varchar(1) DEFAULT '',
  `repo_new_user` varchar(200) DEFAULT NULL,
  `repo_new_date` varchar(35) DEFAULT NULL,
  `repo_new_time` varchar(25) DEFAULT NULL,
  `repo_changed_user` varchar(200) DEFAULT NULL,
  `repo_changed_date` varchar(35) DEFAULT NULL,
  `repo_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`repo_id`),
  KEY `repo_tree_id` (`repo_tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_settings`
--

CREATE TABLE `humo_settings` (
  `setting_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting_variable` varchar(50) DEFAULT NULL,
  `setting_value` text,
  `setting_order` smallint(5) DEFAULT NULL,
  `setting_tree_id` smallint(5) DEFAULT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=90 ;

--
-- Dumping data for table `humo_settings`
--

INSERT INTO `humo_settings` VALUES
(1, 'database_name', 'Web Site', NULL, NULL),
(2, 'homepage', 'https://humo-gen.com', NULL, NULL),
(3, 'homepage_description', 'Website', NULL, NULL),
(4, 'searchengine', 'n', NULL, NULL),
(5, 'robots_option', '<META NAME="robots" CONTENT="noindex,nofollow">', NULL, NULL),
(6, 'update_status', '16', NULL, NULL),
(7, 'template_homepage', 'active|left|select_family_tree', 1, NULL),
(8, 'template_homepage', 'active|center|selected_family_tree', 2, NULL),
(9, 'template_homepage', 'active|center|names|2|4', 3, NULL),
(10, 'template_homepage', 'active|center|alphabet', 4, NULL),
(11, 'template_homepage', 'inactive|center|history', 5, NULL),
(12, 'template_homepage', 'active|center|favourites', 6, NULL),
(13, 'template_homepage', 'inactive|center|text', 7, NULL),
(14, 'template_homepage', 'inactive|center|cms_page', 8, NULL),
(15, 'template_homepage', 'active|right|search', 9, NULL),
(16, 'template_homepage', 'inactive|right|random_photo', 10, NULL),
(17, 'rss_link', 'http://', NULL, NULL),
(18, 'descendant_generations', '4', NULL, NULL),
(19, 'show_persons', '30', NULL, NULL),
(20, 'url_rewrite', 'n', NULL, NULL),
(21, 'default_skin', '', NULL, NULL),
(22, 'default_language', '[[language]]', NULL, NULL),
(23, 'default_language_admin', '[[admin_language]]', NULL, NULL),
(24, 'text_header', '', NULL, NULL),
(25, 'text_footer', '', NULL, NULL),
(26, 'timezone', 'Europe/Amsterdam', NULL, NULL),
(27, 'block_spam_question', 'what is the capital of England?', NULL, NULL),
(28, 'block_spam_answer', 'london', NULL, NULL),
(29, 'use_spam_question', 'n', NULL, NULL),
(30, 'use_newsletter_question', 'n', NULL, NULL),
(31, 'visitor_registration', 'n', NULL, NULL),
(32, 'general_email', '', NULL, NULL),
(33, 'visitor_registration_group', '3', NULL, NULL),
(34, 'registration_use_spam_question', 'y', NULL, NULL),
(35, 'password_retreival', '', NULL, NULL),
(36, 'update_last_check', '2012_01_01', NULL, NULL),
(37, 'update_text', '', NULL, NULL),
(38, 'searchengine_cms_only', 'n', NULL, NULL),
(39, 'gedcom_read_add_source', 'n', NULL, NULL),
(40, 'gedcom_read_reassign_gedcomnumbers', 'n', NULL, NULL),
(41, 'gedcom_read_order_by_date', 'n', NULL, NULL),
(42, 'gedcom_read_order_by_fams', 'n', NULL, NULL),
(43, 'gedcom_read_process_geo_location', 'n', NULL, NULL),
(44, 'gedcom_process_pict_path', 'file_name', NULL, NULL),
(45, 'gedcom_read_save_pictures', 'n', NULL, NULL),
(46, 'gedcom_read_commit_records', '500', NULL, NULL),
(47, 'gedcom_read_time_out', '0', NULL, NULL),
(48, 'watermark_text', '', NULL, NULL),
(49, 'watermark_color_r', '224', NULL, NULL),
(50, 'watermark_color_g', '224', NULL, NULL),
(51, 'watermark_color_b', '224', NULL, NULL),
(52, 'min_search_chars', '3', NULL, NULL),
(53, 'date_display', 'eu', NULL, NULL),
(54, 'name_order', 'western', NULL, NULL),
(55, 'default_timeline', '', NULL, NULL),
(56, 'one_name_study', 'n', NULL, NULL),
(57, 'one_name_thename', '', NULL, NULL),
(58, 'geo_trees', '', NULL, NULL),
(59, 'slideshow_show', 'n', NULL, NULL),
(60, 'slideshow_01', '|', NULL, NULL),
(61, 'slideshow_02', '|', NULL, NULL),
(62, 'slideshow_03', '|', NULL, NULL),
(63, 'slideshow_04', '|', NULL, NULL),
(64, 'david_stars', 'n', NULL, NULL),
(65, 'death_char', 'n', NULL, NULL),
(66, 'death_shoa', 'n', NULL, NULL),
(67, 'admin_hebdate', 'n', NULL, NULL),
(68, 'admin_hebnight', 'n', NULL, NULL),
(69, 'admin_hebname', 'n', NULL, NULL),
(70, 'admin_brit', 'n', NULL, NULL),
(71, 'admin_barm', 'n', NULL, NULL),
(72, 'admin_online_search', 'n', NULL, NULL),
(73, 'debug_front_pages', 'n', NULL, NULL),
(74, 'debug_admin_pages', 'n', NULL, NULL),
(75, 'hide_languages', '', NULL, NULL),
(76, 'hide_themes', '', NULL, NULL),
(77, 'mail_auto', 'manual', NULL, NULL),
(78, 'email_user', '', NULL, NULL),
(79, 'email_password', '', NULL, NULL),
(80, 'smtp_server', '', NULL, NULL),
(81, 'smtp_port', '587', NULL, NULL),
(82, 'smtp_auth', 'true', NULL, NULL),
(83, 'smtp_encryption', 'tls', NULL, NULL),
(84, 'smtp_debug', '0', NULL, NULL),
(85, 'gedcom_submit_name', '', NULL, NULL),
(86, 'gedcom_submit_address', '', NULL, NULL),
(87, 'gedcom_submit_country', '', NULL, NULL),
(88, 'gedcom_submit_mail', '', NULL, NULL),
(89, 'cleanup_status', '7', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `humo_sources`
--

CREATE TABLE `humo_sources` (
  `source_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source_tree_id` smallint(5) DEFAULT NULL,
  `source_status` varchar(10) DEFAULT NULL,
  `source_gedcomnr` varchar(25) DEFAULT NULL,
  `source_shared` varchar(1) DEFAULT '',
  `source_order` mediumint(6) DEFAULT NULL,
  `source_title` text,
  `source_abbr` varchar(50) DEFAULT NULL,
  `source_date` varchar(35) DEFAULT NULL,
  `source_publ` varchar(150) DEFAULT NULL,
  `source_place` varchar(120) DEFAULT NULL,
  `source_refn` varchar(50) DEFAULT NULL,
  `source_auth` varchar(50) DEFAULT NULL,
  `source_subj` varchar(248) DEFAULT NULL,
  `source_item` varchar(30) DEFAULT NULL,
  `source_kind` varchar(50) DEFAULT NULL,
  `source_text` text,
  `source_repo_name` varchar(50) DEFAULT NULL,
  `source_repo_caln` varchar(50) DEFAULT NULL,
  `source_repo_page` varchar(50) DEFAULT NULL,
  `source_repo_gedcomnr` varchar(25) DEFAULT NULL,
  `source_quality` varchar(1) DEFAULT '',
  `source_new_user` varchar(200) DEFAULT NULL,
  `source_new_date` varchar(35) DEFAULT NULL,
  `source_new_time` varchar(25) DEFAULT NULL,
  `source_changed_user` varchar(200) DEFAULT NULL,
  `source_changed_date` varchar(35) DEFAULT NULL,
  `source_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`source_id`),
  KEY `source_tree_id` (`source_tree_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_stat_country`
--

CREATE TABLE `humo_stat_country` (
  `stat_country_id` int(10) NOT NULL AUTO_INCREMENT,
  `stat_country_ip_address` varchar(40) DEFAULT NULL,
  `stat_country_code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`stat_country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_stat_date`
--

CREATE TABLE `humo_stat_date` (
  `stat_id` int(10) NOT NULL AUTO_INCREMENT,
  `stat_easy_id` varchar(100) DEFAULT NULL,
  `stat_ip_address` varchar(40) DEFAULT NULL,
  `stat_user_agent` varchar(255) DEFAULT NULL,
  `stat_tree_id` varchar(5) DEFAULT NULL,
  `stat_gedcom_fam` varchar(25) DEFAULT NULL,
  `stat_gedcom_man` varchar(25) DEFAULT NULL,
  `stat_gedcom_woman` varchar(25) DEFAULT NULL,
  `stat_date_stat` datetime DEFAULT NULL,
  `stat_date_linux` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`stat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_texts`
--

CREATE TABLE `humo_texts` (
  `text_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `text_tree_id` smallint(5) DEFAULT NULL,
  `text_gedcomnr` varchar(25) DEFAULT NULL,
  `text_text` text,
  `text_quality` varchar(1) DEFAULT '',
  `text_new_user` varchar(200) DEFAULT NULL,
  `text_new_date` varchar(35) DEFAULT NULL,
  `text_new_time` varchar(25) DEFAULT NULL,
  `text_changed_user` varchar(200) DEFAULT NULL,
  `text_changed_date` varchar(35) DEFAULT NULL,
  `text_changed_time` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`text_id`),
  KEY `text_tree_id` (`text_tree_id`),
  KEY `text_gedcomnr` (`text_gedcomnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_trees`
--

CREATE TABLE `humo_trees` (
  `tree_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `tree_order` smallint(5) DEFAULT NULL,
  `tree_prefix` varchar(10) DEFAULT NULL,
  `tree_date` varchar(20) DEFAULT NULL,
  `tree_persons` varchar(10) DEFAULT NULL,
  `tree_families` varchar(10) DEFAULT NULL,
  `tree_email` varchar(100) DEFAULT NULL,
  `tree_owner` varchar(100) DEFAULT NULL,
  `tree_pict_path` varchar(100) DEFAULT NULL,
  `tree_privacy` varchar(100) DEFAULT NULL,
  `tree_gedcom` varchar(100) DEFAULT NULL,
  `tree_gedcom_program` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`tree_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `humo_trees`
--

INSERT INTO `humo_trees` VALUES
(1, 1, 'humo_', '[[tree_date]]', '0', '0', '', '', '|../pictures/', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `humo_tree_texts`
--

CREATE TABLE `humo_tree_texts` (
  `treetext_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `treetext_tree_id` smallint(5) DEFAULT NULL,
  `treetext_language` varchar(100) DEFAULT NULL,
  `treetext_name` varchar(100) DEFAULT NULL,
  `treetext_mainmenu_text` text,
  `treetext_mainmenu_source` text,
  `treetext_family_top` text,
  `treetext_family_footer` text,
  PRIMARY KEY (`treetext_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_unprocessed_tags`
--

CREATE TABLE `humo_unprocessed_tags` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_pers_id` int(10) DEFAULT NULL,
  `tag_rel_id` int(10) DEFAULT NULL,
  `tag_event_id` int(10) DEFAULT NULL,
  `tag_source_id` int(10) DEFAULT NULL,
  `tag_connect_id` int(10) DEFAULT NULL,
  `tag_repo_id` int(10) DEFAULT NULL,
  `tag_place_id` int(10) DEFAULT NULL,
  `tag_address_id` int(10) DEFAULT NULL,
  `tag_text_id` int(10) DEFAULT NULL,
  `tag_tree_id` smallint(5) DEFAULT NULL,
  `tag_tag` text,
  PRIMARY KEY (`tag_id`),
  KEY `tag_tree_id` (`tag_tree_id`),
  KEY `tag_pers_id` (`tag_pers_id`),
  KEY `tag_rel_id` (`tag_rel_id`),
  KEY `tag_event_id` (`tag_event_id`),
  KEY `tag_source_id` (`tag_source_id`),
  KEY `tag_connect_id` (`tag_connect_id`),
  KEY `tag_repo_id` (`tag_repo_id`),
  KEY `tag_place_id` (`tag_place_id`),
  KEY `tag_address_id` (`tag_address_id`),
  KEY `tag_text_id` (`tag_text_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_users`
--

CREATE TABLE `humo_users` (
  `user_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(25) DEFAULT NULL,
  `user_mail` varchar(100) DEFAULT NULL,
  `user_trees` text,
  `user_remark` text,
  `user_password` varchar(50) DEFAULT NULL,
  `user_password_salted` varchar(255) DEFAULT NULL,
  `user_2fa_enabled` varchar(1) DEFAULT '',
  `user_2fa_auth_secret` varchar(50) DEFAULT '',
  `user_status` varchar(1) DEFAULT NULL,
  `user_group_id` smallint(5) DEFAULT NULL,
  `user_hide_trees` varchar(200) NOT NULL DEFAULT '',
  `user_edit_trees` varchar(200) NOT NULL DEFAULT '',
  `user_ip_address` varchar(45) DEFAULT '',
  `user_register_date` varchar(20) DEFAULT NULL,
  `user_last_visit` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `humo_users`
--

INSERT INTO `humo_users` VALUES
(1, '[[admin_username]]', NULL, NULL, NULL, NULL, '[[admin_pass]]', '', '', NULL, 1, '', '', '', NULL, NULL),
(2, 'family', NULL, NULL, NULL, NULL, '[[admin_pass]]', '', '', NULL, 2, '', '', '', NULL, NULL),
(3, 'guest', NULL, NULL, NULL, NULL, '$2y$10$CCxlCbfIncuHx13fUDzz9OFWtH6drEBH4TQ1JVtfHzmBf.8Z.Wkpq', '', '', NULL, 3, '', '', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `humo_user_log`
--

CREATE TABLE `humo_user_log` (
  `log_id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `log_username` varchar(25) DEFAULT NULL,
  `log_date` varchar(20) DEFAULT NULL,
  `log_ip_address` varchar(45) DEFAULT '',
  `log_user_admin` varchar(5) DEFAULT '',
  `log_status` varchar(10) DEFAULT '',
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `humo_user_notes`
--

CREATE TABLE `humo_user_notes` (
  `note_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `note_order` smallint(5) DEFAULT NULL,
  `note_new_date` varchar(20) DEFAULT NULL,
  `note_new_time` varchar(25) DEFAULT NULL,
  `note_new_user_id` smallint(5) DEFAULT NULL,
  `note_changed_date` varchar(20) DEFAULT NULL,
  `note_changed_time` varchar(25) DEFAULT NULL,
  `note_changed_user_id` smallint(5) DEFAULT NULL,
  `note_guest_name` varchar(25) DEFAULT NULL,
  `note_guest_mail` varchar(25) DEFAULT NULL,
  `note_note` text,
  `note_status` varchar(15) DEFAULT NULL,
  `note_priority` varchar(15) DEFAULT NULL,
  `note_tree_id` mediumint(7) DEFAULT NULL,
  `note_kind` varchar(10) DEFAULT NULL,
  `note_connect_kind` varchar(20) DEFAULT NULL,
  `note_connect_id` varchar(25) DEFAULT NULL,
  `note_names` text,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
